// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iot1clickprojects.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iot1clickprojects.model.*
import aws.sdk.kotlin.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.AssociateDeviceWithPlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.CreatePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.CreatePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.CreateProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.CreateProjectResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DeletePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DeletePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DeleteProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DeleteProjectResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribeProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribeProjectResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.GetDevicesInPlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.GetDevicesInPlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListPlacementsRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListPlacementsResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListProjectsRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListProjectsResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.TagResourceRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.TagResourceResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.UntagResourceRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.UntagResourceResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdatePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdatePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdateProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdateProjectResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The AWS IoT 1-Click Projects API Reference
 */
public interface Iot1ClickProjectsClient : SdkClient {

    override val serviceName: String
        get() = "IoT 1Click Projects"
    /**
     * Iot1ClickProjectsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Iot1ClickProjectsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIot1ClickProjectsClient(config)
        }

        public operator fun invoke(config: Config): Iot1ClickProjectsClient = DefaultIot1ClickProjectsClient(config)

        /**
         * Construct a [Iot1ClickProjectsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Iot1ClickProjectsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIot1ClickProjectsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a physical device with a placement.
     */
    public suspend fun associateDeviceWithPlacement(input: AssociateDeviceWithPlacementRequest): AssociateDeviceWithPlacementResponse

    /**
     * Creates an empty placement.
     */
    public suspend fun createPlacement(input: CreatePlacementRequest): CreatePlacementResponse

    /**
     * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the placement template defined in the project.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Deletes a placement. To delete a placement, it must not have any devices associated with it.
     *
     * When you delete a placement, all associated data becomes irretrievable.
     */
    public suspend fun deletePlacement(input: DeletePlacementRequest): DeletePlacementResponse

    /**
     * Deletes a project. To delete a project, it must not have any placements associated with it.
     *
     * When you delete a project, all associated data becomes irretrievable.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Describes a placement in a project.
     */
    public suspend fun describePlacement(input: DescribePlacementRequest): DescribePlacementResponse

    /**
     * Returns an object describing a project.
     */
    public suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Removes a physical device from a placement.
     */
    public suspend fun disassociateDeviceFromPlacement(input: DisassociateDeviceFromPlacementRequest): DisassociateDeviceFromPlacementResponse

    /**
     * Returns an object enumerating the devices in a placement.
     */
    public suspend fun getDevicesInPlacement(input: GetDevicesInPlacementRequest): GetDevicesInPlacementResponse

    /**
     * Lists the placement(s) of a project.
     */
    public suspend fun listPlacements(input: ListPlacementsRequest): ListPlacementsResponse

    /**
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest {}): ListProjectsResponse

    /**
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a resource. For more information, see [AWS Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags (metadata key/value pairs) from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
     */
    public suspend fun updatePlacement(input: UpdatePlacementRequest): UpdatePlacementResponse

    /**
     * Updates a project associated with your AWS account and region. With the exception of device template names, you can pass just the values that need to be updated because the update request will change only the values that are provided. To clear a value, pass the empty string (i.e., `""`).
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse
}

/**
 * Associates a physical device with a placement.
 */
public suspend inline fun Iot1ClickProjectsClient.associateDeviceWithPlacement(crossinline block: AssociateDeviceWithPlacementRequest.Builder.() -> Unit): AssociateDeviceWithPlacementResponse = associateDeviceWithPlacement(AssociateDeviceWithPlacementRequest.Builder().apply(block).build())

/**
 * Creates an empty placement.
 */
public suspend inline fun Iot1ClickProjectsClient.createPlacement(crossinline block: CreatePlacementRequest.Builder.() -> Unit): CreatePlacementResponse = createPlacement(CreatePlacementRequest.Builder().apply(block).build())

/**
 * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the placement template defined in the project.
 */
public suspend inline fun Iot1ClickProjectsClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Deletes a placement. To delete a placement, it must not have any devices associated with it.
 *
 * When you delete a placement, all associated data becomes irretrievable.
 */
public suspend inline fun Iot1ClickProjectsClient.deletePlacement(crossinline block: DeletePlacementRequest.Builder.() -> Unit): DeletePlacementResponse = deletePlacement(DeletePlacementRequest.Builder().apply(block).build())

/**
 * Deletes a project. To delete a project, it must not have any placements associated with it.
 *
 * When you delete a project, all associated data becomes irretrievable.
 */
public suspend inline fun Iot1ClickProjectsClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Describes a placement in a project.
 */
public suspend inline fun Iot1ClickProjectsClient.describePlacement(crossinline block: DescribePlacementRequest.Builder.() -> Unit): DescribePlacementResponse = describePlacement(DescribePlacementRequest.Builder().apply(block).build())

/**
 * Returns an object describing a project.
 */
public suspend inline fun Iot1ClickProjectsClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit): DescribeProjectResponse = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Removes a physical device from a placement.
 */
public suspend inline fun Iot1ClickProjectsClient.disassociateDeviceFromPlacement(crossinline block: DisassociateDeviceFromPlacementRequest.Builder.() -> Unit): DisassociateDeviceFromPlacementResponse = disassociateDeviceFromPlacement(DisassociateDeviceFromPlacementRequest.Builder().apply(block).build())

/**
 * Returns an object enumerating the devices in a placement.
 */
public suspend inline fun Iot1ClickProjectsClient.getDevicesInPlacement(crossinline block: GetDevicesInPlacementRequest.Builder.() -> Unit): GetDevicesInPlacementResponse = getDevicesInPlacement(GetDevicesInPlacementRequest.Builder().apply(block).build())

/**
 * Lists the placement(s) of a project.
 */
public suspend inline fun Iot1ClickProjectsClient.listPlacements(crossinline block: ListPlacementsRequest.Builder.() -> Unit): ListPlacementsResponse = listPlacements(ListPlacementsRequest.Builder().apply(block).build())

/**
 * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
 */
public suspend inline fun Iot1ClickProjectsClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
 */
public suspend inline fun Iot1ClickProjectsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a resource. For more information, see [AWS Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
 */
public suspend inline fun Iot1ClickProjectsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags (metadata key/value pairs) from a resource.
 */
public suspend inline fun Iot1ClickProjectsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
 */
public suspend inline fun Iot1ClickProjectsClient.updatePlacement(crossinline block: UpdatePlacementRequest.Builder.() -> Unit): UpdatePlacementResponse = updatePlacement(UpdatePlacementRequest.Builder().apply(block).build())

/**
 * Updates a project associated with your AWS account and region. With the exception of device template names, you can pass just the values that need to be updated because the update request will change only the values that are provided. To clear a value, pass the empty string (i.e., `""`).
 */
public suspend inline fun Iot1ClickProjectsClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())
