// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.Iot1ClickDevicesException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ClaimDevicesByClaimCodeOperationDeserializer: HttpDeserialize<ClaimDevicesByClaimCodeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ClaimDevicesByClaimCodeResponse {
        if (!response.status.isSuccess()) {
            throwClaimDevicesByClaimCodeError(context, response)
        }
        val builder = ClaimDevicesByClaimCodeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeClaimDevicesByClaimCodeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwClaimDevicesByClaimCodeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Iot1ClickDevicesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Iot1ClickDevicesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeClaimDevicesByClaimCodeOperationBody(builder: ClaimDevicesByClaimCodeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLAIMCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("claimCode"))
    val TOTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("total"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLAIMCODE_DESCRIPTOR)
        field(TOTAL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLAIMCODE_DESCRIPTOR.index -> builder.claimCode = deserializeString()
                TOTAL_DESCRIPTOR.index -> builder.total = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
