// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.EndpointProvider
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.*
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.DescribeDeviceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.FinalizeDeviceClaimRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.FinalizeDeviceClaimResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.GetDeviceMethodsRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.GetDeviceMethodsResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InitiateDeviceClaimRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InitiateDeviceClaimResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InvokeDeviceMethodRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InvokeDeviceMethodResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDeviceEventsRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDeviceEventsResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDevicesRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDevicesResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.TagResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.TagResourceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UnclaimDeviceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UnclaimDeviceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UntagResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UntagResourceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UpdateDeviceStateRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UpdateDeviceStateResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * Describes all of the AWS IoT 1-Click device-related API operations for the service. Also provides sample requests, responses, and errors for the supported web services protocols.
 */
public interface Iot1ClickDevicesClient : SdkClient {

    override val serviceName: String
        get() = "IoT 1Click Devices Service"
    /**
     * Iot1ClickDevicesClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Iot1ClickDevicesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIot1ClickDevicesClient(config)
        }

        public operator fun invoke(config: Config): Iot1ClickDevicesClient = DefaultIot1ClickDevicesClient(config)

        /**
         * Construct a [Iot1ClickDevicesClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Iot1ClickDevicesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIot1ClickDevicesClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "IoT 1Click Devices Service")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
     */
    public suspend fun claimDevicesByClaimCode(input: ClaimDevicesByClaimCodeRequest): ClaimDevicesByClaimCodeResponse

    /**
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     */
    public suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Given a device ID, finalizes the claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    public suspend fun finalizeDeviceClaim(input: FinalizeDeviceClaimRequest): FinalizeDeviceClaimResponse

    /**
     * Given a device ID, returns the invokable methods associated with the device.
     */
    public suspend fun getDeviceMethods(input: GetDeviceMethodsRequest): GetDeviceMethodsResponse

    /**
     * Given a device ID, initiates a claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    public suspend fun initiateDeviceClaim(input: InitiateDeviceClaimRequest): InitiateDeviceClaimResponse

    /**
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
     */
    public suspend fun invokeDeviceMethod(input: InvokeDeviceMethodRequest): InvokeDeviceMethodResponse

    /**
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     */
    public suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse

    /**
     * Lists the 1-Click compatible devices associated with your AWS account.
     */
    public suspend fun listDevices(input: ListDevicesRequest = ListDevicesRequest {}): ListDevicesResponse

    /**
     * Lists the tags associated with the specified resource ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates a device from your AWS account using its device ID.
     */
    public suspend fun unclaimDevice(input: UnclaimDeviceRequest): UnclaimDeviceResponse

    /**
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     */
    public suspend fun updateDeviceState(input: UpdateDeviceStateRequest): UpdateDeviceStateResponse
}

/**
 * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
 */
public suspend inline fun Iot1ClickDevicesClient.claimDevicesByClaimCode(crossinline block: ClaimDevicesByClaimCodeRequest.Builder.() -> Unit): ClaimDevicesByClaimCodeResponse = claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest.Builder().apply(block).build())

/**
 * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
 */
public suspend inline fun Iot1ClickDevicesClient.describeDevice(crossinline block: DescribeDeviceRequest.Builder.() -> Unit): DescribeDeviceResponse = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

/**
 * Given a device ID, finalizes the claim request for the associated device.
 *
 * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
 */
public suspend inline fun Iot1ClickDevicesClient.finalizeDeviceClaim(crossinline block: FinalizeDeviceClaimRequest.Builder.() -> Unit): FinalizeDeviceClaimResponse = finalizeDeviceClaim(FinalizeDeviceClaimRequest.Builder().apply(block).build())

/**
 * Given a device ID, returns the invokable methods associated with the device.
 */
public suspend inline fun Iot1ClickDevicesClient.getDeviceMethods(crossinline block: GetDeviceMethodsRequest.Builder.() -> Unit): GetDeviceMethodsResponse = getDeviceMethods(GetDeviceMethodsRequest.Builder().apply(block).build())

/**
 * Given a device ID, initiates a claim request for the associated device.
 *
 * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
 */
public suspend inline fun Iot1ClickDevicesClient.initiateDeviceClaim(crossinline block: InitiateDeviceClaimRequest.Builder.() -> Unit): InitiateDeviceClaimResponse = initiateDeviceClaim(InitiateDeviceClaimRequest.Builder().apply(block).build())

/**
 * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
 */
public suspend inline fun Iot1ClickDevicesClient.invokeDeviceMethod(crossinline block: InvokeDeviceMethodRequest.Builder.() -> Unit): InvokeDeviceMethodResponse = invokeDeviceMethod(InvokeDeviceMethodRequest.Builder().apply(block).build())

/**
 * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
 */
public suspend inline fun Iot1ClickDevicesClient.listDeviceEvents(crossinline block: ListDeviceEventsRequest.Builder.() -> Unit): ListDeviceEventsResponse = listDeviceEvents(ListDeviceEventsRequest.Builder().apply(block).build())

/**
 * Lists the 1-Click compatible devices associated with your AWS account.
 */
public suspend inline fun Iot1ClickDevicesClient.listDevices(crossinline block: ListDevicesRequest.Builder.() -> Unit): ListDevicesResponse = listDevices(ListDevicesRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with the specified resource ARN.
 */
public suspend inline fun Iot1ClickDevicesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
 */
public suspend inline fun Iot1ClickDevicesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates a device from your AWS account using its device ID.
 */
public suspend inline fun Iot1ClickDevicesClient.unclaimDevice(crossinline block: UnclaimDeviceRequest.Builder.() -> Unit): UnclaimDeviceResponse = unclaimDevice(UnclaimDeviceRequest.Builder().apply(block).build())

/**
 * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
 */
public suspend inline fun Iot1ClickDevicesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
 */
public suspend inline fun Iot1ClickDevicesClient.updateDeviceState(crossinline block: UpdateDeviceStateRequest.Builder.() -> Unit): UpdateDeviceStateResponse = updateDeviceState(UpdateDeviceStateRequest.Builder().apply(block).build())
