// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.*
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.DescribeDeviceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.FinalizeDeviceClaimRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.GetDeviceMethodsRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InitiateDeviceClaimRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InvokeDeviceMethodRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDeviceEventsRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDevicesRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.TagResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UnclaimDeviceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UntagResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UpdateDeviceStateRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "IoT 1Click Devices Service"
public const val ServiceApiVersion: String = "2018-05-14"
public const val SdkVersion: String = "0.19.3-beta"

internal class DefaultIot1ClickDevicesClient(override val config: Iot1ClickDevicesClient.Config) : Iot1ClickDevicesClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
     */
    override suspend fun claimDevicesByClaimCode(input: ClaimDevicesByClaimCodeRequest): ClaimDevicesByClaimCodeResponse {
        val op = SdkHttpOperation.build<ClaimDevicesByClaimCodeRequest, ClaimDevicesByClaimCodeResponse> {
            serializer = ClaimDevicesByClaimCodeOperationSerializer()
            deserializer = ClaimDevicesByClaimCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ClaimDevicesByClaimCode"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ClaimDevicesByClaimCodeRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ClaimDevicesByClaimCode-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     */
    override suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse {
        val op = SdkHttpOperation.build<DescribeDeviceRequest, DescribeDeviceResponse> {
            serializer = DescribeDeviceOperationSerializer()
            deserializer = DescribeDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDevice"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeDeviceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDevice-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Given a device ID, finalizes the claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    override suspend fun finalizeDeviceClaim(input: FinalizeDeviceClaimRequest): FinalizeDeviceClaimResponse {
        val op = SdkHttpOperation.build<FinalizeDeviceClaimRequest, FinalizeDeviceClaimResponse> {
            serializer = FinalizeDeviceClaimOperationSerializer()
            deserializer = FinalizeDeviceClaimOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "FinalizeDeviceClaim"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<FinalizeDeviceClaimRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("FinalizeDeviceClaim-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Given a device ID, returns the invokable methods associated with the device.
     */
    override suspend fun getDeviceMethods(input: GetDeviceMethodsRequest): GetDeviceMethodsResponse {
        val op = SdkHttpOperation.build<GetDeviceMethodsRequest, GetDeviceMethodsResponse> {
            serializer = GetDeviceMethodsOperationSerializer()
            deserializer = GetDeviceMethodsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeviceMethods"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetDeviceMethodsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDeviceMethods-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Given a device ID, initiates a claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    override suspend fun initiateDeviceClaim(input: InitiateDeviceClaimRequest): InitiateDeviceClaimResponse {
        val op = SdkHttpOperation.build<InitiateDeviceClaimRequest, InitiateDeviceClaimResponse> {
            serializer = InitiateDeviceClaimOperationSerializer()
            deserializer = InitiateDeviceClaimOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InitiateDeviceClaim"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<InitiateDeviceClaimRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("InitiateDeviceClaim-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
     */
    override suspend fun invokeDeviceMethod(input: InvokeDeviceMethodRequest): InvokeDeviceMethodResponse {
        val op = SdkHttpOperation.build<InvokeDeviceMethodRequest, InvokeDeviceMethodResponse> {
            serializer = InvokeDeviceMethodOperationSerializer()
            deserializer = InvokeDeviceMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InvokeDeviceMethod"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<InvokeDeviceMethodRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("InvokeDeviceMethod-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     */
    override suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse {
        val op = SdkHttpOperation.build<ListDeviceEventsRequest, ListDeviceEventsResponse> {
            serializer = ListDeviceEventsOperationSerializer()
            deserializer = ListDeviceEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeviceEvents"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDeviceEventsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDeviceEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the 1-Click compatible devices associated with your AWS account.
     */
    override suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse {
        val op = SdkHttpOperation.build<ListDevicesRequest, ListDevicesResponse> {
            serializer = ListDevicesOperationSerializer()
            deserializer = ListDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevices"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDevicesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDevices-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the tags associated with the specified resource ARN.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a device from your AWS account using its device ID.
     */
    override suspend fun unclaimDevice(input: UnclaimDeviceRequest): UnclaimDeviceResponse {
        val op = SdkHttpOperation.build<UnclaimDeviceRequest, UnclaimDeviceResponse> {
            serializer = UnclaimDeviceOperationSerializer()
            deserializer = UnclaimDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnclaimDevice"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UnclaimDeviceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UnclaimDevice-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     */
    override suspend fun updateDeviceState(input: UpdateDeviceStateRequest): UpdateDeviceStateResponse {
        val op = SdkHttpOperation.build<UpdateDeviceStateRequest, UpdateDeviceStateResponse> {
            serializer = UpdateDeviceStateOperationSerializer()
            deserializer = UpdateDeviceStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDeviceState"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDeviceStateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iot1click"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDeviceState-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iot1click")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
