// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iot1clickdevicesservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Describes all of the AWS IoT 1-Click device-related API operations for the service. Also provides sample requests, responses, and errors for the supported web services protocols.
 */
interface Iot1ClickDevicesClient : SdkClient {

    override val serviceName: String
        get() = "IoT 1Click Devices Service"
    /**
     * Iot1ClickDevicesClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): Iot1ClickDevicesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIot1ClickDevicesClient(config)
        }

        operator fun invoke(config: Config): Iot1ClickDevicesClient = DefaultIot1ClickDevicesClient(config)

        /**
         * Construct a [Iot1ClickDevicesClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Iot1ClickDevicesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIot1ClickDevicesClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
     */
    suspend fun claimDevicesByClaimCode(input: ClaimDevicesByClaimCodeRequest): ClaimDevicesByClaimCodeResponse

    /**
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
     */
    suspend fun claimDevicesByClaimCode(block: ClaimDevicesByClaimCodeRequest.Builder.() -> Unit) = claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest.Builder().apply(block).build())

    /**
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     */
    suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     */
    suspend fun describeDevice(block: DescribeDeviceRequest.Builder.() -> Unit) = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

    /**
     * Given a device ID, finalizes the claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    suspend fun finalizeDeviceClaim(input: FinalizeDeviceClaimRequest): FinalizeDeviceClaimResponse

    /**
     * Given a device ID, finalizes the claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    suspend fun finalizeDeviceClaim(block: FinalizeDeviceClaimRequest.Builder.() -> Unit) = finalizeDeviceClaim(FinalizeDeviceClaimRequest.Builder().apply(block).build())

    /**
     * Given a device ID, returns the invokable methods associated with the device.
     */
    suspend fun getDeviceMethods(input: GetDeviceMethodsRequest): GetDeviceMethodsResponse

    /**
     * Given a device ID, returns the invokable methods associated with the device.
     */
    suspend fun getDeviceMethods(block: GetDeviceMethodsRequest.Builder.() -> Unit) = getDeviceMethods(GetDeviceMethodsRequest.Builder().apply(block).build())

    /**
     * Given a device ID, initiates a claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    suspend fun initiateDeviceClaim(input: InitiateDeviceClaimRequest): InitiateDeviceClaimResponse

    /**
     * Given a device ID, initiates a claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    suspend fun initiateDeviceClaim(block: InitiateDeviceClaimRequest.Builder.() -> Unit) = initiateDeviceClaim(InitiateDeviceClaimRequest.Builder().apply(block).build())

    /**
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
     */
    suspend fun invokeDeviceMethod(input: InvokeDeviceMethodRequest): InvokeDeviceMethodResponse

    /**
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
     */
    suspend fun invokeDeviceMethod(block: InvokeDeviceMethodRequest.Builder.() -> Unit) = invokeDeviceMethod(InvokeDeviceMethodRequest.Builder().apply(block).build())

    /**
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     */
    suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse

    /**
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     */
    suspend fun listDeviceEvents(block: ListDeviceEventsRequest.Builder.() -> Unit) = listDeviceEvents(ListDeviceEventsRequest.Builder().apply(block).build())

    /**
     * Lists the 1-Click compatible devices associated with your AWS account.
     */
    suspend fun listDevices(input: ListDevicesRequest = ListDevicesRequest {}): ListDevicesResponse

    /**
     * Lists the 1-Click compatible devices associated with your AWS account.
     */
    suspend fun listDevices(block: ListDevicesRequest.Builder.() -> Unit) = listDevices(ListDevicesRequest.Builder().apply(block).build())

    /**
     * Lists the tags associated with the specified resource ARN.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags associated with the specified resource ARN.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Disassociates a device from your AWS account using its device ID.
     */
    suspend fun unclaimDevice(input: UnclaimDeviceRequest): UnclaimDeviceResponse

    /**
     * Disassociates a device from your AWS account using its device ID.
     */
    suspend fun unclaimDevice(block: UnclaimDeviceRequest.Builder.() -> Unit) = unclaimDevice(UnclaimDeviceRequest.Builder().apply(block).build())

    /**
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     */
    suspend fun updateDeviceState(input: UpdateDeviceStateRequest): UpdateDeviceStateResponse

    /**
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     */
    suspend fun updateDeviceState(block: UpdateDeviceStateRequest.Builder.() -> Unit) = updateDeviceState(UpdateDeviceStateRequest.Builder().apply(block).build())
}
