// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.*
import aws.sdk.kotlin.services.iot1clickdevicesservice.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoT 1Click Devices Service"
const val ServiceApiVersion: String = "2018-05-14"
const val SdkVersion: String = "0.16.2-beta"

internal class DefaultIot1ClickDevicesClient(override val config: Iot1ClickDevicesClient.Config) : Iot1ClickDevicesClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
     */
    override suspend fun claimDevicesByClaimCode(input: ClaimDevicesByClaimCodeRequest): ClaimDevicesByClaimCodeResponse {
        val op = SdkHttpOperation.build<ClaimDevicesByClaimCodeRequest, ClaimDevicesByClaimCodeResponse> {
            serializer = ClaimDevicesByClaimCodeOperationSerializer()
            deserializer = ClaimDevicesByClaimCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ClaimDevicesByClaimCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     */
    override suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse {
        val op = SdkHttpOperation.build<DescribeDeviceRequest, DescribeDeviceResponse> {
            serializer = DescribeDeviceOperationSerializer()
            deserializer = DescribeDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Given a device ID, finalizes the claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    override suspend fun finalizeDeviceClaim(input: FinalizeDeviceClaimRequest): FinalizeDeviceClaimResponse {
        val op = SdkHttpOperation.build<FinalizeDeviceClaimRequest, FinalizeDeviceClaimResponse> {
            serializer = FinalizeDeviceClaimOperationSerializer()
            deserializer = FinalizeDeviceClaimOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "FinalizeDeviceClaim"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Given a device ID, returns the invokable methods associated with the device.
     */
    override suspend fun getDeviceMethods(input: GetDeviceMethodsRequest): GetDeviceMethodsResponse {
        val op = SdkHttpOperation.build<GetDeviceMethodsRequest, GetDeviceMethodsResponse> {
            serializer = GetDeviceMethodsOperationSerializer()
            deserializer = GetDeviceMethodsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeviceMethods"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Given a device ID, initiates a claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    override suspend fun initiateDeviceClaim(input: InitiateDeviceClaimRequest): InitiateDeviceClaimResponse {
        val op = SdkHttpOperation.build<InitiateDeviceClaimRequest, InitiateDeviceClaimResponse> {
            serializer = InitiateDeviceClaimOperationSerializer()
            deserializer = InitiateDeviceClaimOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InitiateDeviceClaim"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
     */
    override suspend fun invokeDeviceMethod(input: InvokeDeviceMethodRequest): InvokeDeviceMethodResponse {
        val op = SdkHttpOperation.build<InvokeDeviceMethodRequest, InvokeDeviceMethodResponse> {
            serializer = InvokeDeviceMethodOperationSerializer()
            deserializer = InvokeDeviceMethodOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InvokeDeviceMethod"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     */
    override suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse {
        val op = SdkHttpOperation.build<ListDeviceEventsRequest, ListDeviceEventsResponse> {
            serializer = ListDeviceEventsOperationSerializer()
            deserializer = ListDeviceEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeviceEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the 1-Click compatible devices associated with your AWS account.
     */
    override suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse {
        val op = SdkHttpOperation.build<ListDevicesRequest, ListDevicesResponse> {
            serializer = ListDevicesOperationSerializer()
            deserializer = ListDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags associated with the specified resource ARN.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a device from your AWS account using its device ID.
     */
    override suspend fun unclaimDevice(input: UnclaimDeviceRequest): UnclaimDeviceResponse {
        val op = SdkHttpOperation.build<UnclaimDeviceRequest, UnclaimDeviceResponse> {
            serializer = UnclaimDeviceOperationSerializer()
            deserializer = UnclaimDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnclaimDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     */
    override suspend fun updateDeviceState(input: UpdateDeviceStateRequest): UpdateDeviceStateResponse {
        val op = SdkHttpOperation.build<UpdateDeviceStateRequest, UpdateDeviceStateResponse> {
            serializer = UpdateDeviceStateOperationSerializer()
            deserializer = UpdateDeviceStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDeviceState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iot1click"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iot1click")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
