// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice.serde

import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.Iot1ClickDevicesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ClaimDevicesByClaimCodeOperationDeserializer: HttpDeserialize<ClaimDevicesByClaimCodeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ClaimDevicesByClaimCodeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwClaimDevicesByClaimCodeError(context, call)
        }
        val builder = ClaimDevicesByClaimCodeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeClaimDevicesByClaimCodeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwClaimDevicesByClaimCodeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Iot1ClickDevicesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Iot1ClickDevicesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeClaimDevicesByClaimCodeOperationBody(builder: ClaimDevicesByClaimCodeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLAIMCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("claimCode"))
    val TOTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("total"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLAIMCODE_DESCRIPTOR)
        field(TOTAL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLAIMCODE_DESCRIPTOR.index -> builder.claimCode = deserializeString()
                TOTAL_DESCRIPTOR.index -> builder.total = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
