// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickdevicesservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iot1clickdevicesservice.auth.DefaultIot1ClickDevicesAuthSchemeProvider
import aws.sdk.kotlin.services.iot1clickdevicesservice.auth.Iot1ClickDevicesAuthSchemeProvider
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.DefaultIot1ClickDevicesEndpointProvider
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.Iot1ClickDevicesEndpointParameters
import aws.sdk.kotlin.services.iot1clickdevicesservice.endpoints.Iot1ClickDevicesEndpointProvider
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ClaimDevicesByClaimCodeResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.DescribeDeviceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.FinalizeDeviceClaimRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.FinalizeDeviceClaimResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.GetDeviceMethodsRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.GetDeviceMethodsResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InitiateDeviceClaimRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InitiateDeviceClaimResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InvokeDeviceMethodRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.InvokeDeviceMethodResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDeviceEventsRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDeviceEventsResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDevicesRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListDevicesResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.TagResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.TagResourceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UnclaimDeviceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UnclaimDeviceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UntagResourceRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UntagResourceResponse
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UpdateDeviceStateRequest
import aws.sdk.kotlin.services.iot1clickdevicesservice.model.UpdateDeviceStateResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IoT 1Click Devices Service"
public const val SdkVersion: String = "1.0.73"
public const val ServiceApiVersion: String = "2018-05-14"

/**
 * Describes all of the AWS IoT 1-Click device-related API operations for the service. Also provides sample requests, responses, and errors for the supported web services protocols.
 */
public interface Iot1ClickDevicesClient : SdkClient {
    /**
     * Iot1ClickDevicesClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Iot1ClickDevicesClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Iot1ClickDevices",
                "IOT_1CLICK_DEVICES_SERVICE",
                "iot_1click_devices_service",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Iot1ClickDevicesClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Iot1ClickDevicesClient = DefaultIot1ClickDevicesClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: Iot1ClickDevicesEndpointProvider = builder.endpointProvider ?: DefaultIot1ClickDevicesEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: Iot1ClickDevicesAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIot1ClickDevicesAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT 1Click Devices Service"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: Iot1ClickDevicesEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: Iot1ClickDevicesAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
     */
    public suspend fun claimDevicesByClaimCode(input: ClaimDevicesByClaimCodeRequest): ClaimDevicesByClaimCodeResponse

    /**
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     */
    public suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Given a device ID, finalizes the claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    public suspend fun finalizeDeviceClaim(input: FinalizeDeviceClaimRequest): FinalizeDeviceClaimResponse

    /**
     * Given a device ID, returns the invokable methods associated with the device.
     */
    public suspend fun getDeviceMethods(input: GetDeviceMethodsRequest): GetDeviceMethodsResponse

    /**
     * Given a device ID, initiates a claim request for the associated device.
     *
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
     */
    public suspend fun initiateDeviceClaim(input: InitiateDeviceClaimRequest): InitiateDeviceClaimResponse

    /**
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
     */
    public suspend fun invokeDeviceMethod(input: InvokeDeviceMethodRequest): InvokeDeviceMethodResponse

    /**
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     */
    public suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse

    /**
     * Lists the 1-Click compatible devices associated with your AWS account.
     */
    public suspend fun listDevices(input: ListDevicesRequest = ListDevicesRequest { }): ListDevicesResponse

    /**
     * Lists the tags associated with the specified resource ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates a device from your AWS account using its device ID.
     */
    public suspend fun unclaimDevice(input: UnclaimDeviceRequest): UnclaimDeviceResponse

    /**
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     */
    public suspend fun updateDeviceState(input: UpdateDeviceStateRequest): UpdateDeviceStateResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Iot1ClickDevicesClient.withConfig(block: Iot1ClickDevicesClient.Config.Builder.() -> Unit): Iot1ClickDevicesClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIot1ClickDevicesClient(newConfig)
}

/**
 * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with the device(s).
 */
public suspend inline fun Iot1ClickDevicesClient.claimDevicesByClaimCode(crossinline block: ClaimDevicesByClaimCodeRequest.Builder.() -> Unit): ClaimDevicesByClaimCodeResponse = claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest.Builder().apply(block).build())

/**
 * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
 */
public suspend inline fun Iot1ClickDevicesClient.describeDevice(crossinline block: DescribeDeviceRequest.Builder.() -> Unit): DescribeDeviceResponse = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

/**
 * Given a device ID, finalizes the claim request for the associated device.
 *
 * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
 */
public suspend inline fun Iot1ClickDevicesClient.finalizeDeviceClaim(crossinline block: FinalizeDeviceClaimRequest.Builder.() -> Unit): FinalizeDeviceClaimResponse = finalizeDeviceClaim(FinalizeDeviceClaimRequest.Builder().apply(block).build())

/**
 * Given a device ID, returns the invokable methods associated with the device.
 */
public suspend inline fun Iot1ClickDevicesClient.getDeviceMethods(crossinline block: GetDeviceMethodsRequest.Builder.() -> Unit): GetDeviceMethodsResponse = getDeviceMethods(GetDeviceMethodsRequest.Builder().apply(block).build())

/**
 * Given a device ID, initiates a claim request for the associated device.
 *
 * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a device of type button, a device event can be published by simply clicking the device.
 */
public suspend inline fun Iot1ClickDevicesClient.initiateDeviceClaim(crossinline block: InitiateDeviceClaimRequest.Builder.() -> Unit): InitiateDeviceClaimResponse = initiateDeviceClaim(InitiateDeviceClaimRequest.Builder().apply(block).build())

/**
 * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the "Example POST" code snippet below.
 */
public suspend inline fun Iot1ClickDevicesClient.invokeDeviceMethod(crossinline block: InvokeDeviceMethodRequest.Builder.() -> Unit): InvokeDeviceMethodResponse = invokeDeviceMethod(InvokeDeviceMethodRequest.Builder().apply(block).build())

/**
 * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
 */
public suspend inline fun Iot1ClickDevicesClient.listDeviceEvents(crossinline block: ListDeviceEventsRequest.Builder.() -> Unit): ListDeviceEventsResponse = listDeviceEvents(ListDeviceEventsRequest.Builder().apply(block).build())

/**
 * Lists the 1-Click compatible devices associated with your AWS account.
 */
public suspend inline fun Iot1ClickDevicesClient.listDevices(crossinline block: ListDevicesRequest.Builder.() -> Unit): ListDevicesResponse = listDevices(ListDevicesRequest.Builder().apply(block).build())

/**
 * Lists the tags associated with the specified resource ARN.
 */
public suspend inline fun Iot1ClickDevicesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds or updates the tags associated with the resource ARN. See [AWS IoT 1-Click Service Limits](https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits) for the maximum number of tags allowed per resource.
 */
public suspend inline fun Iot1ClickDevicesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates a device from your AWS account using its device ID.
 */
public suspend inline fun Iot1ClickDevicesClient.unclaimDevice(crossinline block: UnclaimDeviceRequest.Builder.() -> Unit): UnclaimDeviceResponse = unclaimDevice(UnclaimDeviceRequest.Builder().apply(block).build())

/**
 * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
 */
public suspend inline fun Iot1ClickDevicesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
 */
public suspend inline fun Iot1ClickDevicesClient.updateDeviceState(crossinline block: UpdateDeviceStateRequest.Builder.() -> Unit): UpdateDeviceStateResponse = updateDeviceState(UpdateDeviceStateRequest.Builder().apply(block).build())
