// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.GetV2LoggingOptionsResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.LogLevel
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetV2LoggingOptionsOperationDeserializer: HttpDeserialize<GetV2LoggingOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetV2LoggingOptionsResponse {
        if (!response.status.isSuccess()) {
            throwGetV2LoggingOptionsError(context, response)
        }
        val builder = GetV2LoggingOptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetV2LoggingOptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetV2LoggingOptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotConfiguredException" -> NotConfiguredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetV2LoggingOptionsOperationBody(builder: GetV2LoggingOptionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEFAULTLOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("defaultLogLevel"))
    val DISABLEALLLOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableAllLogs"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTLOGLEVEL_DESCRIPTOR)
        field(DISABLEALLLOGS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEFAULTLOGLEVEL_DESCRIPTOR.index -> builder.defaultLogLevel = deserializeString().let { LogLevel.fromValue(it) }
                DISABLEALLLOGS_DESCRIPTOR.index -> builder.disableAllLogs = deserializeBoolean()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
