// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.GetPolicyVersionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetPolicyVersionOperationDeserializer: HttpDeserialize<GetPolicyVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPolicyVersionResponse {
        if (!response.status.isSuccess()) {
            throwGetPolicyVersionError(context, response)
        }
        val builder = GetPolicyVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPolicyVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPolicyVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPolicyVersionOperationBody(builder: GetPolicyVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val GENERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("generationId"))
    val ISDEFAULTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isDefaultVersion"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyArn"))
    val POLICYDOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyDocument"))
    val POLICYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyName"))
    val POLICYVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyVersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATE_DESCRIPTOR)
        field(GENERATIONID_DESCRIPTOR)
        field(ISDEFAULTVERSION_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
        field(POLICYDOCUMENT_DESCRIPTOR)
        field(POLICYNAME_DESCRIPTOR)
        field(POLICYVERSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                GENERATIONID_DESCRIPTOR.index -> builder.generationId = deserializeString()
                ISDEFAULTVERSION_DESCRIPTOR.index -> builder.isDefaultVersion = deserializeBoolean()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                POLICYARN_DESCRIPTOR.index -> builder.policyArn = deserializeString()
                POLICYDOCUMENT_DESCRIPTOR.index -> builder.policyDocument = deserializeString()
                POLICYNAME_DESCRIPTOR.index -> builder.policyName = deserializeString()
                POLICYVERSIONID_DESCRIPTOR.index -> builder.policyVersionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
