// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The input for the UpdateThing operation.
 */
public class UpdateThingRequest private constructor(builder: Builder) {
    /**
     * A list of thing attributes, a JSON string containing name-value pairs. For example:
     *
     * `{\"attributes\":{\"name1\":\"value2\"}}`
     *
     * This data is used to add new attributes or update existing attributes.
     */
    public val attributePayload: aws.sdk.kotlin.services.iot.model.AttributePayload? = builder.attributePayload
    /**
     * The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the `UpdateThing` request is rejected with a `VersionConflictException`.
     */
    public val expectedVersion: kotlin.Long? = builder.expectedVersion
    /**
     * Remove a thing type association. If **true**, the association is removed.
     */
    public val removeThingType: kotlin.Boolean = builder.removeThingType
    /**
     * The name of the thing to update.
     *
     * You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
     */
    public val thingName: kotlin.String? = requireNotNull(builder.thingName) { "A non-null value must be provided for thingName" }
    /**
     * The name of the thing type.
     */
    public val thingTypeName: kotlin.String? = builder.thingTypeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateThingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateThingRequest(")
        append("attributePayload=$attributePayload,")
        append("expectedVersion=$expectedVersion,")
        append("removeThingType=$removeThingType,")
        append("thingName=$thingName,")
        append("thingTypeName=$thingTypeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributePayload?.hashCode() ?: 0
        result = 31 * result + (expectedVersion?.hashCode() ?: 0)
        result = 31 * result + (removeThingType.hashCode())
        result = 31 * result + (thingName?.hashCode() ?: 0)
        result = 31 * result + (thingTypeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateThingRequest

        if (attributePayload != other.attributePayload) return false
        if (expectedVersion != other.expectedVersion) return false
        if (removeThingType != other.removeThingType) return false
        if (thingName != other.thingName) return false
        if (thingTypeName != other.thingTypeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateThingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of thing attributes, a JSON string containing name-value pairs. For example:
         *
         * `{\"attributes\":{\"name1\":\"value2\"}}`
         *
         * This data is used to add new attributes or update existing attributes.
         */
        public var attributePayload: aws.sdk.kotlin.services.iot.model.AttributePayload? = null
        /**
         * The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the `UpdateThing` request is rejected with a `VersionConflictException`.
         */
        public var expectedVersion: kotlin.Long? = null
        /**
         * Remove a thing type association. If **true**, the association is removed.
         */
        public var removeThingType: kotlin.Boolean = false
        /**
         * The name of the thing to update.
         *
         * You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
         */
        public var thingName: kotlin.String? = null
        /**
         * The name of the thing type.
         */
        public var thingTypeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateThingRequest) : this() {
            this.attributePayload = x.attributePayload
            this.expectedVersion = x.expectedVersion
            this.removeThingType = x.removeThingType
            this.thingName = x.thingName
            this.thingTypeName = x.thingTypeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateThingRequest = UpdateThingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AttributePayload] inside the given [block]
         */
        public fun attributePayload(block: aws.sdk.kotlin.services.iot.model.AttributePayload.Builder.() -> kotlin.Unit) {
            this.attributePayload = aws.sdk.kotlin.services.iot.model.AttributePayload.invoke(block)
        }
    }
}
