// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table. For more information, see the [Timestream](https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html) topic rule action documentation.
 */
public class TimestreamAction private constructor(builder: Builder) {
    /**
     * The name of an Amazon Timestream database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * Metadata attributes of the time series that are written in each measure record.
     */
    public val dimensions: List<TimestreamDimension>? = builder.dimensions
    /**
     * The ARN of the role that grants permission to write to the Amazon Timestream database table.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name of the database table into which to write the measure records.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * Specifies an application-defined value to replace the default value assigned to the Timestream record's timestamp in the `time` column.
     *
     * You can use this property to specify the value and the precision of the Timestream record's timestamp. You can specify a value from the message payload or a value computed by a substitution template.
     *
     * If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it processed the rule.
     */
    public val timestamp: aws.sdk.kotlin.services.iot.model.TimestreamTimestamp? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TimestreamAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimestreamAction(")
        append("databaseName=$databaseName,")
        append("dimensions=$dimensions,")
        append("roleArn=$roleArn,")
        append("tableName=$tableName,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimestreamAction

        if (databaseName != other.databaseName) return false
        if (dimensions != other.dimensions) return false
        if (roleArn != other.roleArn) return false
        if (tableName != other.tableName) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TimestreamAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of an Amazon Timestream database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * Metadata attributes of the time series that are written in each measure record.
         */
        public var dimensions: List<TimestreamDimension>? = null
        /**
         * The ARN of the role that grants permission to write to the Amazon Timestream database table.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the database table into which to write the measure records.
         */
        public var tableName: kotlin.String? = null
        /**
         * Specifies an application-defined value to replace the default value assigned to the Timestream record's timestamp in the `time` column.
         *
         * You can use this property to specify the value and the precision of the Timestream record's timestamp. You can specify a value from the message payload or a value computed by a substitution template.
         *
         * If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it processed the rule.
         */
        public var timestamp: aws.sdk.kotlin.services.iot.model.TimestreamTimestamp? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TimestreamAction) : this() {
            this.databaseName = x.databaseName
            this.dimensions = x.dimensions
            this.roleArn = x.roleArn
            this.tableName = x.tableName
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TimestreamAction = TimestreamAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimestreamTimestamp] inside the given [block]
         */
        public fun timestamp(block: aws.sdk.kotlin.services.iot.model.TimestreamTimestamp.Builder.() -> kotlin.Unit) {
            this.timestamp = aws.sdk.kotlin.services.iot.model.TimestreamTimestamp.invoke(block)
        }
    }
}
