// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Allows you to create an exponential rate of rollout for a job.
 */
public class ExponentialRolloutRate private constructor(builder: Builder) {
    /**
     * The minimum number of things that will be notified of a pending job, per minute at the start of job rollout. This parameter allows you to define the initial rate of rollout.
     */
    public val baseRatePerMinute: kotlin.Int? = builder.baseRatePerMinute
    /**
     * The exponential factor to increase the rate of rollout for a job.
     *
     * Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).
     */
    public val incrementFactor: kotlin.Double = builder.incrementFactor
    /**
     * The criteria to initiate the increase in rate of rollout for a job.
     */
    public val rateIncreaseCriteria: aws.sdk.kotlin.services.iot.model.RateIncreaseCriteria? = builder.rateIncreaseCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ExponentialRolloutRate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExponentialRolloutRate(")
        append("baseRatePerMinute=$baseRatePerMinute,")
        append("incrementFactor=$incrementFactor,")
        append("rateIncreaseCriteria=$rateIncreaseCriteria)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseRatePerMinute ?: 0
        result = 31 * result + (incrementFactor.hashCode())
        result = 31 * result + (rateIncreaseCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExponentialRolloutRate

        if (baseRatePerMinute != other.baseRatePerMinute) return false
        if (incrementFactor != other.incrementFactor) return false
        if (rateIncreaseCriteria != other.rateIncreaseCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ExponentialRolloutRate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum number of things that will be notified of a pending job, per minute at the start of job rollout. This parameter allows you to define the initial rate of rollout.
         */
        public var baseRatePerMinute: kotlin.Int? = null
        /**
         * The exponential factor to increase the rate of rollout for a job.
         *
         * Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).
         */
        public var incrementFactor: kotlin.Double = 0.0
        /**
         * The criteria to initiate the increase in rate of rollout for a job.
         */
        public var rateIncreaseCriteria: aws.sdk.kotlin.services.iot.model.RateIncreaseCriteria? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ExponentialRolloutRate) : this() {
            this.baseRatePerMinute = x.baseRatePerMinute
            this.incrementFactor = x.incrementFactor
            this.rateIncreaseCriteria = x.rateIncreaseCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ExponentialRolloutRate = ExponentialRolloutRate(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.RateIncreaseCriteria] inside the given [block]
         */
        public fun rateIncreaseCriteria(block: aws.sdk.kotlin.services.iot.model.RateIncreaseCriteria.Builder.() -> kotlin.Unit) {
            this.rateIncreaseCriteria = aws.sdk.kotlin.services.iot.model.RateIncreaseCriteria.invoke(block)
        }
    }
}
