// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action that writes data to an Amazon OpenSearch Service domain.
 *
 * The `Elasticsearch` action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the `OpenSearch` rule action instead. For more information, see [OpenSearchAction](https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html).
 */
public class ElasticsearchAction private constructor(builder: Builder) {
    /**
     * The endpoint of your OpenSearch domain.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The unique identifier for the document you are storing.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The index where you want to store your data.
     */
    public val index: kotlin.String? = builder.index
    /**
     * The IAM role ARN that has access to OpenSearch.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The type of document you are storing.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ElasticsearchAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticsearchAction(")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("index=$index,")
        append("roleArn=$roleArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpoint?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (index?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ElasticsearchAction

        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (index != other.index) return false
        if (roleArn != other.roleArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ElasticsearchAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The endpoint of your OpenSearch domain.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The unique identifier for the document you are storing.
         */
        public var id: kotlin.String? = null
        /**
         * The index where you want to store your data.
         */
        public var index: kotlin.String? = null
        /**
         * The IAM role ARN that has access to OpenSearch.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The type of document you are storing.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ElasticsearchAction) : this() {
            this.endpoint = x.endpoint
            this.id = x.id
            this.index = x.index
            this.roleArn = x.roleArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ElasticsearchAction = ElasticsearchAction(this)
    }
}
