// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The summary of a domain configuration. A domain configuration specifies custom IoT-specific information about a domain. A domain configuration can be associated with an Amazon Web Services-managed domain (for example, dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a default endpoint.
 * + Data
 * + Jobs
 * + CredentialProvider
 */
public class DomainConfigurationSummary private constructor(builder: Builder) {
    /**
     * The ARN of the domain configuration.
     */
    public val domainConfigurationArn: kotlin.String? = builder.domainConfigurationArn
    /**
     * The name of the domain configuration. This value must be unique to a region.
     */
    public val domainConfigurationName: kotlin.String? = builder.domainConfigurationName
    /**
     * The type of service delivered by the endpoint.
     */
    public val serviceType: aws.sdk.kotlin.services.iot.model.ServiceType? = builder.serviceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DomainConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainConfigurationSummary(")
        append("domainConfigurationArn=$domainConfigurationArn,")
        append("domainConfigurationName=$domainConfigurationName,")
        append("serviceType=$serviceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainConfigurationArn?.hashCode() ?: 0
        result = 31 * result + (domainConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainConfigurationSummary

        if (domainConfigurationArn != other.domainConfigurationArn) return false
        if (domainConfigurationName != other.domainConfigurationName) return false
        if (serviceType != other.serviceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DomainConfigurationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the domain configuration.
         */
        public var domainConfigurationArn: kotlin.String? = null
        /**
         * The name of the domain configuration. This value must be unique to a region.
         */
        public var domainConfigurationName: kotlin.String? = null
        /**
         * The type of service delivered by the endpoint.
         */
        public var serviceType: aws.sdk.kotlin.services.iot.model.ServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DomainConfigurationSummary) : this() {
            this.domainConfigurationArn = x.domainConfigurationArn
            this.domainConfigurationName = x.domainConfigurationName
            this.serviceType = x.serviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DomainConfigurationSummary = DomainConfigurationSummary(this)
    }
}
