// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes a custom method used to code sign a file.
 */
public class CustomCodeSigning private constructor(builder: Builder) {
    /**
     * The certificate chain.
     */
    public val certificateChain: aws.sdk.kotlin.services.iot.model.CodeSigningCertificateChain? = builder.certificateChain
    /**
     * The hash algorithm used to code sign the file. You can use a string as the algorithm name if the target over-the-air (OTA) update devices are able to verify the signature that was generated using the same signature algorithm. For example, FreeRTOS uses `SHA256` or `SHA1`, so you can pass either of them based on which was used for generating the signature.
     */
    public val hashAlgorithm: kotlin.String? = builder.hashAlgorithm
    /**
     * The signature for the file.
     */
    public val signature: aws.sdk.kotlin.services.iot.model.CodeSigningSignature? = builder.signature
    /**
     * The signature algorithm used to code sign the file. You can use a string as the algorithm name if the target over-the-air (OTA) update devices are able to verify the signature that was generated using the same signature algorithm. For example, FreeRTOS uses `ECDSA` or `RSA`, so you can pass either of them based on which was used for generating the signature.
     */
    public val signatureAlgorithm: kotlin.String? = builder.signatureAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CustomCodeSigning = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomCodeSigning(")
        append("certificateChain=$certificateChain,")
        append("hashAlgorithm=$hashAlgorithm,")
        append("signature=$signature,")
        append("signatureAlgorithm=$signatureAlgorithm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateChain?.hashCode() ?: 0
        result = 31 * result + (hashAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (signature?.hashCode() ?: 0)
        result = 31 * result + (signatureAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomCodeSigning

        if (certificateChain != other.certificateChain) return false
        if (hashAlgorithm != other.hashAlgorithm) return false
        if (signature != other.signature) return false
        if (signatureAlgorithm != other.signatureAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CustomCodeSigning = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The certificate chain.
         */
        public var certificateChain: aws.sdk.kotlin.services.iot.model.CodeSigningCertificateChain? = null
        /**
         * The hash algorithm used to code sign the file. You can use a string as the algorithm name if the target over-the-air (OTA) update devices are able to verify the signature that was generated using the same signature algorithm. For example, FreeRTOS uses `SHA256` or `SHA1`, so you can pass either of them based on which was used for generating the signature.
         */
        public var hashAlgorithm: kotlin.String? = null
        /**
         * The signature for the file.
         */
        public var signature: aws.sdk.kotlin.services.iot.model.CodeSigningSignature? = null
        /**
         * The signature algorithm used to code sign the file. You can use a string as the algorithm name if the target over-the-air (OTA) update devices are able to verify the signature that was generated using the same signature algorithm. For example, FreeRTOS uses `ECDSA` or `RSA`, so you can pass either of them based on which was used for generating the signature.
         */
        public var signatureAlgorithm: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CustomCodeSigning) : this() {
            this.certificateChain = x.certificateChain
            this.hashAlgorithm = x.hashAlgorithm
            this.signature = x.signature
            this.signatureAlgorithm = x.signatureAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CustomCodeSigning = CustomCodeSigning(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CodeSigningCertificateChain] inside the given [block]
         */
        public fun certificateChain(block: aws.sdk.kotlin.services.iot.model.CodeSigningCertificateChain.Builder.() -> kotlin.Unit) {
            this.certificateChain = aws.sdk.kotlin.services.iot.model.CodeSigningCertificateChain.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.CodeSigningSignature] inside the given [block]
         */
        public fun signature(block: aws.sdk.kotlin.services.iot.model.CodeSigningSignature.Builder.() -> kotlin.Unit) {
            this.signature = aws.sdk.kotlin.services.iot.model.CodeSigningSignature.invoke(block)
        }
    }
}
