// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Describes an action that captures a CloudWatch metric.
 */
public class CloudwatchMetricAction private constructor(builder: Builder) {
    /**
     * The CloudWatch metric name.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * The CloudWatch metric namespace name.
     */
    public val metricNamespace: kotlin.String? = builder.metricNamespace
    /**
     * An optional [Unix timestamp](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
     */
    public val metricTimestamp: kotlin.String? = builder.metricTimestamp
    /**
     * The [metric unit](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit) supported by CloudWatch.
     */
    public val metricUnit: kotlin.String? = builder.metricUnit
    /**
     * The CloudWatch metric value.
     */
    public val metricValue: kotlin.String? = builder.metricValue
    /**
     * The IAM role that allows access to the CloudWatch metric.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudwatchMetricAction(")
        append("metricName=$metricName,")
        append("metricNamespace=$metricNamespace,")
        append("metricTimestamp=$metricTimestamp,")
        append("metricUnit=$metricUnit,")
        append("metricValue=$metricValue,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricName?.hashCode() ?: 0
        result = 31 * result + (metricNamespace?.hashCode() ?: 0)
        result = 31 * result + (metricTimestamp?.hashCode() ?: 0)
        result = 31 * result + (metricUnit?.hashCode() ?: 0)
        result = 31 * result + (metricValue?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudwatchMetricAction

        if (metricName != other.metricName) return false
        if (metricNamespace != other.metricNamespace) return false
        if (metricTimestamp != other.metricTimestamp) return false
        if (metricUnit != other.metricUnit) return false
        if (metricValue != other.metricValue) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CloudWatch metric name.
         */
        public var metricName: kotlin.String? = null
        /**
         * The CloudWatch metric namespace name.
         */
        public var metricNamespace: kotlin.String? = null
        /**
         * An optional [Unix timestamp](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp).
         */
        public var metricTimestamp: kotlin.String? = null
        /**
         * The [metric unit](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit) supported by CloudWatch.
         */
        public var metricUnit: kotlin.String? = null
        /**
         * The CloudWatch metric value.
         */
        public var metricValue: kotlin.String? = null
        /**
         * The IAM role that allows access to the CloudWatch metric.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction) : this() {
            this.metricName = x.metricName
            this.metricNamespace = x.metricNamespace
            this.metricTimestamp = x.metricTimestamp
            this.metricUnit = x.metricUnit
            this.metricValue = x.metricValue
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CloudwatchMetricAction = CloudwatchMetricAction(this)
    }
}
