// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AttributePayload
import aws.sdk.kotlin.services.iot.model.UpdateThingRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateThingOperationSerializer: HttpSerialize<UpdateThingRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateThingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "things",
                "${input.thingName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateThingOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateThingOperationBody(context: ExecutionContext, input: UpdateThingRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTEPAYLOAD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("attributePayload"))
    val EXPECTEDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("expectedVersion"))
    val REMOVETHINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("removeThingType"))
    val THINGTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingTypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEPAYLOAD_DESCRIPTOR)
        field(EXPECTEDVERSION_DESCRIPTOR)
        field(REMOVETHINGTYPE_DESCRIPTOR)
        field(THINGTYPENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributePayload?.let { field(ATTRIBUTEPAYLOAD_DESCRIPTOR, it, ::serializeAttributePayloadDocument) }
        input.expectedVersion?.let { field(EXPECTEDVERSION_DESCRIPTOR, it) }
        if (input.removeThingType != false) field(REMOVETHINGTYPE_DESCRIPTOR, input.removeThingType)
        input.thingTypeName?.let { field(THINGTYPENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
