// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.TestInvokeAuthorizerResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestInvokeAuthorizerOperationDeserializer: HttpDeserialize<TestInvokeAuthorizerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TestInvokeAuthorizerResponse {
        if (!response.status.isSuccess()) {
            throwTestInvokeAuthorizerError(context, response)
        }
        val builder = TestInvokeAuthorizerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTestInvokeAuthorizerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwTestInvokeAuthorizerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidResponseException" -> InvalidResponseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestInvokeAuthorizerOperationBody(builder: TestInvokeAuthorizerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DISCONNECTAFTERINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("disconnectAfterInSeconds"))
    val ISAUTHENTICATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isAuthenticated"))
    val POLICYDOCUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("policyDocuments"))
    val PRINCIPALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("principalId"))
    val REFRESHAFTERINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("refreshAfterInSeconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DISCONNECTAFTERINSECONDS_DESCRIPTOR)
        field(ISAUTHENTICATED_DESCRIPTOR)
        field(POLICYDOCUMENTS_DESCRIPTOR)
        field(PRINCIPALID_DESCRIPTOR)
        field(REFRESHAFTERINSECONDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DISCONNECTAFTERINSECONDS_DESCRIPTOR.index -> builder.disconnectAfterInSeconds = deserializeInt()
                ISAUTHENTICATED_DESCRIPTOR.index -> builder.isAuthenticated = deserializeBoolean()
                POLICYDOCUMENTS_DESCRIPTOR.index -> builder.policyDocuments =
                    deserializer.deserializeList(POLICYDOCUMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRINCIPALID_DESCRIPTOR.index -> builder.principalId = deserializeString()
                REFRESHAFTERINSECONDS_DESCRIPTOR.index -> builder.refreshAfterInSeconds = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
