// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.BillingGroupMetadata
import aws.sdk.kotlin.services.iot.model.BillingGroupProperties
import aws.sdk.kotlin.services.iot.model.DescribeBillingGroupResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeBillingGroupOperationDeserializer: HttpDeserialize<DescribeBillingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeBillingGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeBillingGroupError(context, response)
        }
        val builder = DescribeBillingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBillingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeBillingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBillingGroupOperationBody(builder: DescribeBillingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BILLINGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("billingGroupArn"))
    val BILLINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("billingGroupId"))
    val BILLINGGROUPMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("billingGroupMetadata"))
    val BILLINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("billingGroupName"))
    val BILLINGGROUPPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("billingGroupProperties"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BILLINGGROUPARN_DESCRIPTOR)
        field(BILLINGGROUPID_DESCRIPTOR)
        field(BILLINGGROUPMETADATA_DESCRIPTOR)
        field(BILLINGGROUPNAME_DESCRIPTOR)
        field(BILLINGGROUPPROPERTIES_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BILLINGGROUPARN_DESCRIPTOR.index -> builder.billingGroupArn = deserializeString()
                BILLINGGROUPID_DESCRIPTOR.index -> builder.billingGroupId = deserializeString()
                BILLINGGROUPMETADATA_DESCRIPTOR.index -> builder.billingGroupMetadata = deserializeBillingGroupMetadataDocument(deserializer)
                BILLINGGROUPNAME_DESCRIPTOR.index -> builder.billingGroupName = deserializeString()
                BILLINGGROUPPROPERTIES_DESCRIPTOR.index -> builder.billingGroupProperties = deserializeBillingGroupPropertiesDocument(deserializer)
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
