// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The job execution summary.
 */
class JobExecutionSummary private constructor(builder: Builder) {
    /**
     * A string (consisting of the digits "0" through "9") which identifies this particular job execution on
     * this particular device. It can be used later in commands which return or update job execution
     * information.
     */
    val executionNumber: kotlin.Long? = builder.executionNumber
    /**
     * The time, in seconds since the epoch, when the job execution was last updated.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The time, in seconds since the epoch, when the job execution was queued.
     */
    val queuedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.queuedAt
    /**
     * The number that indicates how many retry attempts have been completed for this
     * job on this device.
     */
    val retryAttempt: kotlin.Int? = builder.retryAttempt
    /**
     * The time, in seconds since the epoch, when the job execution started.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the job execution.
     */
    val status: aws.sdk.kotlin.services.iot.model.JobExecutionStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.JobExecutionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobExecutionSummary(")
        append("executionNumber=$executionNumber,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("queuedAt=$queuedAt,")
        append("retryAttempt=$retryAttempt,")
        append("startedAt=$startedAt,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionNumber?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (queuedAt?.hashCode() ?: 0)
        result = 31 * result + (retryAttempt ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobExecutionSummary

        if (executionNumber != other.executionNumber) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (queuedAt != other.queuedAt) return false
        if (retryAttempt != other.retryAttempt) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.JobExecutionSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * A string (consisting of the digits "0" through "9") which identifies this particular job execution on
         * this particular device. It can be used later in commands which return or update job execution
         * information.
         */
        var executionNumber: kotlin.Long? = null
        /**
         * The time, in seconds since the epoch, when the job execution was last updated.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in seconds since the epoch, when the job execution was queued.
         */
        var queuedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number that indicates how many retry attempts have been completed for this
         * job on this device.
         */
        var retryAttempt: kotlin.Int? = null
        /**
         * The time, in seconds since the epoch, when the job execution started.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the job execution.
         */
        var status: aws.sdk.kotlin.services.iot.model.JobExecutionStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.JobExecutionSummary) : this() {
            this.executionNumber = x.executionNumber
            this.lastUpdatedAt = x.lastUpdatedAt
            this.queuedAt = x.queuedAt
            this.retryAttempt = x.retryAttempt
            this.startedAt = x.startedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.JobExecutionSummary = JobExecutionSummary(this)
    }
}
