// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CreateCustomMetricRequest private constructor(builder: Builder) {
    /**
     * Each custom
     * metric must have a unique client request token. If you try to create a new custom metric that
     * already exists with a different token,
     * an exception
     * occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The friendly name in the console for the custom metric. This name doesn't have to be
     * unique. Don't use this name as the metric identifier in the device metric report. You can
     * update the friendly name after you define it.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the custom metric. This will be used in the metric report submitted from the
     * device/thing. The name can't begin with aws:. You can't change the name after you
     * define it.
     */
    val metricName: kotlin.String? = builder.metricName
    /**
     * The type of the custom metric.
     *
     * The type number only takes a single metric value as an input, but when you
     * submit the metrics value in the DeviceMetrics report, you must pass it as an array with a
     * single value.
     */
    val metricType: aws.sdk.kotlin.services.iot.model.CustomMetricType? = builder.metricType
    /**
     * Metadata that can be used to manage the custom metric.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateCustomMetricRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomMetricRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("displayName=$displayName,")
        append("metricName=$metricName,")
        append("metricType=$metricType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (metricType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomMetricRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (displayName != other.displayName) return false
        if (metricName != other.metricName) return false
        if (metricType != other.metricType) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateCustomMetricRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Each custom
         * metric must have a unique client request token. If you try to create a new custom metric that
         * already exists with a different token,
         * an exception
         * occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The friendly name in the console for the custom metric. This name doesn't have to be
         * unique. Don't use this name as the metric identifier in the device metric report. You can
         * update the friendly name after you define it.
         */
        var displayName: kotlin.String? = null
        /**
         * The name of the custom metric. This will be used in the metric report submitted from the
         * device/thing. The name can't begin with aws:. You can't change the name after you
         * define it.
         */
        var metricName: kotlin.String? = null
        /**
         * The type of the custom metric.
         *
         * The type number only takes a single metric value as an input, but when you
         * submit the metrics value in the DeviceMetrics report, you must pass it as an array with a
         * single value.
         */
        var metricType: aws.sdk.kotlin.services.iot.model.CustomMetricType? = null
        /**
         * Metadata that can be used to manage the custom metric.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateCustomMetricRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.displayName = x.displayName
            this.metricName = x.metricName
            this.metricType = x.metricType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateCustomMetricRequest = CreateCustomMetricRequest(this)
    }
}
