// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iot.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iot.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * <fullname>IoT</fullname>
 * IoT provides secure, bi-directional communication between Internet-connected
 * devices (such as sensors, actuators, embedded devices, or smart appliances) and the Amazon Web Services
 * cloud. You can discover your custom IoT-Data endpoint to communicate with, configure
 * rules for data processing and integration with other services, organize resources
 * associated with each device (Registry), configure logging, and create and manage
 * policies and credentials to authenticate devices.
 * The service endpoints that expose this API are listed in
 * <a href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html">Amazon Web Services IoT Core Endpoints and Quotas.
 * You must use the endpoint for the region that has the resources you want to access.
 * The service name used by <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Amazon Web Services
 * Signature Version 4 to sign the request is:
 * execute-api.
 * For more information about how IoT works, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html">Developer
 * Guide.
 * For information about how to use the credentials provider for IoT, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/authorizing-direct-aws.html">Authorizing Direct Calls to Amazon Web Services Services.
 */
interface IotClient : SdkClient {

    override val serviceName: String
        get() = "IoT"
    /**
     * IotClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IotClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotClient(config)
        }

        operator fun invoke(config: Config): IotClient = DefaultIotClient(config)

        /**
         * Construct a [IotClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIotClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts a pending certificate transfer. The default state of the certificate is
     * INACTIVE.
     * To check for pending certificate transfers, call ListCertificates
     * to enumerate your certificates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AcceptCertificateTransfer action.
     */
    suspend fun acceptCertificateTransfer(input: AcceptCertificateTransferRequest): AcceptCertificateTransferResponse

    /**
     * Accepts a pending certificate transfer. The default state of the certificate is
     * INACTIVE.
     * To check for pending certificate transfers, call ListCertificates
     * to enumerate your certificates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AcceptCertificateTransfer action.
     */
    suspend fun acceptCertificateTransfer(block: AcceptCertificateTransferRequest.Builder.() -> Unit) = acceptCertificateTransfer(AcceptCertificateTransferRequest.Builder().apply(block).build())

    /**
     * Adds a thing to a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToBillingGroup action.
     */
    suspend fun addThingToBillingGroup(input: AddThingToBillingGroupRequest): AddThingToBillingGroupResponse

    /**
     * Adds a thing to a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToBillingGroup action.
     */
    suspend fun addThingToBillingGroup(block: AddThingToBillingGroupRequest.Builder.() -> Unit) = addThingToBillingGroup(AddThingToBillingGroupRequest.Builder().apply(block).build())

    /**
     * Adds a thing to a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToThingGroup action.
     */
    suspend fun addThingToThingGroup(input: AddThingToThingGroupRequest): AddThingToThingGroupResponse

    /**
     * Adds a thing to a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToThingGroup action.
     */
    suspend fun addThingToThingGroup(block: AddThingToThingGroupRequest.Builder.() -> Unit) = addThingToThingGroup(AddThingToThingGroupRequest.Builder().apply(block).build())

    /**
     * Associates a group with a continuous job. The following criteria must be met:
     *
     *
     * The job must have been created with the targetSelection field set to
     * "CONTINUOUS".
     *
     * The job status must currently be "IN_PROGRESS".
     *
     * The total number of targets associated with a job must not exceed 100.
     *
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AssociateTargetsWithJob action.
     */
    suspend fun associateTargetsWithJob(input: AssociateTargetsWithJobRequest): AssociateTargetsWithJobResponse

    /**
     * Associates a group with a continuous job. The following criteria must be met:
     *
     *
     * The job must have been created with the targetSelection field set to
     * "CONTINUOUS".
     *
     * The job status must currently be "IN_PROGRESS".
     *
     * The total number of targets associated with a job must not exceed 100.
     *
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AssociateTargetsWithJob action.
     */
    suspend fun associateTargetsWithJob(block: AssociateTargetsWithJobRequest.Builder.() -> Unit) = associateTargetsWithJob(AssociateTargetsWithJobRequest.Builder().apply(block).build())

    /**
     * Attaches the specified policy to the specified principal (certificate or other
     * credential).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPolicy action.
     */
    suspend fun attachPolicy(input: AttachPolicyRequest): AttachPolicyResponse

    /**
     * Attaches the specified policy to the specified principal (certificate or other
     * credential).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPolicy action.
     */
    suspend fun attachPolicy(block: AttachPolicyRequest.Builder.() -> Unit) = attachPolicy(AttachPolicyRequest.Builder().apply(block).build())

    /**
     * Attaches the specified policy to the specified principal (certificate or other
     * credential).
     *
     * Note: This action is deprecated. Please use AttachPolicy instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPrincipalPolicy action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun attachPrincipalPolicy(input: AttachPrincipalPolicyRequest): AttachPrincipalPolicyResponse

    /**
     * Attaches the specified policy to the specified principal (certificate or other
     * credential).
     *
     * Note: This action is deprecated. Please use AttachPolicy instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPrincipalPolicy action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun attachPrincipalPolicy(block: AttachPrincipalPolicyRequest.Builder.() -> Unit) = attachPrincipalPolicy(AttachPrincipalPolicyRequest.Builder().apply(block).build())

    /**
     * Associates a Device Defender security profile with a thing group or this account. Each
     * thing group or account can have up to five security profiles associated with it.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachSecurityProfile action.
     */
    suspend fun attachSecurityProfile(input: AttachSecurityProfileRequest): AttachSecurityProfileResponse

    /**
     * Associates a Device Defender security profile with a thing group or this account. Each
     * thing group or account can have up to five security profiles associated with it.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachSecurityProfile action.
     */
    suspend fun attachSecurityProfile(block: AttachSecurityProfileRequest.Builder.() -> Unit) = attachSecurityProfile(AttachSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Attaches the specified principal to the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachThingPrincipal action.
     */
    suspend fun attachThingPrincipal(input: AttachThingPrincipalRequest): AttachThingPrincipalResponse

    /**
     * Attaches the specified principal to the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachThingPrincipal action.
     */
    suspend fun attachThingPrincipal(block: AttachThingPrincipalRequest.Builder.() -> Unit) = attachThingPrincipal(AttachThingPrincipalRequest.Builder().apply(block).build())

    /**
     * Cancels a mitigation action task that is in progress. If the task
     * is not
     * in progress, an InvalidRequestException occurs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditMitigationActionsTask action.
     */
    suspend fun cancelAuditMitigationActionsTask(input: CancelAuditMitigationActionsTaskRequest): CancelAuditMitigationActionsTaskResponse

    /**
     * Cancels a mitigation action task that is in progress. If the task
     * is not
     * in progress, an InvalidRequestException occurs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditMitigationActionsTask action.
     */
    suspend fun cancelAuditMitigationActionsTask(block: CancelAuditMitigationActionsTaskRequest.Builder.() -> Unit) = cancelAuditMitigationActionsTask(CancelAuditMitigationActionsTaskRequest.Builder().apply(block).build())

    /**
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditTask action.
     */
    suspend fun cancelAuditTask(input: CancelAuditTaskRequest): CancelAuditTaskResponse

    /**
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditTask action.
     */
    suspend fun cancelAuditTask(block: CancelAuditTaskRequest.Builder.() -> Unit) = cancelAuditTask(CancelAuditTaskRequest.Builder().apply(block).build())

    /**
     * Cancels a pending transfer for the specified certificate.
     *
     * Note Only the transfer source account can use this
     * operation to cancel a transfer. (Transfer destinations can use RejectCertificateTransfer instead.) After transfer, IoT returns the
     * certificate to the source account in the INACTIVE state. After the destination account has
     * accepted the transfer, the transfer cannot be cancelled.
     * After a certificate transfer is cancelled, the status of the certificate changes from
     * PENDING_TRANSFER to INACTIVE.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelCertificateTransfer action.
     */
    suspend fun cancelCertificateTransfer(input: CancelCertificateTransferRequest): CancelCertificateTransferResponse

    /**
     * Cancels a pending transfer for the specified certificate.
     *
     * Note Only the transfer source account can use this
     * operation to cancel a transfer. (Transfer destinations can use RejectCertificateTransfer instead.) After transfer, IoT returns the
     * certificate to the source account in the INACTIVE state. After the destination account has
     * accepted the transfer, the transfer cannot be cancelled.
     * After a certificate transfer is cancelled, the status of the certificate changes from
     * PENDING_TRANSFER to INACTIVE.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelCertificateTransfer action.
     */
    suspend fun cancelCertificateTransfer(block: CancelCertificateTransferRequest.Builder.() -> Unit) = cancelCertificateTransfer(CancelCertificateTransferRequest.Builder().apply(block).build())

    /**
     * Cancels a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelDetectMitigationActionsTask action.
     */
    suspend fun cancelDetectMitigationActionsTask(input: CancelDetectMitigationActionsTaskRequest): CancelDetectMitigationActionsTaskResponse

    /**
     * Cancels a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelDetectMitigationActionsTask action.
     */
    suspend fun cancelDetectMitigationActionsTask(block: CancelDetectMitigationActionsTaskRequest.Builder.() -> Unit) = cancelDetectMitigationActionsTask(CancelDetectMitigationActionsTaskRequest.Builder().apply(block).build())

    /**
     * Cancels a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJob action.
     */
    suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Cancels a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJob action.
     */
    suspend fun cancelJob(block: CancelJobRequest.Builder.() -> Unit) = cancelJob(CancelJobRequest.Builder().apply(block).build())

    /**
     * Cancels the execution of a job for a given thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJobExecution action.
     */
    suspend fun cancelJobExecution(input: CancelJobExecutionRequest): CancelJobExecutionResponse

    /**
     * Cancels the execution of a job for a given thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJobExecution action.
     */
    suspend fun cancelJobExecution(block: CancelJobExecutionRequest.Builder.() -> Unit) = cancelJobExecution(CancelJobExecutionRequest.Builder().apply(block).build())

    /**
     * Clears the default authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ClearDefaultAuthorizer action.
     */
    suspend fun clearDefaultAuthorizer(input: ClearDefaultAuthorizerRequest): ClearDefaultAuthorizerResponse

    /**
     * Clears the default authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ClearDefaultAuthorizer action.
     */
    suspend fun clearDefaultAuthorizer(block: ClearDefaultAuthorizerRequest.Builder.() -> Unit) = clearDefaultAuthorizer(ClearDefaultAuthorizerRequest.Builder().apply(block).build())

    /**
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT
     * sends a confirmation message to the endpoint or base address you specify. The message
     * includes a token which you pass back when calling ConfirmTopicRuleDestination
     * to confirm that you own or have access to the endpoint.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ConfirmTopicRuleDestination action.
     */
    suspend fun confirmTopicRuleDestination(input: ConfirmTopicRuleDestinationRequest): ConfirmTopicRuleDestinationResponse

    /**
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT
     * sends a confirmation message to the endpoint or base address you specify. The message
     * includes a token which you pass back when calling ConfirmTopicRuleDestination
     * to confirm that you own or have access to the endpoint.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ConfirmTopicRuleDestination action.
     */
    suspend fun confirmTopicRuleDestination(block: ConfirmTopicRuleDestinationRequest.Builder.() -> Unit) = confirmTopicRuleDestination(ConfirmTopicRuleDestinationRequest.Builder().apply(block).build())

    /**
     * Creates a Device Defender audit suppression.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuditSuppression action.
     */
    suspend fun createAuditSuppression(input: CreateAuditSuppressionRequest): CreateAuditSuppressionResponse

    /**
     * Creates a Device Defender audit suppression.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuditSuppression action.
     */
    suspend fun createAuditSuppression(block: CreateAuditSuppressionRequest.Builder.() -> Unit) = createAuditSuppression(CreateAuditSuppressionRequest.Builder().apply(block).build())

    /**
     * Creates an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuthorizer action.
     */
    suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse

    /**
     * Creates an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuthorizer action.
     */
    suspend fun createAuthorizer(block: CreateAuthorizerRequest.Builder.() -> Unit) = createAuthorizer(CreateAuthorizerRequest.Builder().apply(block).build())

    /**
     * Creates a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateBillingGroup action.
     */
    suspend fun createBillingGroup(input: CreateBillingGroupRequest): CreateBillingGroupResponse

    /**
     * Creates a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateBillingGroup action.
     */
    suspend fun createBillingGroup(block: CreateBillingGroupRequest.Builder.() -> Unit) = createBillingGroup(CreateBillingGroupRequest.Builder().apply(block).build())

    /**
     * Creates an X.509 certificate using the specified certificate signing
     * request.
     *
     * Note: The CSR must include a public key that is either an
     * RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-512
     * curves. For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT.
     *
     * Note: Reusing the same certificate signing request (CSR)
     * results in a distinct certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCertificateFromCsr action.
     *
     * You can create multiple certificates in a batch by creating a directory, copying
     * multiple .csr files into that directory, and then specifying that directory on the command
     * line. The following commands show how to create a batch of certificates given a batch of
     * CSRs.
     * Assuming a set of CSRs are located inside of the directory
     * my-csr-directory:
     *
     * On Linux and OS X, the command is:
     *
     * $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/{}
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name
     * to the aws iot create-certificate-from-csr Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * The aws iot create-certificate-from-csr part of the command can also be run in
     * parallel to speed up the certificate creation process:
     * $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/{}
     * On Windows PowerShell, the command to create certificates for all CSRs in
     * my-csr-directory is:
     * > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/$_}
     * On a Windows command prompt, the command to create certificates for all CSRs in
     * my-csr-directory is:
     * > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
     * --certificate-signing-request file://@path"
     */
    suspend fun createCertificateFromCsr(input: CreateCertificateFromCsrRequest): CreateCertificateFromCsrResponse

    /**
     * Creates an X.509 certificate using the specified certificate signing
     * request.
     *
     * Note: The CSR must include a public key that is either an
     * RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-512
     * curves. For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT.
     *
     * Note: Reusing the same certificate signing request (CSR)
     * results in a distinct certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCertificateFromCsr action.
     *
     * You can create multiple certificates in a batch by creating a directory, copying
     * multiple .csr files into that directory, and then specifying that directory on the command
     * line. The following commands show how to create a batch of certificates given a batch of
     * CSRs.
     * Assuming a set of CSRs are located inside of the directory
     * my-csr-directory:
     *
     * On Linux and OS X, the command is:
     *
     * $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/{}
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name
     * to the aws iot create-certificate-from-csr Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * The aws iot create-certificate-from-csr part of the command can also be run in
     * parallel to speed up the certificate creation process:
     * $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/{}
     * On Windows PowerShell, the command to create certificates for all CSRs in
     * my-csr-directory is:
     * > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/$_}
     * On a Windows command prompt, the command to create certificates for all CSRs in
     * my-csr-directory is:
     * > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
     * --certificate-signing-request file://@path"
     */
    suspend fun createCertificateFromCsr(block: CreateCertificateFromCsrRequest.Builder.() -> Unit) = createCertificateFromCsr(CreateCertificateFromCsrRequest.Builder().apply(block).build())

    /**
     * Use this API to define a
     * Custom
     * Metric
     * published by your devices to Device Defender.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCustomMetric action.
     */
    suspend fun createCustomMetric(input: CreateCustomMetricRequest): CreateCustomMetricResponse

    /**
     * Use this API to define a
     * Custom
     * Metric
     * published by your devices to Device Defender.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCustomMetric action.
     */
    suspend fun createCustomMetric(block: CreateCustomMetricRequest.Builder.() -> Unit) = createCustomMetric(CreateCustomMetricRequest.Builder().apply(block).build())

    /**
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender.
     * For example, using a TOPIC_FILTER dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDimension action.
     */
    suspend fun createDimension(input: CreateDimensionRequest): CreateDimensionResponse

    /**
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender.
     * For example, using a TOPIC_FILTER dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDimension action.
     */
    suspend fun createDimension(block: CreateDimensionRequest.Builder.() -> Unit) = createDimension(CreateDimensionRequest.Builder().apply(block).build())

    /**
     * Creates a domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDomainConfiguration action.
     */
    suspend fun createDomainConfiguration(input: CreateDomainConfigurationRequest): CreateDomainConfigurationResponse

    /**
     * Creates a domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDomainConfiguration action.
     */
    suspend fun createDomainConfiguration(block: CreateDomainConfigurationRequest.Builder.() -> Unit) = createDomainConfiguration(CreateDomainConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDynamicThingGroup action.
     */
    suspend fun createDynamicThingGroup(input: CreateDynamicThingGroupRequest): CreateDynamicThingGroupResponse

    /**
     * Creates a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDynamicThingGroup action.
     */
    suspend fun createDynamicThingGroup(block: CreateDynamicThingGroupRequest.Builder.() -> Unit) = createDynamicThingGroup(CreateDynamicThingGroupRequest.Builder().apply(block).build())

    /**
     * Creates a fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateFleetMetric action.
     */
    suspend fun createFleetMetric(input: CreateFleetMetricRequest): CreateFleetMetricResponse

    /**
     * Creates a fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateFleetMetric action.
     */
    suspend fun createFleetMetric(block: CreateFleetMetricRequest.Builder.() -> Unit) = createFleetMetric(CreateFleetMetricRequest.Builder().apply(block).build())

    /**
     * Creates a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJob action.
     */
    suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * Creates a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJob action.
     */
    suspend fun createJob(block: CreateJobRequest.Builder.() -> Unit) = createJob(CreateJobRequest.Builder().apply(block).build())

    /**
     * Creates a job template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJobTemplate action.
     */
    suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse

    /**
     * Creates a job template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJobTemplate action.
     */
    suspend fun createJobTemplate(block: CreateJobTemplateRequest.Builder.() -> Unit) = createJobTemplate(CreateJobTemplateRequest.Builder().apply(block).build())

    /**
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued
     * public key. You can also call CreateKeysAndCertificate over MQTT from a
     * device, for more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api">Provisioning MQTT API.
     *
     * Note This is the only time IoT issues the private key
     * for this certificate, so it is important to keep it in a secure location.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateKeysAndCertificate action.
     */
    suspend fun createKeysAndCertificate(input: CreateKeysAndCertificateRequest): CreateKeysAndCertificateResponse

    /**
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued
     * public key. You can also call CreateKeysAndCertificate over MQTT from a
     * device, for more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api">Provisioning MQTT API.
     *
     * Note This is the only time IoT issues the private key
     * for this certificate, so it is important to keep it in a secure location.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateKeysAndCertificate action.
     */
    suspend fun createKeysAndCertificate(block: CreateKeysAndCertificateRequest.Builder.() -> Unit) = createKeysAndCertificate(CreateKeysAndCertificateRequest.Builder().apply(block).build())

    /**
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names.
     * For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation actions. Each mitigation action can apply only one type of change.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateMitigationAction action.
     */
    suspend fun createMitigationAction(input: CreateMitigationActionRequest): CreateMitigationActionResponse

    /**
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names.
     * For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation actions. Each mitigation action can apply only one type of change.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateMitigationAction action.
     */
    suspend fun createMitigationAction(block: CreateMitigationActionRequest.Builder.() -> Unit) = createMitigationAction(CreateMitigationActionRequest.Builder().apply(block).build())

    /**
     * Creates an IoT OTA update on a target group of things or groups.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateOTAUpdate action.
     */
    suspend fun createOtaUpdate(input: CreateOtaUpdateRequest): CreateOtaUpdateResponse

    /**
     * Creates an IoT OTA update on a target group of things or groups.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateOTAUpdate action.
     */
    suspend fun createOtaUpdate(block: CreateOtaUpdateRequest.Builder.() -> Unit) = createOtaUpdate(CreateOtaUpdateRequest.Builder().apply(block).build())

    /**
     * Creates an IoT policy.
     * The created policy is the default version for the policy. This operation creates a
     * policy version with a version identifier of 1 and sets
     * 1 as the policy's default version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicy action.
     */
    suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse

    /**
     * Creates an IoT policy.
     * The created policy is the default version for the policy. This operation creates a
     * policy version with a version identifier of 1 and sets
     * 1 as the policy's default version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicy action.
     */
    suspend fun createPolicy(block: CreatePolicyRequest.Builder.() -> Unit) = createPolicy(CreatePolicyRequest.Builder().apply(block).build())

    /**
     * Creates a new version of the specified IoT policy. To update a policy, create a
     * new policy version. A managed policy can have up to five versions. If the policy has five
     * versions, you must use DeletePolicyVersion to delete an existing version
     * before you create a new one.
     * Optionally, you can set the new version as the policy's default version. The default
     * version is the operative version (that is, the version that is in effect for the
     * certificates to which the policy is attached).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicyVersion action.
     */
    suspend fun createPolicyVersion(input: CreatePolicyVersionRequest): CreatePolicyVersionResponse

    /**
     * Creates a new version of the specified IoT policy. To update a policy, create a
     * new policy version. A managed policy can have up to five versions. If the policy has five
     * versions, you must use DeletePolicyVersion to delete an existing version
     * before you create a new one.
     * Optionally, you can set the new version as the policy's default version. The default
     * version is the operative version (that is, the version that is in effect for the
     * certificates to which the policy is attached).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicyVersion action.
     */
    suspend fun createPolicyVersion(block: CreatePolicyVersionRequest.Builder.() -> Unit) = createPolicyVersion(CreatePolicyVersionRequest.Builder().apply(block).build())

    /**
     * Creates a provisioning claim.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningClaim action.
     */
    suspend fun createProvisioningClaim(input: CreateProvisioningClaimRequest): CreateProvisioningClaimResponse

    /**
     * Creates a provisioning claim.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningClaim action.
     */
    suspend fun createProvisioningClaim(block: CreateProvisioningClaimRequest.Builder.() -> Unit) = createProvisioningClaim(CreateProvisioningClaimRequest.Builder().apply(block).build())

    /**
     * Creates a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplate action.
     */
    suspend fun createProvisioningTemplate(input: CreateProvisioningTemplateRequest): CreateProvisioningTemplateResponse

    /**
     * Creates a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplate action.
     */
    suspend fun createProvisioningTemplate(block: CreateProvisioningTemplateRequest.Builder.() -> Unit) = createProvisioningTemplate(CreateProvisioningTemplateRequest.Builder().apply(block).build())

    /**
     * Creates a new version of a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplateVersion action.
     */
    suspend fun createProvisioningTemplateVersion(input: CreateProvisioningTemplateVersionRequest): CreateProvisioningTemplateVersionResponse

    /**
     * Creates a new version of a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplateVersion action.
     */
    suspend fun createProvisioningTemplateVersion(block: CreateProvisioningTemplateVersionRequest.Builder.() -> Unit) = createProvisioningTemplateVersion(CreateProvisioningTemplateVersionRequest.Builder().apply(block).build())

    /**
     * Creates a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateRoleAlias action.
     */
    suspend fun createRoleAlias(input: CreateRoleAliasRequest): CreateRoleAliasResponse

    /**
     * Creates a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateRoleAlias action.
     */
    suspend fun createRoleAlias(block: CreateRoleAliasRequest.Builder.() -> Unit) = createRoleAlias(CreateRoleAliasRequest.Builder().apply(block).build())

    /**
     * Creates a scheduled audit that is run at a specified
     * time interval.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateScheduledAudit action.
     */
    suspend fun createScheduledAudit(input: CreateScheduledAuditRequest): CreateScheduledAuditResponse

    /**
     * Creates a scheduled audit that is run at a specified
     * time interval.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateScheduledAudit action.
     */
    suspend fun createScheduledAudit(block: CreateScheduledAuditRequest.Builder.() -> Unit) = createScheduledAudit(CreateScheduledAuditRequest.Builder().apply(block).build())

    /**
     * Creates a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSecurityProfile action.
     */
    suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse

    /**
     * Creates a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSecurityProfile action.
     */
    suspend fun createSecurityProfile(block: CreateSecurityProfileRequest.Builder.() -> Unit) = createSecurityProfile(CreateSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data
     * bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files
     * associated with a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateStream action.
     */
    suspend fun createStream(input: CreateStreamRequest): CreateStreamResponse

    /**
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data
     * bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files
     * associated with a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateStream action.
     */
    suspend fun createStream(block: CreateStreamRequest.Builder.() -> Unit) = createStream(CreateStreamRequest.Builder().apply(block).build())

    /**
     * Creates a thing record in the registry. If this call is made multiple times using
     * the same thing name and configuration, the call will succeed. If this call is made with
     * the same thing name but different configuration a
     * ResourceAlreadyExistsException is thrown.
     *
     * This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization for
     * information about authorizing control plane actions.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThing action.
     */
    suspend fun createThing(input: CreateThingRequest): CreateThingResponse

    /**
     * Creates a thing record in the registry. If this call is made multiple times using
     * the same thing name and configuration, the call will succeed. If this call is made with
     * the same thing name but different configuration a
     * ResourceAlreadyExistsException is thrown.
     *
     * This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization for
     * information about authorizing control plane actions.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThing action.
     */
    suspend fun createThing(block: CreateThingRequest.Builder.() -> Unit) = createThing(CreateThingRequest.Builder().apply(block).build())

    /**
     * Create a thing group.
     *
     * This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization for
     * information about authorizing control plane actions.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingGroup action.
     */
    suspend fun createThingGroup(input: CreateThingGroupRequest): CreateThingGroupResponse

    /**
     * Create a thing group.
     *
     * This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization for
     * information about authorizing control plane actions.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingGroup action.
     */
    suspend fun createThingGroup(block: CreateThingGroupRequest.Builder.() -> Unit) = createThingGroup(CreateThingGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingType action.
     */
    suspend fun createThingType(input: CreateThingTypeRequest): CreateThingTypeResponse

    /**
     * Creates a new thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingType action.
     */
    suspend fun createThingType(block: CreateThingTypeRequest.Builder.() -> Unit) = createThingType(CreateThingTypeRequest.Builder().apply(block).build())

    /**
     * Creates a rule. Creating rules is an administrator-level action. Any user who has
     * permission to create rules will be able to access data processed by the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRule action.
     */
    suspend fun createTopicRule(input: CreateTopicRuleRequest): CreateTopicRuleResponse

    /**
     * Creates a rule. Creating rules is an administrator-level action. Any user who has
     * permission to create rules will be able to access data processed by the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRule action.
     */
    suspend fun createTopicRule(block: CreateTopicRuleRequest.Builder.() -> Unit) = createTopicRule(CreateTopicRuleRequest.Builder().apply(block).build())

    /**
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRuleDestination action.
     */
    suspend fun createTopicRuleDestination(input: CreateTopicRuleDestinationRequest): CreateTopicRuleDestinationResponse

    /**
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRuleDestination action.
     */
    suspend fun createTopicRuleDestination(block: CreateTopicRuleDestinationRequest.Builder.() -> Unit) = createTopicRuleDestination(CreateTopicRuleDestinationRequest.Builder().apply(block).build())

    /**
     * Restores the default settings for Device Defender audits for this account. Any
     * configuration data you entered is deleted and all audit checks are reset to
     * disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAccountAuditConfiguration action.
     */
    suspend fun deleteAccountAuditConfiguration(input: DeleteAccountAuditConfigurationRequest): DeleteAccountAuditConfigurationResponse

    /**
     * Restores the default settings for Device Defender audits for this account. Any
     * configuration data you entered is deleted and all audit checks are reset to
     * disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAccountAuditConfiguration action.
     */
    suspend fun deleteAccountAuditConfiguration(block: DeleteAccountAuditConfigurationRequest.Builder.() -> Unit) = deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes a Device Defender audit suppression.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuditSuppression action.
     */
    suspend fun deleteAuditSuppression(input: DeleteAuditSuppressionRequest): DeleteAuditSuppressionResponse

    /**
     * Deletes a Device Defender audit suppression.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuditSuppression action.
     */
    suspend fun deleteAuditSuppression(block: DeleteAuditSuppressionRequest.Builder.() -> Unit) = deleteAuditSuppression(DeleteAuditSuppressionRequest.Builder().apply(block).build())

    /**
     * Deletes an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuthorizer action.
     */
    suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse

    /**
     * Deletes an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuthorizer action.
     */
    suspend fun deleteAuthorizer(block: DeleteAuthorizerRequest.Builder.() -> Unit) = deleteAuthorizer(DeleteAuthorizerRequest.Builder().apply(block).build())

    /**
     * Deletes the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteBillingGroup action.
     */
    suspend fun deleteBillingGroup(input: DeleteBillingGroupRequest): DeleteBillingGroupResponse

    /**
     * Deletes the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteBillingGroup action.
     */
    suspend fun deleteBillingGroup(block: DeleteBillingGroupRequest.Builder.() -> Unit) = deleteBillingGroup(DeleteBillingGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCACertificate action.
     */
    suspend fun deleteCaCertificate(input: DeleteCaCertificateRequest): DeleteCaCertificateResponse

    /**
     * Deletes a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCACertificate action.
     */
    suspend fun deleteCaCertificate(block: DeleteCaCertificateRequest.Builder.() -> Unit) = deleteCaCertificate(DeleteCaCertificateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified certificate.
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if
     * its status is set to ACTIVE. To delete a certificate, first use the DetachPolicy action to detach all policies. Next, use the UpdateCertificate action to set the certificate to the INACTIVE
     * status.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCertificate action.
     */
    suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes the specified certificate.
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if
     * its status is set to ACTIVE. To delete a certificate, first use the DetachPolicy action to detach all policies. Next, use the UpdateCertificate action to set the certificate to the INACTIVE
     * status.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCertificate action.
     */
    suspend fun deleteCertificate(block: DeleteCertificateRequest.Builder.() -> Unit) = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

    /**
     * Deletes a Device Defender detect custom metric.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCustomMetric action.
     *
     * Before you can delete a custom metric, you must first remove the custom metric from all
     * security profiles it's a part of.
     * The
     * security
     * profile associated with the custom metric can be found using the <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles
     * API with metricName set to your custom metric name.
     */
    suspend fun deleteCustomMetric(input: DeleteCustomMetricRequest): DeleteCustomMetricResponse

    /**
     * Deletes a Device Defender detect custom metric.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCustomMetric action.
     *
     * Before you can delete a custom metric, you must first remove the custom metric from all
     * security profiles it's a part of.
     * The
     * security
     * profile associated with the custom metric can be found using the <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles
     * API with metricName set to your custom metric name.
     */
    suspend fun deleteCustomMetric(block: DeleteCustomMetricRequest.Builder.() -> Unit) = deleteCustomMetric(DeleteCustomMetricRequest.Builder().apply(block).build())

    /**
     * Removes the specified dimension from your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDimension action.
     */
    suspend fun deleteDimension(input: DeleteDimensionRequest): DeleteDimensionResponse

    /**
     * Removes the specified dimension from your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDimension action.
     */
    suspend fun deleteDimension(block: DeleteDimensionRequest.Builder.() -> Unit) = deleteDimension(DeleteDimensionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDomainConfiguration action.
     */
    suspend fun deleteDomainConfiguration(input: DeleteDomainConfigurationRequest): DeleteDomainConfigurationResponse

    /**
     * Deletes the specified domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDomainConfiguration action.
     */
    suspend fun deleteDomainConfiguration(block: DeleteDomainConfigurationRequest.Builder.() -> Unit) = deleteDomainConfiguration(DeleteDomainConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDynamicThingGroup action.
     */
    suspend fun deleteDynamicThingGroup(input: DeleteDynamicThingGroupRequest): DeleteDynamicThingGroupResponse

    /**
     * Deletes a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDynamicThingGroup action.
     */
    suspend fun deleteDynamicThingGroup(block: DeleteDynamicThingGroupRequest.Builder.() -> Unit) = deleteDynamicThingGroup(DeleteDynamicThingGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified fleet metric.
     * Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteFleetMetric action.
     */
    suspend fun deleteFleetMetric(input: DeleteFleetMetricRequest): DeleteFleetMetricResponse

    /**
     * Deletes the specified fleet metric.
     * Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteFleetMetric action.
     */
    suspend fun deleteFleetMetric(block: DeleteFleetMetricRequest.Builder.() -> Unit) = deleteFleetMetric(DeleteFleetMetricRequest.Builder().apply(block).build())

    /**
     * Deletes a job and its related job executions.
     * Deleting a job may take time, depending on the number of job
     * executions created for the job and various other factors. While the job
     * is being deleted, the status of the job will be shown as
     * "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status
     * is already "DELETION_IN_PROGRESS" will result in an error.
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or
     * a LimitExceededException will occur.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJob action.
     */
    suspend fun deleteJob(input: DeleteJobRequest): DeleteJobResponse

    /**
     * Deletes a job and its related job executions.
     * Deleting a job may take time, depending on the number of job
     * executions created for the job and various other factors. While the job
     * is being deleted, the status of the job will be shown as
     * "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status
     * is already "DELETION_IN_PROGRESS" will result in an error.
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or
     * a LimitExceededException will occur.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJob action.
     */
    suspend fun deleteJob(block: DeleteJobRequest.Builder.() -> Unit) = deleteJob(DeleteJobRequest.Builder().apply(block).build())

    /**
     * Deletes a job execution.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJobExecution action.
     */
    suspend fun deleteJobExecution(input: DeleteJobExecutionRequest): DeleteJobExecutionResponse

    /**
     * Deletes a job execution.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJobExecution action.
     */
    suspend fun deleteJobExecution(block: DeleteJobExecutionRequest.Builder.() -> Unit) = deleteJobExecution(DeleteJobExecutionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified job template.
     */
    suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse

    /**
     * Deletes the specified job template.
     */
    suspend fun deleteJobTemplate(block: DeleteJobTemplateRequest.Builder.() -> Unit) = deleteJobTemplate(DeleteJobTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteMitigationAction action.
     */
    suspend fun deleteMitigationAction(input: DeleteMitigationActionRequest): DeleteMitigationActionResponse

    /**
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteMitigationAction action.
     */
    suspend fun deleteMitigationAction(block: DeleteMitigationActionRequest.Builder.() -> Unit) = deleteMitigationAction(DeleteMitigationActionRequest.Builder().apply(block).build())

    /**
     * Delete an OTA update.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteOTAUpdate action.
     */
    suspend fun deleteOtaUpdate(input: DeleteOtaUpdateRequest): DeleteOtaUpdateResponse

    /**
     * Delete an OTA update.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteOTAUpdate action.
     */
    suspend fun deleteOtaUpdate(block: DeleteOtaUpdateRequest.Builder.() -> Unit) = deleteOtaUpdate(DeleteOtaUpdateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified policy.
     * A policy cannot be deleted if it has non-default versions or it is attached to any
     * certificate.
     * To delete a policy, use the DeletePolicyVersion action to delete all non-default
     * versions of the policy; use the DetachPolicy action to detach the policy from any
     * certificate; and then use the DeletePolicy action to delete the policy.
     * When a policy is deleted using DeletePolicy, its default version is deleted with
     * it.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after
     * a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicy action.
     */
    suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the specified policy.
     * A policy cannot be deleted if it has non-default versions or it is attached to any
     * certificate.
     * To delete a policy, use the DeletePolicyVersion action to delete all non-default
     * versions of the policy; use the DetachPolicy action to detach the policy from any
     * certificate; and then use the DeletePolicy action to delete the policy.
     * When a policy is deleted using DeletePolicy, its default version is deleted with
     * it.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after
     * a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicy action.
     */
    suspend fun deletePolicy(block: DeletePolicyRequest.Builder.() -> Unit) = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified version of the specified policy. You cannot delete the default
     * version of a policy using this action. To delete the default version of a policy, use DeletePolicy. To find out which version of a policy is marked as the default
     * version, use ListPolicyVersions.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicyVersion action.
     */
    suspend fun deletePolicyVersion(input: DeletePolicyVersionRequest): DeletePolicyVersionResponse

    /**
     * Deletes the specified version of the specified policy. You cannot delete the default
     * version of a policy using this action. To delete the default version of a policy, use DeletePolicy. To find out which version of a policy is marked as the default
     * version, use ListPolicyVersions.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicyVersion action.
     */
    suspend fun deletePolicyVersion(block: DeletePolicyVersionRequest.Builder.() -> Unit) = deletePolicyVersion(DeletePolicyVersionRequest.Builder().apply(block).build())

    /**
     * Deletes a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplate action.
     */
    suspend fun deleteProvisioningTemplate(input: DeleteProvisioningTemplateRequest): DeleteProvisioningTemplateResponse

    /**
     * Deletes a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplate action.
     */
    suspend fun deleteProvisioningTemplate(block: DeleteProvisioningTemplateRequest.Builder.() -> Unit) = deleteProvisioningTemplate(DeleteProvisioningTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes a fleet provisioning template version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplateVersion action.
     */
    suspend fun deleteProvisioningTemplateVersion(input: DeleteProvisioningTemplateVersionRequest): DeleteProvisioningTemplateVersionResponse

    /**
     * Deletes a fleet provisioning template version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplateVersion action.
     */
    suspend fun deleteProvisioningTemplateVersion(block: DeleteProvisioningTemplateVersionRequest.Builder.() -> Unit) = deleteProvisioningTemplateVersion(DeleteProvisioningTemplateVersionRequest.Builder().apply(block).build())

    /**
     * Deletes a CA certificate registration code.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRegistrationCode action.
     */
    suspend fun deleteRegistrationCode(input: DeleteRegistrationCodeRequest): DeleteRegistrationCodeResponse

    /**
     * Deletes a CA certificate registration code.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRegistrationCode action.
     */
    suspend fun deleteRegistrationCode(block: DeleteRegistrationCodeRequest.Builder.() -> Unit) = deleteRegistrationCode(DeleteRegistrationCodeRequest.Builder().apply(block).build())

    /**
     * Deletes a role alias
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRoleAlias action.
     */
    suspend fun deleteRoleAlias(input: DeleteRoleAliasRequest): DeleteRoleAliasResponse

    /**
     * Deletes a role alias
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRoleAlias action.
     */
    suspend fun deleteRoleAlias(block: DeleteRoleAliasRequest.Builder.() -> Unit) = deleteRoleAlias(DeleteRoleAliasRequest.Builder().apply(block).build())

    /**
     * Deletes a scheduled audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteScheduledAudit action.
     */
    suspend fun deleteScheduledAudit(input: DeleteScheduledAuditRequest): DeleteScheduledAuditResponse

    /**
     * Deletes a scheduled audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteScheduledAudit action.
     */
    suspend fun deleteScheduledAudit(block: DeleteScheduledAuditRequest.Builder.() -> Unit) = deleteScheduledAudit(DeleteScheduledAuditRequest.Builder().apply(block).build())

    /**
     * Deletes a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSecurityProfile action.
     */
    suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse

    /**
     * Deletes a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSecurityProfile action.
     */
    suspend fun deleteSecurityProfile(block: DeleteSecurityProfileRequest.Builder.() -> Unit) = deleteSecurityProfile(DeleteSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteStream action.
     */
    suspend fun deleteStream(input: DeleteStreamRequest): DeleteStreamResponse

    /**
     * Deletes a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteStream action.
     */
    suspend fun deleteStream(block: DeleteStreamRequest.Builder.() -> Unit) = deleteStream(DeleteStreamRequest.Builder().apply(block).build())

    /**
     * Deletes the specified thing. Returns successfully with no error if the deletion is
     * successful or you specify a thing that doesn't exist.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThing action.
     */
    suspend fun deleteThing(input: DeleteThingRequest): DeleteThingResponse

    /**
     * Deletes the specified thing. Returns successfully with no error if the deletion is
     * successful or you specify a thing that doesn't exist.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThing action.
     */
    suspend fun deleteThing(block: DeleteThingRequest.Builder.() -> Unit) = deleteThing(DeleteThingRequest.Builder().apply(block).build())

    /**
     * Deletes a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingGroup action.
     */
    suspend fun deleteThingGroup(input: DeleteThingGroupRequest): DeleteThingGroupResponse

    /**
     * Deletes a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingGroup action.
     */
    suspend fun deleteThingGroup(block: DeleteThingGroupRequest.Builder.() -> Unit) = deleteThingGroup(DeleteThingGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified thing type. You cannot delete a thing type if it has things
     * associated with it. To delete a thing type, first mark it as deprecated by calling DeprecateThingType, then remove any associated things by calling UpdateThing to change the thing type on any associated thing, and
     * finally use DeleteThingType to delete the thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingType action.
     */
    suspend fun deleteThingType(input: DeleteThingTypeRequest): DeleteThingTypeResponse

    /**
     * Deletes the specified thing type. You cannot delete a thing type if it has things
     * associated with it. To delete a thing type, first mark it as deprecated by calling DeprecateThingType, then remove any associated things by calling UpdateThing to change the thing type on any associated thing, and
     * finally use DeleteThingType to delete the thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingType action.
     */
    suspend fun deleteThingType(block: DeleteThingTypeRequest.Builder.() -> Unit) = deleteThingType(DeleteThingTypeRequest.Builder().apply(block).build())

    /**
     * Deletes the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRule action.
     */
    suspend fun deleteTopicRule(input: DeleteTopicRuleRequest): DeleteTopicRuleResponse

    /**
     * Deletes the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRule action.
     */
    suspend fun deleteTopicRule(block: DeleteTopicRuleRequest.Builder.() -> Unit) = deleteTopicRule(DeleteTopicRuleRequest.Builder().apply(block).build())

    /**
     * Deletes a topic rule destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRuleDestination action.
     */
    suspend fun deleteTopicRuleDestination(input: DeleteTopicRuleDestinationRequest): DeleteTopicRuleDestinationResponse

    /**
     * Deletes a topic rule destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRuleDestination action.
     */
    suspend fun deleteTopicRuleDestination(block: DeleteTopicRuleDestinationRequest.Builder.() -> Unit) = deleteTopicRuleDestination(DeleteTopicRuleDestinationRequest.Builder().apply(block).build())

    /**
     * Deletes a logging level.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteV2LoggingLevel action.
     */
    suspend fun deleteV2LoggingLevel(input: DeleteV2LoggingLevelRequest): DeleteV2LoggingLevelResponse

    /**
     * Deletes a logging level.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteV2LoggingLevel action.
     */
    suspend fun deleteV2LoggingLevel(block: DeleteV2LoggingLevelRequest.Builder.() -> Unit) = deleteV2LoggingLevel(DeleteV2LoggingLevelRequest.Builder().apply(block).build())

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing
     * type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType action.
     */
    suspend fun deprecateThingType(input: DeprecateThingTypeRequest): DeprecateThingTypeResponse

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing
     * type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType action.
     */
    suspend fun deprecateThingType(block: DeprecateThingTypeRequest.Builder.() -> Unit) = deprecateThingType(DeprecateThingTypeRequest.Builder().apply(block).build())

    /**
     * Gets information about the Device Defender audit settings for this account.
     * Settings include how audit notifications are sent and which audit checks are
     * enabled or disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAccountAuditConfiguration action.
     */
    suspend fun describeAccountAuditConfiguration(input: DescribeAccountAuditConfigurationRequest): DescribeAccountAuditConfigurationResponse

    /**
     * Gets information about the Device Defender audit settings for this account.
     * Settings include how audit notifications are sent and which audit checks are
     * enabled or disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAccountAuditConfiguration action.
     */
    suspend fun describeAccountAuditConfiguration(block: DescribeAccountAuditConfigurationRequest.Builder.() -> Unit) = describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest.Builder().apply(block).build())

    /**
     * Gets information about a single audit finding. Properties include the reason for
     * noncompliance, the severity of the issue,
     * and the start time
     * when the audit that returned the
     * finding.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditFinding action.
     */
    suspend fun describeAuditFinding(input: DescribeAuditFindingRequest): DescribeAuditFindingResponse

    /**
     * Gets information about a single audit finding. Properties include the reason for
     * noncompliance, the severity of the issue,
     * and the start time
     * when the audit that returned the
     * finding.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditFinding action.
     */
    suspend fun describeAuditFinding(block: DescribeAuditFindingRequest.Builder.() -> Unit) = describeAuditFinding(DescribeAuditFindingRequest.Builder().apply(block).build())

    /**
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.
     */
    suspend fun describeAuditMitigationActionsTask(input: DescribeAuditMitigationActionsTaskRequest): DescribeAuditMitigationActionsTaskResponse

    /**
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.
     */
    suspend fun describeAuditMitigationActionsTask(block: DescribeAuditMitigationActionsTaskRequest.Builder.() -> Unit) = describeAuditMitigationActionsTask(DescribeAuditMitigationActionsTaskRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Defender audit suppression.
     */
    suspend fun describeAuditSuppression(input: DescribeAuditSuppressionRequest): DescribeAuditSuppressionResponse

    /**
     * Gets information about a Device Defender audit suppression.
     */
    suspend fun describeAuditSuppression(block: DescribeAuditSuppressionRequest.Builder.() -> Unit) = describeAuditSuppression(DescribeAuditSuppressionRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Defender audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditTask action.
     */
    suspend fun describeAuditTask(input: DescribeAuditTaskRequest): DescribeAuditTaskResponse

    /**
     * Gets information about a Device Defender audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditTask action.
     */
    suspend fun describeAuditTask(block: DescribeAuditTaskRequest.Builder.() -> Unit) = describeAuditTask(DescribeAuditTaskRequest.Builder().apply(block).build())

    /**
     * Describes an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuthorizer action.
     */
    suspend fun describeAuthorizer(input: DescribeAuthorizerRequest): DescribeAuthorizerResponse

    /**
     * Describes an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuthorizer action.
     */
    suspend fun describeAuthorizer(block: DescribeAuthorizerRequest.Builder.() -> Unit) = describeAuthorizer(DescribeAuthorizerRequest.Builder().apply(block).build())

    /**
     * Returns information about a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeBillingGroup action.
     */
    suspend fun describeBillingGroup(input: DescribeBillingGroupRequest): DescribeBillingGroupResponse

    /**
     * Returns information about a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeBillingGroup action.
     */
    suspend fun describeBillingGroup(block: DescribeBillingGroupRequest.Builder.() -> Unit) = describeBillingGroup(DescribeBillingGroupRequest.Builder().apply(block).build())

    /**
     * Describes a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCACertificate action.
     */
    suspend fun describeCaCertificate(input: DescribeCaCertificateRequest): DescribeCaCertificateResponse

    /**
     * Describes a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCACertificate action.
     */
    suspend fun describeCaCertificate(block: DescribeCaCertificateRequest.Builder.() -> Unit) = describeCaCertificate(DescribeCaCertificateRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCertificate action.
     */
    suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse

    /**
     * Gets information about the specified certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCertificate action.
     */
    suspend fun describeCertificate(block: DescribeCertificateRequest.Builder.() -> Unit) = describeCertificate(DescribeCertificateRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Defender detect custom metric.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCustomMetric action.
     */
    suspend fun describeCustomMetric(input: DescribeCustomMetricRequest): DescribeCustomMetricResponse

    /**
     * Gets information about a Device Defender detect custom metric.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCustomMetric action.
     */
    suspend fun describeCustomMetric(block: DescribeCustomMetricRequest.Builder.() -> Unit) = describeCustomMetric(DescribeCustomMetricRequest.Builder().apply(block).build())

    /**
     * Describes the default authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDefaultAuthorizer action.
     */
    suspend fun describeDefaultAuthorizer(input: DescribeDefaultAuthorizerRequest): DescribeDefaultAuthorizerResponse

    /**
     * Describes the default authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDefaultAuthorizer action.
     */
    suspend fun describeDefaultAuthorizer(block: DescribeDefaultAuthorizerRequest.Builder.() -> Unit) = describeDefaultAuthorizer(DescribeDefaultAuthorizerRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDetectMitigationActionsTask action.
     */
    suspend fun describeDetectMitigationActionsTask(input: DescribeDetectMitigationActionsTaskRequest): DescribeDetectMitigationActionsTaskResponse

    /**
     * Gets information about a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDetectMitigationActionsTask action.
     */
    suspend fun describeDetectMitigationActionsTask(block: DescribeDetectMitigationActionsTaskRequest.Builder.() -> Unit) = describeDetectMitigationActionsTask(DescribeDetectMitigationActionsTaskRequest.Builder().apply(block).build())

    /**
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDimension action.
     */
    suspend fun describeDimension(input: DescribeDimensionRequest): DescribeDimensionResponse

    /**
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDimension action.
     */
    suspend fun describeDimension(block: DescribeDimensionRequest.Builder.() -> Unit) = describeDimension(DescribeDimensionRequest.Builder().apply(block).build())

    /**
     * Gets summary information about a domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDomainConfiguration action.
     */
    suspend fun describeDomainConfiguration(input: DescribeDomainConfigurationRequest): DescribeDomainConfigurationResponse

    /**
     * Gets summary information about a domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDomainConfiguration action.
     */
    suspend fun describeDomainConfiguration(block: DescribeDomainConfigurationRequest.Builder.() -> Unit) = describeDomainConfiguration(DescribeDomainConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEndpoint action.
     */
    suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse

    /**
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEndpoint action.
     */
    suspend fun describeEndpoint(block: DescribeEndpointRequest.Builder.() -> Unit) = describeEndpoint(DescribeEndpointRequest.Builder().apply(block).build())

    /**
     * Describes event configurations.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEventConfigurations action.
     */
    suspend fun describeEventConfigurations(input: DescribeEventConfigurationsRequest): DescribeEventConfigurationsResponse

    /**
     * Describes event configurations.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEventConfigurations action.
     */
    suspend fun describeEventConfigurations(block: DescribeEventConfigurationsRequest.Builder.() -> Unit) = describeEventConfigurations(DescribeEventConfigurationsRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeFleetMetric action.
     */
    suspend fun describeFleetMetric(input: DescribeFleetMetricRequest): DescribeFleetMetricResponse

    /**
     * Gets information about the specified fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeFleetMetric action.
     */
    suspend fun describeFleetMetric(block: DescribeFleetMetricRequest.Builder.() -> Unit) = describeFleetMetric(DescribeFleetMetricRequest.Builder().apply(block).build())

    /**
     * Describes a search index.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeIndex action.
     */
    suspend fun describeIndex(input: DescribeIndexRequest): DescribeIndexResponse

    /**
     * Describes a search index.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeIndex action.
     */
    suspend fun describeIndex(block: DescribeIndexRequest.Builder.() -> Unit) = describeIndex(DescribeIndexRequest.Builder().apply(block).build())

    /**
     * Describes a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJob action.
     */
    suspend fun describeJob(input: DescribeJobRequest): DescribeJobResponse

    /**
     * Describes a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJob action.
     */
    suspend fun describeJob(block: DescribeJobRequest.Builder.() -> Unit) = describeJob(DescribeJobRequest.Builder().apply(block).build())

    /**
     * Describes a job execution.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJobExecution action.
     */
    suspend fun describeJobExecution(input: DescribeJobExecutionRequest): DescribeJobExecutionResponse

    /**
     * Describes a job execution.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJobExecution action.
     */
    suspend fun describeJobExecution(block: DescribeJobExecutionRequest.Builder.() -> Unit) = describeJobExecution(DescribeJobExecutionRequest.Builder().apply(block).build())

    /**
     * Returns information about a job template.
     */
    suspend fun describeJobTemplate(input: DescribeJobTemplateRequest): DescribeJobTemplateResponse

    /**
     * Returns information about a job template.
     */
    suspend fun describeJobTemplate(block: DescribeJobTemplateRequest.Builder.() -> Unit) = describeJobTemplate(DescribeJobTemplateRequest.Builder().apply(block).build())

    /**
     * View details of a managed job template.
     */
    suspend fun describeManagedJobTemplate(input: DescribeManagedJobTemplateRequest): DescribeManagedJobTemplateResponse

    /**
     * View details of a managed job template.
     */
    suspend fun describeManagedJobTemplate(block: DescribeManagedJobTemplateRequest.Builder.() -> Unit) = describeManagedJobTemplate(DescribeManagedJobTemplateRequest.Builder().apply(block).build())

    /**
     * Gets information about a mitigation action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeMitigationAction action.
     */
    suspend fun describeMitigationAction(input: DescribeMitigationActionRequest): DescribeMitigationActionResponse

    /**
     * Gets information about a mitigation action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeMitigationAction action.
     */
    suspend fun describeMitigationAction(block: DescribeMitigationActionRequest.Builder.() -> Unit) = describeMitigationAction(DescribeMitigationActionRequest.Builder().apply(block).build())

    /**
     * Returns information about a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplate action.
     */
    suspend fun describeProvisioningTemplate(input: DescribeProvisioningTemplateRequest): DescribeProvisioningTemplateResponse

    /**
     * Returns information about a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplate action.
     */
    suspend fun describeProvisioningTemplate(block: DescribeProvisioningTemplateRequest.Builder.() -> Unit) = describeProvisioningTemplate(DescribeProvisioningTemplateRequest.Builder().apply(block).build())

    /**
     * Returns information about a fleet provisioning template version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplateVersion action.
     */
    suspend fun describeProvisioningTemplateVersion(input: DescribeProvisioningTemplateVersionRequest): DescribeProvisioningTemplateVersionResponse

    /**
     * Returns information about a fleet provisioning template version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplateVersion action.
     */
    suspend fun describeProvisioningTemplateVersion(block: DescribeProvisioningTemplateVersionRequest.Builder.() -> Unit) = describeProvisioningTemplateVersion(DescribeProvisioningTemplateVersionRequest.Builder().apply(block).build())

    /**
     * Describes a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeRoleAlias action.
     */
    suspend fun describeRoleAlias(input: DescribeRoleAliasRequest): DescribeRoleAliasResponse

    /**
     * Describes a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeRoleAlias action.
     */
    suspend fun describeRoleAlias(block: DescribeRoleAliasRequest.Builder.() -> Unit) = describeRoleAlias(DescribeRoleAliasRequest.Builder().apply(block).build())

    /**
     * Gets information about a scheduled audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeScheduledAudit action.
     */
    suspend fun describeScheduledAudit(input: DescribeScheduledAuditRequest): DescribeScheduledAuditResponse

    /**
     * Gets information about a scheduled audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeScheduledAudit action.
     */
    suspend fun describeScheduledAudit(block: DescribeScheduledAuditRequest.Builder.() -> Unit) = describeScheduledAudit(DescribeScheduledAuditRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeSecurityProfile action.
     */
    suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse

    /**
     * Gets information about a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeSecurityProfile action.
     */
    suspend fun describeSecurityProfile(block: DescribeSecurityProfileRequest.Builder.() -> Unit) = describeSecurityProfile(DescribeSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Gets information about a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeStream action.
     */
    suspend fun describeStream(input: DescribeStreamRequest): DescribeStreamResponse

    /**
     * Gets information about a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeStream action.
     */
    suspend fun describeStream(block: DescribeStreamRequest.Builder.() -> Unit) = describeStream(DescribeStreamRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThing action.
     */
    suspend fun describeThing(input: DescribeThingRequest): DescribeThingResponse

    /**
     * Gets information about the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThing action.
     */
    suspend fun describeThing(block: DescribeThingRequest.Builder.() -> Unit) = describeThing(DescribeThingRequest.Builder().apply(block).build())

    /**
     * Describe a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingGroup action.
     */
    suspend fun describeThingGroup(input: DescribeThingGroupRequest): DescribeThingGroupResponse

    /**
     * Describe a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingGroup action.
     */
    suspend fun describeThingGroup(block: DescribeThingGroupRequest.Builder.() -> Unit) = describeThingGroup(DescribeThingGroupRequest.Builder().apply(block).build())

    /**
     * Describes a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingRegistrationTask action.
     */
    suspend fun describeThingRegistrationTask(input: DescribeThingRegistrationTaskRequest): DescribeThingRegistrationTaskResponse

    /**
     * Describes a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingRegistrationTask action.
     */
    suspend fun describeThingRegistrationTask(block: DescribeThingRegistrationTaskRequest.Builder.() -> Unit) = describeThingRegistrationTask(DescribeThingRegistrationTaskRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingType action.
     */
    suspend fun describeThingType(input: DescribeThingTypeRequest): DescribeThingTypeResponse

    /**
     * Gets information about the specified thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingType action.
     */
    suspend fun describeThingType(block: DescribeThingTypeRequest.Builder.() -> Unit) = describeThingType(DescribeThingTypeRequest.Builder().apply(block).build())

    /**
     * Detaches a policy from the specified target.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after
     * a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPolicy action.
     */
    suspend fun detachPolicy(input: DetachPolicyRequest): DetachPolicyResponse

    /**
     * Detaches a policy from the specified target.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after
     * a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPolicy action.
     */
    suspend fun detachPolicy(block: DetachPolicyRequest.Builder.() -> Unit) = detachPolicy(DetachPolicyRequest.Builder().apply(block).build())

    /**
     * Removes the specified policy from the specified certificate.
     *
     * This action is deprecated. Please use DetachPolicy instead.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPrincipalPolicy action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun detachPrincipalPolicy(input: DetachPrincipalPolicyRequest): DetachPrincipalPolicyResponse

    /**
     * Removes the specified policy from the specified certificate.
     *
     * This action is deprecated. Please use DetachPolicy instead.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPrincipalPolicy action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun detachPrincipalPolicy(block: DetachPrincipalPolicyRequest.Builder.() -> Unit) = detachPrincipalPolicy(DetachPrincipalPolicyRequest.Builder().apply(block).build())

    /**
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachSecurityProfile action.
     */
    suspend fun detachSecurityProfile(input: DetachSecurityProfileRequest): DetachSecurityProfileResponse

    /**
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachSecurityProfile action.
     */
    suspend fun detachSecurityProfile(block: DetachSecurityProfileRequest.Builder.() -> Unit) = detachSecurityProfile(DetachSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Detaches the specified principal from the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     *
     * This call is asynchronous. It might take several seconds for the detachment to
     * propagate.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachThingPrincipal action.
     */
    suspend fun detachThingPrincipal(input: DetachThingPrincipalRequest): DetachThingPrincipalResponse

    /**
     * Detaches the specified principal from the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     *
     * This call is asynchronous. It might take several seconds for the detachment to
     * propagate.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachThingPrincipal action.
     */
    suspend fun detachThingPrincipal(block: DetachThingPrincipalRequest.Builder.() -> Unit) = detachThingPrincipal(DetachThingPrincipalRequest.Builder().apply(block).build())

    /**
     * Disables the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DisableTopicRule action.
     */
    suspend fun disableTopicRule(input: DisableTopicRuleRequest): DisableTopicRuleResponse

    /**
     * Disables the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DisableTopicRule action.
     */
    suspend fun disableTopicRule(block: DisableTopicRuleRequest.Builder.() -> Unit) = disableTopicRule(DisableTopicRuleRequest.Builder().apply(block).build())

    /**
     * Enables the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">EnableTopicRule action.
     */
    suspend fun enableTopicRule(input: EnableTopicRuleRequest): EnableTopicRuleResponse

    /**
     * Enables the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">EnableTopicRule action.
     */
    suspend fun enableTopicRule(block: EnableTopicRuleRequest.Builder.() -> Unit) = enableTopicRule(EnableTopicRuleRequest.Builder().apply(block).build())

    /**
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBehaviorModelTrainingSummaries action.
     */
    suspend fun getBehaviorModelTrainingSummaries(input: GetBehaviorModelTrainingSummariesRequest): GetBehaviorModelTrainingSummariesResponse

    /**
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBehaviorModelTrainingSummaries action.
     */
    suspend fun getBehaviorModelTrainingSummaries(block: GetBehaviorModelTrainingSummariesRequest.Builder.() -> Unit) = getBehaviorModelTrainingSummaries(GetBehaviorModelTrainingSummariesRequest.Builder().apply(block).build())

    /**
     * Aggregates on indexed data with search queries pertaining to particular fields.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBucketsAggregation action.
     */
    suspend fun getBucketsAggregation(input: GetBucketsAggregationRequest): GetBucketsAggregationResponse

    /**
     * Aggregates on indexed data with search queries pertaining to particular fields.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBucketsAggregation action.
     */
    suspend fun getBucketsAggregation(block: GetBucketsAggregationRequest.Builder.() -> Unit) = getBucketsAggregation(GetBucketsAggregationRequest.Builder().apply(block).build())

    /**
     * Returns the approximate count of unique values that match the query.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetCardinality action.
     */
    suspend fun getCardinality(input: GetCardinalityRequest): GetCardinalityResponse

    /**
     * Returns the approximate count of unique values that match the query.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetCardinality action.
     */
    suspend fun getCardinality(block: GetCardinalityRequest.Builder.() -> Unit) = getCardinality(GetCardinalityRequest.Builder().apply(block).build())

    /**
     * Gets a list of the policies that have an effect on the authorization behavior of the
     * specified device when it connects to the IoT device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetEffectivePolicies action.
     */
    suspend fun getEffectivePolicies(input: GetEffectivePoliciesRequest): GetEffectivePoliciesResponse

    /**
     * Gets a list of the policies that have an effect on the authorization behavior of the
     * specified device when it connects to the IoT device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetEffectivePolicies action.
     */
    suspend fun getEffectivePolicies(block: GetEffectivePoliciesRequest.Builder.() -> Unit) = getEffectivePolicies(GetEffectivePoliciesRequest.Builder().apply(block).build())

    /**
     * Gets the indexing configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetIndexingConfiguration action.
     */
    suspend fun getIndexingConfiguration(input: GetIndexingConfigurationRequest): GetIndexingConfigurationResponse

    /**
     * Gets the indexing configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetIndexingConfiguration action.
     */
    suspend fun getIndexingConfiguration(block: GetIndexingConfigurationRequest.Builder.() -> Unit) = getIndexingConfiguration(GetIndexingConfigurationRequest.Builder().apply(block).build())

    /**
     * Gets a job document.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetJobDocument action.
     */
    suspend fun getJobDocument(input: GetJobDocumentRequest): GetJobDocumentResponse

    /**
     * Gets a job document.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetJobDocument action.
     */
    suspend fun getJobDocument(block: GetJobDocumentRequest.Builder.() -> Unit) = getJobDocument(GetJobDocumentRequest.Builder().apply(block).build())

    /**
     * Gets the logging options.
     * NOTE: use of this command is not recommended. Use GetV2LoggingOptions
     * instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetLoggingOptions action.
     */
    suspend fun getLoggingOptions(input: GetLoggingOptionsRequest): GetLoggingOptionsResponse

    /**
     * Gets the logging options.
     * NOTE: use of this command is not recommended. Use GetV2LoggingOptions
     * instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetLoggingOptions action.
     */
    suspend fun getLoggingOptions(block: GetLoggingOptionsRequest.Builder.() -> Unit) = getLoggingOptions(GetLoggingOptionsRequest.Builder().apply(block).build())

    /**
     * Gets an OTA update.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetOTAUpdate action.
     */
    suspend fun getOtaUpdate(input: GetOtaUpdateRequest): GetOtaUpdateResponse

    /**
     * Gets an OTA update.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetOTAUpdate action.
     */
    suspend fun getOtaUpdate(block: GetOtaUpdateRequest.Builder.() -> Unit) = getOtaUpdate(GetOtaUpdateRequest.Builder().apply(block).build())

    /**
     * Groups the aggregated values that match the query into percentile groupings. The default
     * percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own
     * when you call GetPercentiles. This function returns a value for each
     * percentile group specified (or the default percentile groupings). The percentile group
     * "1" contains the aggregated field value that occurs in approximately one percent of the
     * values that match the query. The percentile group "5" contains the aggregated field value
     * that occurs in approximately five percent of the values that match the query, and so on.
     * The result is an approximation, the more values that match the query, the more accurate
     * the percentile values.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPercentiles action.
     */
    suspend fun getPercentiles(input: GetPercentilesRequest): GetPercentilesResponse

    /**
     * Groups the aggregated values that match the query into percentile groupings. The default
     * percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own
     * when you call GetPercentiles. This function returns a value for each
     * percentile group specified (or the default percentile groupings). The percentile group
     * "1" contains the aggregated field value that occurs in approximately one percent of the
     * values that match the query. The percentile group "5" contains the aggregated field value
     * that occurs in approximately five percent of the values that match the query, and so on.
     * The result is an approximation, the more values that match the query, the more accurate
     * the percentile values.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPercentiles action.
     */
    suspend fun getPercentiles(block: GetPercentilesRequest.Builder.() -> Unit) = getPercentiles(GetPercentilesRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified policy with the policy document of the default
     * version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicy action.
     */
    suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Gets information about the specified policy with the policy document of the default
     * version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicy action.
     */
    suspend fun getPolicy(block: GetPolicyRequest.Builder.() -> Unit) = getPolicy(GetPolicyRequest.Builder().apply(block).build())

    /**
     * Gets information about the specified policy version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicyVersion action.
     */
    suspend fun getPolicyVersion(input: GetPolicyVersionRequest): GetPolicyVersionResponse

    /**
     * Gets information about the specified policy version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicyVersion action.
     */
    suspend fun getPolicyVersion(block: GetPolicyVersionRequest.Builder.() -> Unit) = getPolicyVersion(GetPolicyVersionRequest.Builder().apply(block).build())

    /**
     * Gets a registration code used to register a CA certificate with IoT.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetRegistrationCode action.
     */
    suspend fun getRegistrationCode(input: GetRegistrationCodeRequest): GetRegistrationCodeResponse

    /**
     * Gets a registration code used to register a CA certificate with IoT.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetRegistrationCode action.
     */
    suspend fun getRegistrationCode(block: GetRegistrationCodeRequest.Builder.() -> Unit) = getRegistrationCode(GetRegistrationCodeRequest.Builder().apply(block).build())

    /**
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance,
     * and standard deviation for the specified aggregated field. If the aggregation field is of type
     * String, only the count statistic is returned.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetStatistics action.
     */
    suspend fun getStatistics(input: GetStatisticsRequest): GetStatisticsResponse

    /**
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance,
     * and standard deviation for the specified aggregated field. If the aggregation field is of type
     * String, only the count statistic is returned.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetStatistics action.
     */
    suspend fun getStatistics(block: GetStatisticsRequest.Builder.() -> Unit) = getStatistics(GetStatisticsRequest.Builder().apply(block).build())

    /**
     * Gets information about the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRule action.
     */
    suspend fun getTopicRule(input: GetTopicRuleRequest): GetTopicRuleResponse

    /**
     * Gets information about the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRule action.
     */
    suspend fun getTopicRule(block: GetTopicRuleRequest.Builder.() -> Unit) = getTopicRule(GetTopicRuleRequest.Builder().apply(block).build())

    /**
     * Gets information about a topic rule destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRuleDestination action.
     */
    suspend fun getTopicRuleDestination(input: GetTopicRuleDestinationRequest): GetTopicRuleDestinationResponse

    /**
     * Gets information about a topic rule destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRuleDestination action.
     */
    suspend fun getTopicRuleDestination(block: GetTopicRuleDestinationRequest.Builder.() -> Unit) = getTopicRuleDestination(GetTopicRuleDestinationRequest.Builder().apply(block).build())

    /**
     * Gets the fine grained logging options.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetV2LoggingOptions action.
     */
    suspend fun getV2LoggingOptions(input: GetV2LoggingOptionsRequest): GetV2LoggingOptionsResponse

    /**
     * Gets the fine grained logging options.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetV2LoggingOptions action.
     */
    suspend fun getV2LoggingOptions(block: GetV2LoggingOptionsRequest.Builder.() -> Unit) = getV2LoggingOptions(GetV2LoggingOptionsRequest.Builder().apply(block).build())

    /**
     * Lists the active violations for a given Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListActiveViolations action.
     */
    suspend fun listActiveViolations(input: ListActiveViolationsRequest): ListActiveViolationsResponse

    /**
     * Lists the active violations for a given Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListActiveViolations action.
     */
    suspend fun listActiveViolations(block: ListActiveViolationsRequest.Builder.() -> Unit) = listActiveViolations(ListActiveViolationsRequest.Builder().apply(block).build())

    /**
     * Lists the policies attached to the specified thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAttachedPolicies action.
     */
    suspend fun listAttachedPolicies(input: ListAttachedPoliciesRequest): ListAttachedPoliciesResponse

    /**
     * Lists the policies attached to the specified thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAttachedPolicies action.
     */
    suspend fun listAttachedPolicies(block: ListAttachedPoliciesRequest.Builder.() -> Unit) = listAttachedPolicies(ListAttachedPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists the findings (results) of a Device Defender audit or of the audits
     * performed during a specified time period. (Findings are retained for 90 days.)
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditFindings action.
     */
    suspend fun listAuditFindings(input: ListAuditFindingsRequest): ListAuditFindingsResponse

    /**
     * Lists the findings (results) of a Device Defender audit or of the audits
     * performed during a specified time period. (Findings are retained for 90 days.)
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditFindings action.
     */
    suspend fun listAuditFindings(block: ListAuditFindingsRequest.Builder.() -> Unit) = listAuditFindings(ListAuditFindingsRequest.Builder().apply(block).build())

    /**
     * Gets the status of audit mitigation action tasks that were
     * executed.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsExecutions action.
     */
    suspend fun listAuditMitigationActionsExecutions(input: ListAuditMitigationActionsExecutionsRequest): ListAuditMitigationActionsExecutionsResponse

    /**
     * Gets the status of audit mitigation action tasks that were
     * executed.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsExecutions action.
     */
    suspend fun listAuditMitigationActionsExecutions(block: ListAuditMitigationActionsExecutionsRequest.Builder.() -> Unit) = listAuditMitigationActionsExecutions(ListAuditMitigationActionsExecutionsRequest.Builder().apply(block).build())

    /**
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsTasks action.
     */
    suspend fun listAuditMitigationActionsTasks(input: ListAuditMitigationActionsTasksRequest): ListAuditMitigationActionsTasksResponse

    /**
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsTasks action.
     */
    suspend fun listAuditMitigationActionsTasks(block: ListAuditMitigationActionsTasksRequest.Builder.() -> Unit) = listAuditMitigationActionsTasks(ListAuditMitigationActionsTasksRequest.Builder().apply(block).build())

    /**
     * Lists your Device Defender audit listings.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditSuppressions action.
     */
    suspend fun listAuditSuppressions(input: ListAuditSuppressionsRequest): ListAuditSuppressionsResponse

    /**
     * Lists your Device Defender audit listings.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditSuppressions action.
     */
    suspend fun listAuditSuppressions(block: ListAuditSuppressionsRequest.Builder.() -> Unit) = listAuditSuppressions(ListAuditSuppressionsRequest.Builder().apply(block).build())

    /**
     * Lists the Device Defender audits that have been performed during a given
     * time period.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditTasks action.
     */
    suspend fun listAuditTasks(input: ListAuditTasksRequest): ListAuditTasksResponse

    /**
     * Lists the Device Defender audits that have been performed during a given
     * time period.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditTasks action.
     */
    suspend fun listAuditTasks(block: ListAuditTasksRequest.Builder.() -> Unit) = listAuditTasks(ListAuditTasksRequest.Builder().apply(block).build())

    /**
     * Lists the authorizers registered in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuthorizers action.
     */
    suspend fun listAuthorizers(input: ListAuthorizersRequest): ListAuthorizersResponse

    /**
     * Lists the authorizers registered in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuthorizers action.
     */
    suspend fun listAuthorizers(block: ListAuthorizersRequest.Builder.() -> Unit) = listAuthorizers(ListAuthorizersRequest.Builder().apply(block).build())

    /**
     * Lists the billing groups you have created.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListBillingGroups action.
     */
    suspend fun listBillingGroups(input: ListBillingGroupsRequest): ListBillingGroupsResponse

    /**
     * Lists the billing groups you have created.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListBillingGroups action.
     */
    suspend fun listBillingGroups(block: ListBillingGroupsRequest.Builder.() -> Unit) = listBillingGroups(ListBillingGroupsRequest.Builder().apply(block).build())

    /**
     * Lists the CA certificates registered for your Amazon Web Services account.
     * The results are paginated with a default page size of 25. You can use the returned
     * marker to retrieve additional results.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCACertificates action.
     */
    suspend fun listCaCertificates(input: ListCaCertificatesRequest): ListCaCertificatesResponse

    /**
     * Lists the CA certificates registered for your Amazon Web Services account.
     * The results are paginated with a default page size of 25. You can use the returned
     * marker to retrieve additional results.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCACertificates action.
     */
    suspend fun listCaCertificates(block: ListCaCertificatesRequest.Builder.() -> Unit) = listCaCertificates(ListCaCertificatesRequest.Builder().apply(block).build())

    /**
     * Lists the certificates registered in your Amazon Web Services account.
     * The results are paginated with a default page size of 25. You can use the returned
     * marker to retrieve additional results.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificates action.
     */
    suspend fun listCertificates(input: ListCertificatesRequest): ListCertificatesResponse

    /**
     * Lists the certificates registered in your Amazon Web Services account.
     * The results are paginated with a default page size of 25. You can use the returned
     * marker to retrieve additional results.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificates action.
     */
    suspend fun listCertificates(block: ListCertificatesRequest.Builder.() -> Unit) = listCertificates(ListCertificatesRequest.Builder().apply(block).build())

    /**
     * List the device certificates signed by the specified CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificatesByCA action.
     */
    suspend fun listCertificatesByCa(input: ListCertificatesByCaRequest): ListCertificatesByCaResponse

    /**
     * List the device certificates signed by the specified CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificatesByCA action.
     */
    suspend fun listCertificatesByCa(block: ListCertificatesByCaRequest.Builder.() -> Unit) = listCertificatesByCa(ListCertificatesByCaRequest.Builder().apply(block).build())

    /**
     * Lists your Device Defender detect custom metrics.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCustomMetrics action.
     */
    suspend fun listCustomMetrics(input: ListCustomMetricsRequest): ListCustomMetricsResponse

    /**
     * Lists your Device Defender detect custom metrics.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCustomMetrics action.
     */
    suspend fun listCustomMetrics(block: ListCustomMetricsRequest.Builder.() -> Unit) = listCustomMetrics(ListCustomMetricsRequest.Builder().apply(block).build())

    /**
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsExecutions action.
     */
    suspend fun listDetectMitigationActionsExecutions(input: ListDetectMitigationActionsExecutionsRequest): ListDetectMitigationActionsExecutionsResponse

    /**
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsExecutions action.
     */
    suspend fun listDetectMitigationActionsExecutions(block: ListDetectMitigationActionsExecutionsRequest.Builder.() -> Unit) = listDetectMitigationActionsExecutions(ListDetectMitigationActionsExecutionsRequest.Builder().apply(block).build())

    /**
     * List of Device Defender ML Detect mitigation actions tasks.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsTasks action.
     */
    suspend fun listDetectMitigationActionsTasks(input: ListDetectMitigationActionsTasksRequest): ListDetectMitigationActionsTasksResponse

    /**
     * List of Device Defender ML Detect mitigation actions tasks.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsTasks action.
     */
    suspend fun listDetectMitigationActionsTasks(block: ListDetectMitigationActionsTasksRequest.Builder.() -> Unit) = listDetectMitigationActionsTasks(ListDetectMitigationActionsTasksRequest.Builder().apply(block).build())

    /**
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDimensions action.
     */
    suspend fun listDimensions(input: ListDimensionsRequest): ListDimensionsResponse

    /**
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDimensions action.
     */
    suspend fun listDimensions(block: ListDimensionsRequest.Builder.() -> Unit) = listDimensions(ListDimensionsRequest.Builder().apply(block).build())

    /**
     * Gets a list of domain configurations for the user. This list is sorted
     * alphabetically by domain configuration name.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDomainConfigurations action.
     */
    suspend fun listDomainConfigurations(input: ListDomainConfigurationsRequest): ListDomainConfigurationsResponse

    /**
     * Gets a list of domain configurations for the user. This list is sorted
     * alphabetically by domain configuration name.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDomainConfigurations action.
     */
    suspend fun listDomainConfigurations(block: ListDomainConfigurationsRequest.Builder.() -> Unit) = listDomainConfigurations(ListDomainConfigurationsRequest.Builder().apply(block).build())

    /**
     * Lists all your fleet metrics.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListFleetMetrics action.
     */
    suspend fun listFleetMetrics(input: ListFleetMetricsRequest): ListFleetMetricsResponse

    /**
     * Lists all your fleet metrics.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListFleetMetrics action.
     */
    suspend fun listFleetMetrics(block: ListFleetMetricsRequest.Builder.() -> Unit) = listFleetMetrics(ListFleetMetricsRequest.Builder().apply(block).build())

    /**
     * Lists the search indices.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListIndices action.
     */
    suspend fun listIndices(input: ListIndicesRequest): ListIndicesResponse

    /**
     * Lists the search indices.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListIndices action.
     */
    suspend fun listIndices(block: ListIndicesRequest.Builder.() -> Unit) = listIndices(ListIndicesRequest.Builder().apply(block).build())

    /**
     * Lists the job executions for a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForJob action.
     */
    suspend fun listJobExecutionsForJob(input: ListJobExecutionsForJobRequest): ListJobExecutionsForJobResponse

    /**
     * Lists the job executions for a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForJob action.
     */
    suspend fun listJobExecutionsForJob(block: ListJobExecutionsForJobRequest.Builder.() -> Unit) = listJobExecutionsForJob(ListJobExecutionsForJobRequest.Builder().apply(block).build())

    /**
     * Lists the job executions for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForThing action.
     */
    suspend fun listJobExecutionsForThing(input: ListJobExecutionsForThingRequest): ListJobExecutionsForThingResponse

    /**
     * Lists the job executions for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForThing action.
     */
    suspend fun listJobExecutionsForThing(block: ListJobExecutionsForThingRequest.Builder.() -> Unit) = listJobExecutionsForThing(ListJobExecutionsForThingRequest.Builder().apply(block).build())

    /**
     * Returns a list of job templates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobTemplates action.
     */
    suspend fun listJobTemplates(input: ListJobTemplatesRequest): ListJobTemplatesResponse

    /**
     * Returns a list of job templates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobTemplates action.
     */
    suspend fun listJobTemplates(block: ListJobTemplatesRequest.Builder.() -> Unit) = listJobTemplates(ListJobTemplatesRequest.Builder().apply(block).build())

    /**
     * Lists jobs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobs action.
     */
    suspend fun listJobs(input: ListJobsRequest): ListJobsResponse

    /**
     * Lists jobs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobs action.
     */
    suspend fun listJobs(block: ListJobsRequest.Builder.() -> Unit) = listJobs(ListJobsRequest.Builder().apply(block).build())

    /**
     * Returns a list of managed job templates.
     */
    suspend fun listManagedJobTemplates(input: ListManagedJobTemplatesRequest): ListManagedJobTemplatesResponse

    /**
     * Returns a list of managed job templates.
     */
    suspend fun listManagedJobTemplates(block: ListManagedJobTemplatesRequest.Builder.() -> Unit) = listManagedJobTemplates(ListManagedJobTemplatesRequest.Builder().apply(block).build())

    /**
     * Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side metric, or custom metric)
     * by the given thing during the specified time period.
     */
    suspend fun listMetricValues(input: ListMetricValuesRequest): ListMetricValuesResponse

    /**
     * Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side metric, or custom metric)
     * by the given thing during the specified time period.
     */
    suspend fun listMetricValues(block: ListMetricValuesRequest.Builder.() -> Unit) = listMetricValues(ListMetricValuesRequest.Builder().apply(block).build())

    /**
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListMitigationActions action.
     */
    suspend fun listMitigationActions(input: ListMitigationActionsRequest): ListMitigationActionsResponse

    /**
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListMitigationActions action.
     */
    suspend fun listMitigationActions(block: ListMitigationActionsRequest.Builder.() -> Unit) = listMitigationActions(ListMitigationActionsRequest.Builder().apply(block).build())

    /**
     * Lists OTA updates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOTAUpdates action.
     */
    suspend fun listOtaUpdates(input: ListOtaUpdatesRequest): ListOtaUpdatesResponse

    /**
     * Lists OTA updates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOTAUpdates action.
     */
    suspend fun listOtaUpdates(block: ListOtaUpdatesRequest.Builder.() -> Unit) = listOtaUpdates(ListOtaUpdatesRequest.Builder().apply(block).build())

    /**
     * Lists certificates that are being transferred but not yet accepted.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOutgoingCertificates action.
     */
    suspend fun listOutgoingCertificates(input: ListOutgoingCertificatesRequest): ListOutgoingCertificatesResponse

    /**
     * Lists certificates that are being transferred but not yet accepted.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOutgoingCertificates action.
     */
    suspend fun listOutgoingCertificates(block: ListOutgoingCertificatesRequest.Builder.() -> Unit) = listOutgoingCertificates(ListOutgoingCertificatesRequest.Builder().apply(block).build())

    /**
     * Lists your policies.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicies action.
     */
    suspend fun listPolicies(input: ListPoliciesRequest): ListPoliciesResponse

    /**
     * Lists your policies.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicies action.
     */
    suspend fun listPolicies(block: ListPoliciesRequest.Builder.() -> Unit) = listPolicies(ListPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists the principals associated with the specified policy.
     *
     * Note: This action is deprecated. Please use ListTargetsForPolicy instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyPrincipals action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listPolicyPrincipals(input: ListPolicyPrincipalsRequest): ListPolicyPrincipalsResponse

    /**
     * Lists the principals associated with the specified policy.
     *
     * Note: This action is deprecated. Please use ListTargetsForPolicy instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyPrincipals action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listPolicyPrincipals(block: ListPolicyPrincipalsRequest.Builder.() -> Unit) = listPolicyPrincipals(ListPolicyPrincipalsRequest.Builder().apply(block).build())

    /**
     * Lists the versions of the specified policy and identifies the default
     * version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyVersions action.
     */
    suspend fun listPolicyVersions(input: ListPolicyVersionsRequest): ListPolicyVersionsResponse

    /**
     * Lists the versions of the specified policy and identifies the default
     * version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyVersions action.
     */
    suspend fun listPolicyVersions(block: ListPolicyVersionsRequest.Builder.() -> Unit) = listPolicyVersions(ListPolicyVersionsRequest.Builder().apply(block).build())

    /**
     * Lists the policies attached to the specified principal. If you use an Cognito
     * identity, the ID must be in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax">AmazonCognito Identity format.
     *
     * Note: This action is deprecated. Please use ListAttachedPolicies instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalPolicies action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listPrincipalPolicies(input: ListPrincipalPoliciesRequest): ListPrincipalPoliciesResponse

    /**
     * Lists the policies attached to the specified principal. If you use an Cognito
     * identity, the ID must be in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax">AmazonCognito Identity format.
     *
     * Note: This action is deprecated. Please use ListAttachedPolicies instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalPolicies action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listPrincipalPolicies(block: ListPrincipalPoliciesRequest.Builder.() -> Unit) = listPrincipalPolicies(ListPrincipalPoliciesRequest.Builder().apply(block).build())

    /**
     * Lists the things associated with the specified principal. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalThings action.
     */
    suspend fun listPrincipalThings(input: ListPrincipalThingsRequest): ListPrincipalThingsResponse

    /**
     * Lists the things associated with the specified principal. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalThings action.
     */
    suspend fun listPrincipalThings(block: ListPrincipalThingsRequest.Builder.() -> Unit) = listPrincipalThings(ListPrincipalThingsRequest.Builder().apply(block).build())

    /**
     * A list of fleet provisioning template versions.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplateVersions action.
     */
    suspend fun listProvisioningTemplateVersions(input: ListProvisioningTemplateVersionsRequest): ListProvisioningTemplateVersionsResponse

    /**
     * A list of fleet provisioning template versions.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplateVersions action.
     */
    suspend fun listProvisioningTemplateVersions(block: ListProvisioningTemplateVersionsRequest.Builder.() -> Unit) = listProvisioningTemplateVersions(ListProvisioningTemplateVersionsRequest.Builder().apply(block).build())

    /**
     * Lists the fleet provisioning templates in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplates action.
     */
    suspend fun listProvisioningTemplates(input: ListProvisioningTemplatesRequest): ListProvisioningTemplatesResponse

    /**
     * Lists the fleet provisioning templates in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplates action.
     */
    suspend fun listProvisioningTemplates(block: ListProvisioningTemplatesRequest.Builder.() -> Unit) = listProvisioningTemplates(ListProvisioningTemplatesRequest.Builder().apply(block).build())

    /**
     * Lists the role aliases registered in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListRoleAliases action.
     */
    suspend fun listRoleAliases(input: ListRoleAliasesRequest): ListRoleAliasesResponse

    /**
     * Lists the role aliases registered in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListRoleAliases action.
     */
    suspend fun listRoleAliases(block: ListRoleAliasesRequest.Builder.() -> Unit) = listRoleAliases(ListRoleAliasesRequest.Builder().apply(block).build())

    /**
     * Lists all of your scheduled audits.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListScheduledAudits action.
     */
    suspend fun listScheduledAudits(input: ListScheduledAuditsRequest): ListScheduledAuditsResponse

    /**
     * Lists all of your scheduled audits.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListScheduledAudits action.
     */
    suspend fun listScheduledAudits(block: ListScheduledAuditsRequest.Builder.() -> Unit) = listScheduledAudits(ListScheduledAuditsRequest.Builder().apply(block).build())

    /**
     * Lists the Device Defender security profiles
     * you've
     * created. You can filter security profiles by dimension or custom metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfiles action.
     *
     *
     * dimensionName and metricName cannot be used in the same request.
     */
    suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest): ListSecurityProfilesResponse

    /**
     * Lists the Device Defender security profiles
     * you've
     * created. You can filter security profiles by dimension or custom metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfiles action.
     *
     *
     * dimensionName and metricName cannot be used in the same request.
     */
    suspend fun listSecurityProfiles(block: ListSecurityProfilesRequest.Builder.() -> Unit) = listSecurityProfiles(ListSecurityProfilesRequest.Builder().apply(block).build())

    /**
     * Lists the Device Defender security profiles attached to a target (thing group).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfilesForTarget action.
     */
    suspend fun listSecurityProfilesForTarget(input: ListSecurityProfilesForTargetRequest): ListSecurityProfilesForTargetResponse

    /**
     * Lists the Device Defender security profiles attached to a target (thing group).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfilesForTarget action.
     */
    suspend fun listSecurityProfilesForTarget(block: ListSecurityProfilesForTargetRequest.Builder.() -> Unit) = listSecurityProfilesForTarget(ListSecurityProfilesForTargetRequest.Builder().apply(block).build())

    /**
     * Lists all of the streams in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListStreams action.
     */
    suspend fun listStreams(input: ListStreamsRequest): ListStreamsResponse

    /**
     * Lists all of the streams in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListStreams action.
     */
    suspend fun listStreams(block: ListStreamsRequest.Builder.() -> Unit) = listStreams(ListStreamsRequest.Builder().apply(block).build())

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTagsForResource action.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTagsForResource action.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * List targets for the specified policy.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForPolicy action.
     */
    suspend fun listTargetsForPolicy(input: ListTargetsForPolicyRequest): ListTargetsForPolicyResponse

    /**
     * List targets for the specified policy.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForPolicy action.
     */
    suspend fun listTargetsForPolicy(block: ListTargetsForPolicyRequest.Builder.() -> Unit) = listTargetsForPolicy(ListTargetsForPolicyRequest.Builder().apply(block).build())

    /**
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForSecurityProfile action.
     */
    suspend fun listTargetsForSecurityProfile(input: ListTargetsForSecurityProfileRequest): ListTargetsForSecurityProfileResponse

    /**
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForSecurityProfile action.
     */
    suspend fun listTargetsForSecurityProfile(block: ListTargetsForSecurityProfileRequest.Builder.() -> Unit) = listTargetsForSecurityProfile(ListTargetsForSecurityProfileRequest.Builder().apply(block).build())

    /**
     * List the thing groups in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroups action.
     */
    suspend fun listThingGroups(input: ListThingGroupsRequest): ListThingGroupsResponse

    /**
     * List the thing groups in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroups action.
     */
    suspend fun listThingGroups(block: ListThingGroupsRequest.Builder.() -> Unit) = listThingGroups(ListThingGroupsRequest.Builder().apply(block).build())

    /**
     * List the thing groups to which the specified thing belongs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroupsForThing action.
     */
    suspend fun listThingGroupsForThing(input: ListThingGroupsForThingRequest): ListThingGroupsForThingResponse

    /**
     * List the thing groups to which the specified thing belongs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroupsForThing action.
     */
    suspend fun listThingGroupsForThing(block: ListThingGroupsForThingRequest.Builder.() -> Unit) = listThingGroupsForThing(ListThingGroupsForThingRequest.Builder().apply(block).build())

    /**
     * Lists the principals associated with the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingPrincipals action.
     */
    suspend fun listThingPrincipals(input: ListThingPrincipalsRequest): ListThingPrincipalsResponse

    /**
     * Lists the principals associated with the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingPrincipals action.
     */
    suspend fun listThingPrincipals(block: ListThingPrincipalsRequest.Builder.() -> Unit) = listThingPrincipals(ListThingPrincipalsRequest.Builder().apply(block).build())

    /**
     * Information about the thing registration tasks.
     */
    suspend fun listThingRegistrationTaskReports(input: ListThingRegistrationTaskReportsRequest): ListThingRegistrationTaskReportsResponse

    /**
     * Information about the thing registration tasks.
     */
    suspend fun listThingRegistrationTaskReports(block: ListThingRegistrationTaskReportsRequest.Builder.() -> Unit) = listThingRegistrationTaskReports(ListThingRegistrationTaskReportsRequest.Builder().apply(block).build())

    /**
     * List bulk thing provisioning tasks.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingRegistrationTasks action.
     */
    suspend fun listThingRegistrationTasks(input: ListThingRegistrationTasksRequest): ListThingRegistrationTasksResponse

    /**
     * List bulk thing provisioning tasks.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingRegistrationTasks action.
     */
    suspend fun listThingRegistrationTasks(block: ListThingRegistrationTasksRequest.Builder.() -> Unit) = listThingRegistrationTasks(ListThingRegistrationTasksRequest.Builder().apply(block).build())

    /**
     * Lists the existing thing types.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingTypes action.
     */
    suspend fun listThingTypes(input: ListThingTypesRequest): ListThingTypesResponse

    /**
     * Lists the existing thing types.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingTypes action.
     */
    suspend fun listThingTypes(block: ListThingTypesRequest.Builder.() -> Unit) = listThingTypes(ListThingTypesRequest.Builder().apply(block).build())

    /**
     * Lists your things. Use the attributeName and
     * attributeValue parameters to filter your things.
     * For example, calling ListThings with attributeName=Color and
     * attributeValue=Red retrieves all things in the registry that contain an attribute
     * Color with the value Red.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThings action.
     *
     *
     * You will not be charged for calling this API if an Access denied error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.
     */
    suspend fun listThings(input: ListThingsRequest): ListThingsResponse

    /**
     * Lists your things. Use the attributeName and
     * attributeValue parameters to filter your things.
     * For example, calling ListThings with attributeName=Color and
     * attributeValue=Red retrieves all things in the registry that contain an attribute
     * Color with the value Red.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThings action.
     *
     *
     * You will not be charged for calling this API if an Access denied error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.
     */
    suspend fun listThings(block: ListThingsRequest.Builder.() -> Unit) = listThings(ListThingsRequest.Builder().apply(block).build())

    /**
     * Lists the things you have added to the given billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInBillingGroup action.
     */
    suspend fun listThingsInBillingGroup(input: ListThingsInBillingGroupRequest): ListThingsInBillingGroupResponse

    /**
     * Lists the things you have added to the given billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInBillingGroup action.
     */
    suspend fun listThingsInBillingGroup(block: ListThingsInBillingGroupRequest.Builder.() -> Unit) = listThingsInBillingGroup(ListThingsInBillingGroupRequest.Builder().apply(block).build())

    /**
     * Lists the things in the specified group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInThingGroup action.
     */
    suspend fun listThingsInThingGroup(input: ListThingsInThingGroupRequest): ListThingsInThingGroupResponse

    /**
     * Lists the things in the specified group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInThingGroup action.
     */
    suspend fun listThingsInThingGroup(block: ListThingsInThingGroupRequest.Builder.() -> Unit) = listThingsInThingGroup(ListThingsInThingGroupRequest.Builder().apply(block).build())

    /**
     * Lists all the topic rule destinations in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRuleDestinations action.
     */
    suspend fun listTopicRuleDestinations(input: ListTopicRuleDestinationsRequest): ListTopicRuleDestinationsResponse

    /**
     * Lists all the topic rule destinations in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRuleDestinations action.
     */
    suspend fun listTopicRuleDestinations(block: ListTopicRuleDestinationsRequest.Builder.() -> Unit) = listTopicRuleDestinations(ListTopicRuleDestinationsRequest.Builder().apply(block).build())

    /**
     * Lists the rules for the specific topic.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRules action.
     */
    suspend fun listTopicRules(input: ListTopicRulesRequest): ListTopicRulesResponse

    /**
     * Lists the rules for the specific topic.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRules action.
     */
    suspend fun listTopicRules(block: ListTopicRulesRequest.Builder.() -> Unit) = listTopicRules(ListTopicRulesRequest.Builder().apply(block).build())

    /**
     * Lists logging levels.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListV2LoggingLevels action.
     */
    suspend fun listV2LoggingLevels(input: ListV2LoggingLevelsRequest): ListV2LoggingLevelsResponse

    /**
     * Lists logging levels.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListV2LoggingLevels action.
     */
    suspend fun listV2LoggingLevels(block: ListV2LoggingLevelsRequest.Builder.() -> Unit) = listV2LoggingLevels(ListV2LoggingLevelsRequest.Builder().apply(block).build())

    /**
     * Lists the Device Defender security profile violations discovered during the given time period.
     * You can use filters to limit the results to those alerts issued for a particular security profile,
     * behavior, or thing (device).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListViolationEvents action.
     */
    suspend fun listViolationEvents(input: ListViolationEventsRequest): ListViolationEventsResponse

    /**
     * Lists the Device Defender security profile violations discovered during the given time period.
     * You can use filters to limit the results to those alerts issued for a particular security profile,
     * behavior, or thing (device).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListViolationEvents action.
     */
    suspend fun listViolationEvents(block: ListViolationEventsRequest.Builder.() -> Unit) = listViolationEvents(ListViolationEventsRequest.Builder().apply(block).build())

    /**
     * Set a verification state and provide a description of that verification state on a violation (detect alarm).
     */
    suspend fun putVerificationStateOnViolation(input: PutVerificationStateOnViolationRequest): PutVerificationStateOnViolationResponse

    /**
     * Set a verification state and provide a description of that verification state on a violation (detect alarm).
     */
    suspend fun putVerificationStateOnViolation(block: PutVerificationStateOnViolationRequest.Builder.() -> Unit) = putVerificationStateOnViolation(PutVerificationStateOnViolationRequest.Builder().apply(block).build())

    /**
     * Registers a CA certificate with IoT. This CA certificate can then be used to sign
     * device certificates, which can be then registered with IoT. You can register up to 10
     * CA certificates per Amazon Web Services account that have the same subject field. This enables you to have
     * up to 10 certificate authorities sign your device certificates. If you have more than one
     * CA certificate registered, make sure you pass the CA certificate when you register your
     * device certificates with the RegisterCertificate action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCACertificate action.
     */
    suspend fun registerCaCertificate(input: RegisterCaCertificateRequest): RegisterCaCertificateResponse

    /**
     * Registers a CA certificate with IoT. This CA certificate can then be used to sign
     * device certificates, which can be then registered with IoT. You can register up to 10
     * CA certificates per Amazon Web Services account that have the same subject field. This enables you to have
     * up to 10 certificate authorities sign your device certificates. If you have more than one
     * CA certificate registered, make sure you pass the CA certificate when you register your
     * device certificates with the RegisterCertificate action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCACertificate action.
     */
    suspend fun registerCaCertificate(block: RegisterCaCertificateRequest.Builder.() -> Unit) = registerCaCertificate(RegisterCaCertificateRequest.Builder().apply(block).build())

    /**
     * Registers a device certificate with IoT. If you have more than one CA certificate
     * that has the same subject field, you must specify the CA certificate that was used to sign
     * the device certificate being registered.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCertificate action.
     */
    suspend fun registerCertificate(input: RegisterCertificateRequest): RegisterCertificateResponse

    /**
     * Registers a device certificate with IoT. If you have more than one CA certificate
     * that has the same subject field, you must specify the CA certificate that was used to sign
     * the device certificate being registered.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCertificate action.
     */
    suspend fun registerCertificate(block: RegisterCertificateRequest.Builder.() -> Unit) = registerCertificate(RegisterCertificateRequest.Builder().apply(block).build())

    /**
     * Register a certificate that does not have a certificate authority (CA).
     * For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT.
     */
    suspend fun registerCertificateWithoutCa(input: RegisterCertificateWithoutCaRequest): RegisterCertificateWithoutCaResponse

    /**
     * Register a certificate that does not have a certificate authority (CA).
     * For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT.
     */
    suspend fun registerCertificateWithoutCa(block: RegisterCertificateWithoutCaRequest.Builder.() -> Unit) = registerCertificateWithoutCa(RegisterCertificateWithoutCaRequest.Builder().apply(block).build())

    /**
     * Provisions a thing in the device registry. RegisterThing calls other IoT control
     * plane APIs. These calls might exceed your account level <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot">
     * IoT Throttling Limits and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Customer Support to raise
     * your throttling limits if necessary.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterThing action.
     */
    suspend fun registerThing(input: RegisterThingRequest): RegisterThingResponse

    /**
     * Provisions a thing in the device registry. RegisterThing calls other IoT control
     * plane APIs. These calls might exceed your account level <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot">
     * IoT Throttling Limits and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Customer Support to raise
     * your throttling limits if necessary.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterThing action.
     */
    suspend fun registerThing(block: RegisterThingRequest.Builder.() -> Unit) = registerThing(RegisterThingRequest.Builder().apply(block).build())

    /**
     * Rejects a pending certificate transfer. After IoT rejects a certificate transfer,
     * the certificate status changes from PENDING_TRANSFER to
     * INACTIVE.
     * To check for pending certificate transfers, call ListCertificates
     * to enumerate your certificates.
     * This operation can only be called by the transfer destination. After it is called,
     * the certificate will be returned to the source's account in the INACTIVE state.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RejectCertificateTransfer action.
     */
    suspend fun rejectCertificateTransfer(input: RejectCertificateTransferRequest): RejectCertificateTransferResponse

    /**
     * Rejects a pending certificate transfer. After IoT rejects a certificate transfer,
     * the certificate status changes from PENDING_TRANSFER to
     * INACTIVE.
     * To check for pending certificate transfers, call ListCertificates
     * to enumerate your certificates.
     * This operation can only be called by the transfer destination. After it is called,
     * the certificate will be returned to the source's account in the INACTIVE state.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RejectCertificateTransfer action.
     */
    suspend fun rejectCertificateTransfer(block: RejectCertificateTransferRequest.Builder.() -> Unit) = rejectCertificateTransfer(RejectCertificateTransferRequest.Builder().apply(block).build())

    /**
     * Removes the given thing from the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RemoveThingFromBillingGroup action.
     *
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     */
    suspend fun removeThingFromBillingGroup(input: RemoveThingFromBillingGroupRequest): RemoveThingFromBillingGroupResponse

    /**
     * Removes the given thing from the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RemoveThingFromBillingGroup action.
     *
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     */
    suspend fun removeThingFromBillingGroup(block: RemoveThingFromBillingGroupRequest.Builder.() -> Unit) = removeThingFromBillingGroup(RemoveThingFromBillingGroupRequest.Builder().apply(block).build())

    /**
     * Remove the specified thing from the specified group.
     * You must specify either a thingGroupArn or a
     * thingGroupName to identify the thing group and
     * either a thingArn or a thingName to
     * identify the thing to remove from the thing group.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RemoveThingFromThingGroup action.
     */
    suspend fun removeThingFromThingGroup(input: RemoveThingFromThingGroupRequest): RemoveThingFromThingGroupResponse

    /**
     * Remove the specified thing from the specified group.
     * You must specify either a thingGroupArn or a
     * thingGroupName to identify the thing group and
     * either a thingArn or a thingName to
     * identify the thing to remove from the thing group.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RemoveThingFromThingGroup action.
     */
    suspend fun removeThingFromThingGroup(block: RemoveThingFromThingGroupRequest.Builder.() -> Unit) = removeThingFromThingGroup(RemoveThingFromThingGroupRequest.Builder().apply(block).build())

    /**
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules
     * is an administrator-level action. Any user who has permission to create rules will be able
     * to access data processed by the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ReplaceTopicRule action.
     */
    suspend fun replaceTopicRule(input: ReplaceTopicRuleRequest): ReplaceTopicRuleResponse

    /**
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules
     * is an administrator-level action. Any user who has permission to create rules will be able
     * to access data processed by the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ReplaceTopicRule action.
     */
    suspend fun replaceTopicRule(block: ReplaceTopicRuleRequest.Builder.() -> Unit) = replaceTopicRule(ReplaceTopicRuleRequest.Builder().apply(block).build())

    /**
     * The query search index.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SearchIndex action.
     */
    suspend fun searchIndex(input: SearchIndexRequest): SearchIndexResponse

    /**
     * The query search index.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SearchIndex action.
     */
    suspend fun searchIndex(block: SearchIndexRequest.Builder.() -> Unit) = searchIndex(SearchIndexRequest.Builder().apply(block).build())

    /**
     * Sets the default authorizer. This will be used if a websocket connection is made
     * without specifying an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetDefaultAuthorizer action.
     */
    suspend fun setDefaultAuthorizer(input: SetDefaultAuthorizerRequest): SetDefaultAuthorizerResponse

    /**
     * Sets the default authorizer. This will be used if a websocket connection is made
     * without specifying an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetDefaultAuthorizer action.
     */
    suspend fun setDefaultAuthorizer(block: SetDefaultAuthorizerRequest.Builder.() -> Unit) = setDefaultAuthorizer(SetDefaultAuthorizerRequest.Builder().apply(block).build())

    /**
     * Sets the specified version of the specified policy as the policy's default
     * (operative) version. This action affects all certificates to which the policy is attached.
     * To list the principals the policy is attached to, use the ListPrincipalPolicies
     * action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetDefaultPolicyVersion action.
     */
    suspend fun setDefaultPolicyVersion(input: SetDefaultPolicyVersionRequest): SetDefaultPolicyVersionResponse

    /**
     * Sets the specified version of the specified policy as the policy's default
     * (operative) version. This action affects all certificates to which the policy is attached.
     * To list the principals the policy is attached to, use the ListPrincipalPolicies
     * action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetDefaultPolicyVersion action.
     */
    suspend fun setDefaultPolicyVersion(block: SetDefaultPolicyVersionRequest.Builder.() -> Unit) = setDefaultPolicyVersion(SetDefaultPolicyVersionRequest.Builder().apply(block).build())

    /**
     * Sets the logging options.
     * NOTE: use of this command is not recommended. Use SetV2LoggingOptions
     * instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetLoggingOptions action.
     */
    suspend fun setLoggingOptions(input: SetLoggingOptionsRequest): SetLoggingOptionsResponse

    /**
     * Sets the logging options.
     * NOTE: use of this command is not recommended. Use SetV2LoggingOptions
     * instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetLoggingOptions action.
     */
    suspend fun setLoggingOptions(block: SetLoggingOptionsRequest.Builder.() -> Unit) = setLoggingOptions(SetLoggingOptionsRequest.Builder().apply(block).build())

    /**
     * Sets the logging level.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetV2LoggingLevel action.
     */
    suspend fun setV2LoggingLevel(input: SetV2LoggingLevelRequest): SetV2LoggingLevelResponse

    /**
     * Sets the logging level.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetV2LoggingLevel action.
     */
    suspend fun setV2LoggingLevel(block: SetV2LoggingLevelRequest.Builder.() -> Unit) = setV2LoggingLevel(SetV2LoggingLevelRequest.Builder().apply(block).build())

    /**
     * Sets the logging options for the V2 logging service.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetV2LoggingOptions action.
     */
    suspend fun setV2LoggingOptions(input: SetV2LoggingOptionsRequest): SetV2LoggingOptionsResponse

    /**
     * Sets the logging options for the V2 logging service.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetV2LoggingOptions action.
     */
    suspend fun setV2LoggingOptions(block: SetV2LoggingOptionsRequest.Builder.() -> Unit) = setV2LoggingOptions(SetV2LoggingOptionsRequest.Builder().apply(block).build())

    /**
     * Starts a task that applies a set of mitigation actions to the specified target.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartAuditMitigationActionsTask action.
     */
    suspend fun startAuditMitigationActionsTask(input: StartAuditMitigationActionsTaskRequest): StartAuditMitigationActionsTaskResponse

    /**
     * Starts a task that applies a set of mitigation actions to the specified target.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartAuditMitigationActionsTask action.
     */
    suspend fun startAuditMitigationActionsTask(block: StartAuditMitigationActionsTaskRequest.Builder.() -> Unit) = startAuditMitigationActionsTask(StartAuditMitigationActionsTaskRequest.Builder().apply(block).build())

    /**
     * Starts a Device Defender ML Detect mitigation actions task.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartDetectMitigationActionsTask action.
     */
    suspend fun startDetectMitigationActionsTask(input: StartDetectMitigationActionsTaskRequest): StartDetectMitigationActionsTaskResponse

    /**
     * Starts a Device Defender ML Detect mitigation actions task.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartDetectMitigationActionsTask action.
     */
    suspend fun startDetectMitigationActionsTask(block: StartDetectMitigationActionsTaskRequest.Builder.() -> Unit) = startDetectMitigationActionsTask(StartDetectMitigationActionsTaskRequest.Builder().apply(block).build())

    /**
     * Starts an on-demand Device Defender audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartOnDemandAuditTask action.
     */
    suspend fun startOnDemandAuditTask(input: StartOnDemandAuditTaskRequest): StartOnDemandAuditTaskResponse

    /**
     * Starts an on-demand Device Defender audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartOnDemandAuditTask action.
     */
    suspend fun startOnDemandAuditTask(block: StartOnDemandAuditTaskRequest.Builder.() -> Unit) = startOnDemandAuditTask(StartOnDemandAuditTaskRequest.Builder().apply(block).build())

    /**
     * Creates a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartThingRegistrationTask action.
     */
    suspend fun startThingRegistrationTask(input: StartThingRegistrationTaskRequest): StartThingRegistrationTaskResponse

    /**
     * Creates a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartThingRegistrationTask action.
     */
    suspend fun startThingRegistrationTask(block: StartThingRegistrationTaskRequest.Builder.() -> Unit) = startThingRegistrationTask(StartThingRegistrationTaskRequest.Builder().apply(block).build())

    /**
     * Cancels a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StopThingRegistrationTask action.
     */
    suspend fun stopThingRegistrationTask(input: StopThingRegistrationTaskRequest): StopThingRegistrationTaskResponse

    /**
     * Cancels a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StopThingRegistrationTask action.
     */
    suspend fun stopThingRegistrationTask(block: StopThingRegistrationTaskRequest.Builder.() -> Unit) = stopThingRegistrationTask(StopThingRegistrationTaskRequest.Builder().apply(block).build())

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be
     * used to manage a resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TagResource action.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be
     * used to manage a resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TagResource action.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Tests if a specified principal is authorized to perform an IoT action on a
     * specified resource. Use this to test and debug the authorization behavior of devices that
     * connect to the IoT device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TestAuthorization action.
     */
    suspend fun testAuthorization(input: TestAuthorizationRequest): TestAuthorizationResponse

    /**
     * Tests if a specified principal is authorized to perform an IoT action on a
     * specified resource. Use this to test and debug the authorization behavior of devices that
     * connect to the IoT device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TestAuthorization action.
     */
    suspend fun testAuthorization(block: TestAuthorizationRequest.Builder.() -> Unit) = testAuthorization(TestAuthorizationRequest.Builder().apply(block).build())

    /**
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use
     * this to test and debug the custom authorization behavior of devices that connect to the IoT
     * device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TestInvokeAuthorizer action.
     */
    suspend fun testInvokeAuthorizer(input: TestInvokeAuthorizerRequest): TestInvokeAuthorizerResponse

    /**
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use
     * this to test and debug the custom authorization behavior of devices that connect to the IoT
     * device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TestInvokeAuthorizer action.
     */
    suspend fun testInvokeAuthorizer(block: TestInvokeAuthorizerRequest.Builder.() -> Unit) = testInvokeAuthorizer(TestInvokeAuthorizerRequest.Builder().apply(block).build())

    /**
     * Transfers the specified certificate to the specified Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TransferCertificate action.
     *
     * You can cancel the transfer until it is acknowledged by the recipient.
     * No notification is sent to the transfer destination's account. It is up to the caller
     * to notify the transfer target.
     * The certificate being transferred must not be in the ACTIVE state. You can use the
     * UpdateCertificate action to deactivate it.
     * The certificate must not have any policies attached to it. You can use the
     * DetachPolicy action to detach them.
     */
    suspend fun transferCertificate(input: TransferCertificateRequest): TransferCertificateResponse

    /**
     * Transfers the specified certificate to the specified Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TransferCertificate action.
     *
     * You can cancel the transfer until it is acknowledged by the recipient.
     * No notification is sent to the transfer destination's account. It is up to the caller
     * to notify the transfer target.
     * The certificate being transferred must not be in the ACTIVE state. You can use the
     * UpdateCertificate action to deactivate it.
     * The certificate must not have any policies attached to it. You can use the
     * DetachPolicy action to detach them.
     */
    suspend fun transferCertificate(block: TransferCertificateRequest.Builder.() -> Unit) = transferCertificate(TransferCertificateRequest.Builder().apply(block).build())

    /**
     * Removes the given tags (metadata) from the resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UntagResource action.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UntagResource action.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Configures or reconfigures the Device Defender audit settings for this account.
     * Settings include how audit notifications are sent and which audit checks are
     * enabled or disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateAccountAuditConfiguration action.
     */
    suspend fun updateAccountAuditConfiguration(input: UpdateAccountAuditConfigurationRequest): UpdateAccountAuditConfigurationResponse

    /**
     * Configures or reconfigures the Device Defender audit settings for this account.
     * Settings include how audit notifications are sent and which audit checks are
     * enabled or disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateAccountAuditConfiguration action.
     */
    suspend fun updateAccountAuditConfiguration(block: UpdateAccountAuditConfigurationRequest.Builder.() -> Unit) = updateAccountAuditConfiguration(UpdateAccountAuditConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates a Device Defender audit suppression.
     */
    suspend fun updateAuditSuppression(input: UpdateAuditSuppressionRequest): UpdateAuditSuppressionResponse

    /**
     * Updates a Device Defender audit suppression.
     */
    suspend fun updateAuditSuppression(block: UpdateAuditSuppressionRequest.Builder.() -> Unit) = updateAuditSuppression(UpdateAuditSuppressionRequest.Builder().apply(block).build())

    /**
     * Updates an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateAuthorizer action.
     */
    suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse

    /**
     * Updates an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateAuthorizer action.
     */
    suspend fun updateAuthorizer(block: UpdateAuthorizerRequest.Builder.() -> Unit) = updateAuthorizer(UpdateAuthorizerRequest.Builder().apply(block).build())

    /**
     * Updates information about the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateBillingGroup action.
     */
    suspend fun updateBillingGroup(input: UpdateBillingGroupRequest): UpdateBillingGroupResponse

    /**
     * Updates information about the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateBillingGroup action.
     */
    suspend fun updateBillingGroup(block: UpdateBillingGroupRequest.Builder.() -> Unit) = updateBillingGroup(UpdateBillingGroupRequest.Builder().apply(block).build())

    /**
     * Updates a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCACertificate action.
     */
    suspend fun updateCaCertificate(input: UpdateCaCertificateRequest): UpdateCaCertificateResponse

    /**
     * Updates a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCACertificate action.
     */
    suspend fun updateCaCertificate(block: UpdateCaCertificateRequest.Builder.() -> Unit) = updateCaCertificate(UpdateCaCertificateRequest.Builder().apply(block).build())

    /**
     * Updates the status of the specified certificate. This operation is
     * idempotent.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCertificate action.
     *
     * Certificates must be in the ACTIVE state to authenticate devices that use
     * a certificate to connect to IoT.
     * Within a few minutes of updating a certificate from the ACTIVE state to any other
     * state, IoT disconnects all devices that used that certificate to connect. Devices cannot
     * use a certificate that is not in the ACTIVE state to reconnect.
     */
    suspend fun updateCertificate(input: UpdateCertificateRequest): UpdateCertificateResponse

    /**
     * Updates the status of the specified certificate. This operation is
     * idempotent.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCertificate action.
     *
     * Certificates must be in the ACTIVE state to authenticate devices that use
     * a certificate to connect to IoT.
     * Within a few minutes of updating a certificate from the ACTIVE state to any other
     * state, IoT disconnects all devices that used that certificate to connect. Devices cannot
     * use a certificate that is not in the ACTIVE state to reconnect.
     */
    suspend fun updateCertificate(block: UpdateCertificateRequest.Builder.() -> Unit) = updateCertificate(UpdateCertificateRequest.Builder().apply(block).build())

    /**
     * Updates a
     * Device Defender detect custom metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCustomMetric action.
     */
    suspend fun updateCustomMetric(input: UpdateCustomMetricRequest): UpdateCustomMetricResponse

    /**
     * Updates a
     * Device Defender detect custom metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCustomMetric action.
     */
    suspend fun updateCustomMetric(block: UpdateCustomMetricRequest.Builder.() -> Unit) = updateCustomMetric(UpdateCustomMetricRequest.Builder().apply(block).build())

    /**
     * Updates the definition for a dimension. You
     * cannot
     * change the type of a dimension after
     * it is created (you can delete it and
     * recreate
     * it).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDimension action.
     */
    suspend fun updateDimension(input: UpdateDimensionRequest): UpdateDimensionResponse

    /**
     * Updates the definition for a dimension. You
     * cannot
     * change the type of a dimension after
     * it is created (you can delete it and
     * recreate
     * it).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDimension action.
     */
    suspend fun updateDimension(block: UpdateDimensionRequest.Builder.() -> Unit) = updateDimension(UpdateDimensionRequest.Builder().apply(block).build())

    /**
     * Updates values stored in the domain configuration. Domain configurations for default
     * endpoints can't be updated.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDomainConfiguration action.
     */
    suspend fun updateDomainConfiguration(input: UpdateDomainConfigurationRequest): UpdateDomainConfigurationResponse

    /**
     * Updates values stored in the domain configuration. Domain configurations for default
     * endpoints can't be updated.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDomainConfiguration action.
     */
    suspend fun updateDomainConfiguration(block: UpdateDomainConfigurationRequest.Builder.() -> Unit) = updateDomainConfiguration(UpdateDomainConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDynamicThingGroup action.
     */
    suspend fun updateDynamicThingGroup(input: UpdateDynamicThingGroupRequest): UpdateDynamicThingGroupResponse

    /**
     * Updates a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDynamicThingGroup action.
     */
    suspend fun updateDynamicThingGroup(block: UpdateDynamicThingGroupRequest.Builder.() -> Unit) = updateDynamicThingGroup(UpdateDynamicThingGroupRequest.Builder().apply(block).build())

    /**
     * Updates the event configurations.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateEventConfigurations action.
     */
    suspend fun updateEventConfigurations(input: UpdateEventConfigurationsRequest): UpdateEventConfigurationsResponse

    /**
     * Updates the event configurations.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateEventConfigurations action.
     */
    suspend fun updateEventConfigurations(block: UpdateEventConfigurationsRequest.Builder.() -> Unit) = updateEventConfigurations(UpdateEventConfigurationsRequest.Builder().apply(block).build())

    /**
     * Updates the data for a fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateFleetMetric action.
     */
    suspend fun updateFleetMetric(input: UpdateFleetMetricRequest): UpdateFleetMetricResponse

    /**
     * Updates the data for a fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateFleetMetric action.
     */
    suspend fun updateFleetMetric(block: UpdateFleetMetricRequest.Builder.() -> Unit) = updateFleetMetric(UpdateFleetMetricRequest.Builder().apply(block).build())

    /**
     * Updates the search configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateIndexingConfiguration action.
     */
    suspend fun updateIndexingConfiguration(input: UpdateIndexingConfigurationRequest): UpdateIndexingConfigurationResponse

    /**
     * Updates the search configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateIndexingConfiguration action.
     */
    suspend fun updateIndexingConfiguration(block: UpdateIndexingConfigurationRequest.Builder.() -> Unit) = updateIndexingConfiguration(UpdateIndexingConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates supported fields of the specified job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateJob action.
     */
    suspend fun updateJob(input: UpdateJobRequest): UpdateJobResponse

    /**
     * Updates supported fields of the specified job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateJob action.
     */
    suspend fun updateJob(block: UpdateJobRequest.Builder.() -> Unit) = updateJob(UpdateJobRequest.Builder().apply(block).build())

    /**
     * Updates the definition for the specified mitigation action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateMitigationAction action.
     */
    suspend fun updateMitigationAction(input: UpdateMitigationActionRequest): UpdateMitigationActionResponse

    /**
     * Updates the definition for the specified mitigation action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateMitigationAction action.
     */
    suspend fun updateMitigationAction(block: UpdateMitigationActionRequest.Builder.() -> Unit) = updateMitigationAction(UpdateMitigationActionRequest.Builder().apply(block).build())

    /**
     * Updates a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateProvisioningTemplate action.
     */
    suspend fun updateProvisioningTemplate(input: UpdateProvisioningTemplateRequest): UpdateProvisioningTemplateResponse

    /**
     * Updates a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateProvisioningTemplate action.
     */
    suspend fun updateProvisioningTemplate(block: UpdateProvisioningTemplateRequest.Builder.() -> Unit) = updateProvisioningTemplate(UpdateProvisioningTemplateRequest.Builder().apply(block).build())

    /**
     * Updates a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateRoleAlias action.
     */
    suspend fun updateRoleAlias(input: UpdateRoleAliasRequest): UpdateRoleAliasResponse

    /**
     * Updates a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateRoleAlias action.
     */
    suspend fun updateRoleAlias(block: UpdateRoleAliasRequest.Builder.() -> Unit) = updateRoleAlias(UpdateRoleAliasRequest.Builder().apply(block).build())

    /**
     * Updates a scheduled audit, including which checks are performed and
     * how often the audit takes place.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateScheduledAudit action.
     */
    suspend fun updateScheduledAudit(input: UpdateScheduledAuditRequest): UpdateScheduledAuditResponse

    /**
     * Updates a scheduled audit, including which checks are performed and
     * how often the audit takes place.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateScheduledAudit action.
     */
    suspend fun updateScheduledAudit(block: UpdateScheduledAuditRequest.Builder.() -> Unit) = updateScheduledAudit(UpdateScheduledAuditRequest.Builder().apply(block).build())

    /**
     * Updates a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateSecurityProfile action.
     */
    suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse

    /**
     * Updates a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateSecurityProfile action.
     */
    suspend fun updateSecurityProfile(block: UpdateSecurityProfileRequest.Builder.() -> Unit) = updateSecurityProfile(UpdateSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Updates an existing stream. The stream version will be incremented by one.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateStream action.
     */
    suspend fun updateStream(input: UpdateStreamRequest): UpdateStreamResponse

    /**
     * Updates an existing stream. The stream version will be incremented by one.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateStream action.
     */
    suspend fun updateStream(block: UpdateStreamRequest.Builder.() -> Unit) = updateStream(UpdateStreamRequest.Builder().apply(block).build())

    /**
     * Updates the data for a thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThing action.
     */
    suspend fun updateThing(input: UpdateThingRequest): UpdateThingResponse

    /**
     * Updates the data for a thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThing action.
     */
    suspend fun updateThing(block: UpdateThingRequest.Builder.() -> Unit) = updateThing(UpdateThingRequest.Builder().apply(block).build())

    /**
     * Update a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingGroup action.
     */
    suspend fun updateThingGroup(input: UpdateThingGroupRequest): UpdateThingGroupResponse

    /**
     * Update a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingGroup action.
     */
    suspend fun updateThingGroup(block: UpdateThingGroupRequest.Builder.() -> Unit) = updateThingGroup(UpdateThingGroupRequest.Builder().apply(block).build())

    /**
     * Updates the groups to which the thing belongs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingGroupsForThing action.
     */
    suspend fun updateThingGroupsForThing(input: UpdateThingGroupsForThingRequest): UpdateThingGroupsForThingResponse

    /**
     * Updates the groups to which the thing belongs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingGroupsForThing action.
     */
    suspend fun updateThingGroupsForThing(block: UpdateThingGroupsForThingRequest.Builder.() -> Unit) = updateThingGroupsForThing(UpdateThingGroupsForThingRequest.Builder().apply(block).build())

    /**
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or
     * confirmation URL of the destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateTopicRuleDestination action.
     */
    suspend fun updateTopicRuleDestination(input: UpdateTopicRuleDestinationRequest): UpdateTopicRuleDestinationResponse

    /**
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or
     * confirmation URL of the destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateTopicRuleDestination action.
     */
    suspend fun updateTopicRuleDestination(block: UpdateTopicRuleDestinationRequest.Builder.() -> Unit) = updateTopicRuleDestination(UpdateTopicRuleDestinationRequest.Builder().apply(block).build())

    /**
     * Validates a Device Defender security profile behaviors specification.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ValidateSecurityProfileBehaviors action.
     */
    suspend fun validateSecurityProfileBehaviors(input: ValidateSecurityProfileBehaviorsRequest): ValidateSecurityProfileBehaviorsResponse

    /**
     * Validates a Device Defender security profile behaviors specification.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ValidateSecurityProfileBehaviors action.
     */
    suspend fun validateSecurityProfileBehaviors(block: ValidateSecurityProfileBehaviorsRequest.Builder.() -> Unit) = validateSecurityProfileBehaviors(ValidateSecurityProfileBehaviorsRequest.Builder().apply(block).build())
}
