// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iot.model.*
import aws.sdk.kotlin.services.iot.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoT"
const val ServiceApiVersion: String = "2015-05-28"
const val SdkVersion: String = "0.15.1-beta"

internal class DefaultIotClient(override val config: IotClient.Config) : IotClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts a pending certificate transfer. The default state of the certificate is
     * INACTIVE.
     * To check for pending certificate transfers, call ListCertificates
     * to enumerate your certificates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AcceptCertificateTransfer action.
     */
    override suspend fun acceptCertificateTransfer(input: AcceptCertificateTransferRequest): AcceptCertificateTransferResponse {
        val op = SdkHttpOperation.build<AcceptCertificateTransferRequest, AcceptCertificateTransferResponse> {
            serializer = AcceptCertificateTransferOperationSerializer()
            deserializer = AcceptCertificateTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptCertificateTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a thing to a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToBillingGroup action.
     */
    override suspend fun addThingToBillingGroup(input: AddThingToBillingGroupRequest): AddThingToBillingGroupResponse {
        val op = SdkHttpOperation.build<AddThingToBillingGroupRequest, AddThingToBillingGroupResponse> {
            serializer = AddThingToBillingGroupOperationSerializer()
            deserializer = AddThingToBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddThingToBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a thing to a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToThingGroup action.
     */
    override suspend fun addThingToThingGroup(input: AddThingToThingGroupRequest): AddThingToThingGroupResponse {
        val op = SdkHttpOperation.build<AddThingToThingGroupRequest, AddThingToThingGroupResponse> {
            serializer = AddThingToThingGroupOperationSerializer()
            deserializer = AddThingToThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddThingToThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a group with a continuous job. The following criteria must be met:
     *
     *
     * The job must have been created with the targetSelection field set to
     * "CONTINUOUS".
     *
     * The job status must currently be "IN_PROGRESS".
     *
     * The total number of targets associated with a job must not exceed 100.
     *
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AssociateTargetsWithJob action.
     */
    override suspend fun associateTargetsWithJob(input: AssociateTargetsWithJobRequest): AssociateTargetsWithJobResponse {
        val op = SdkHttpOperation.build<AssociateTargetsWithJobRequest, AssociateTargetsWithJobResponse> {
            serializer = AssociateTargetsWithJobOperationSerializer()
            deserializer = AssociateTargetsWithJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTargetsWithJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches the specified policy to the specified principal (certificate or other
     * credential).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPolicy action.
     */
    override suspend fun attachPolicy(input: AttachPolicyRequest): AttachPolicyResponse {
        val op = SdkHttpOperation.build<AttachPolicyRequest, AttachPolicyResponse> {
            serializer = AttachPolicyOperationSerializer()
            deserializer = AttachPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches the specified policy to the specified principal (certificate or other
     * credential).
     *
     * Note: This action is deprecated. Please use AttachPolicy instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPrincipalPolicy action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun attachPrincipalPolicy(input: AttachPrincipalPolicyRequest): AttachPrincipalPolicyResponse {
        val op = SdkHttpOperation.build<AttachPrincipalPolicyRequest, AttachPrincipalPolicyResponse> {
            serializer = AttachPrincipalPolicyOperationSerializer()
            deserializer = AttachPrincipalPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachPrincipalPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a Device Defender security profile with a thing group or this account. Each
     * thing group or account can have up to five security profiles associated with it.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachSecurityProfile action.
     */
    override suspend fun attachSecurityProfile(input: AttachSecurityProfileRequest): AttachSecurityProfileResponse {
        val op = SdkHttpOperation.build<AttachSecurityProfileRequest, AttachSecurityProfileResponse> {
            serializer = AttachSecurityProfileOperationSerializer()
            deserializer = AttachSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches the specified principal to the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachThingPrincipal action.
     */
    override suspend fun attachThingPrincipal(input: AttachThingPrincipalRequest): AttachThingPrincipalResponse {
        val op = SdkHttpOperation.build<AttachThingPrincipalRequest, AttachThingPrincipalResponse> {
            serializer = AttachThingPrincipalOperationSerializer()
            deserializer = AttachThingPrincipalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachThingPrincipal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a mitigation action task that is in progress. If the task
     * is not
     * in progress, an InvalidRequestException occurs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditMitigationActionsTask action.
     */
    override suspend fun cancelAuditMitigationActionsTask(input: CancelAuditMitigationActionsTaskRequest): CancelAuditMitigationActionsTaskResponse {
        val op = SdkHttpOperation.build<CancelAuditMitigationActionsTaskRequest, CancelAuditMitigationActionsTaskResponse> {
            serializer = CancelAuditMitigationActionsTaskOperationSerializer()
            deserializer = CancelAuditMitigationActionsTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelAuditMitigationActionsTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditTask action.
     */
    override suspend fun cancelAuditTask(input: CancelAuditTaskRequest): CancelAuditTaskResponse {
        val op = SdkHttpOperation.build<CancelAuditTaskRequest, CancelAuditTaskResponse> {
            serializer = CancelAuditTaskOperationSerializer()
            deserializer = CancelAuditTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelAuditTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a pending transfer for the specified certificate.
     *
     * Note Only the transfer source account can use this
     * operation to cancel a transfer. (Transfer destinations can use RejectCertificateTransfer instead.) After transfer, IoT returns the
     * certificate to the source account in the INACTIVE state. After the destination account has
     * accepted the transfer, the transfer cannot be cancelled.
     * After a certificate transfer is cancelled, the status of the certificate changes from
     * PENDING_TRANSFER to INACTIVE.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelCertificateTransfer action.
     */
    override suspend fun cancelCertificateTransfer(input: CancelCertificateTransferRequest): CancelCertificateTransferResponse {
        val op = SdkHttpOperation.build<CancelCertificateTransferRequest, CancelCertificateTransferResponse> {
            serializer = CancelCertificateTransferOperationSerializer()
            deserializer = CancelCertificateTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelCertificateTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelDetectMitigationActionsTask action.
     */
    override suspend fun cancelDetectMitigationActionsTask(input: CancelDetectMitigationActionsTaskRequest): CancelDetectMitigationActionsTaskResponse {
        val op = SdkHttpOperation.build<CancelDetectMitigationActionsTaskRequest, CancelDetectMitigationActionsTaskResponse> {
            serializer = CancelDetectMitigationActionsTaskOperationSerializer()
            deserializer = CancelDetectMitigationActionsTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelDetectMitigationActionsTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJob action.
     */
    override suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse {
        val op = SdkHttpOperation.build<CancelJobRequest, CancelJobResponse> {
            serializer = CancelJobOperationSerializer()
            deserializer = CancelJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the execution of a job for a given thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJobExecution action.
     */
    override suspend fun cancelJobExecution(input: CancelJobExecutionRequest): CancelJobExecutionResponse {
        val op = SdkHttpOperation.build<CancelJobExecutionRequest, CancelJobExecutionResponse> {
            serializer = CancelJobExecutionOperationSerializer()
            deserializer = CancelJobExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelJobExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Clears the default authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ClearDefaultAuthorizer action.
     */
    override suspend fun clearDefaultAuthorizer(input: ClearDefaultAuthorizerRequest): ClearDefaultAuthorizerResponse {
        val op = SdkHttpOperation.build<ClearDefaultAuthorizerRequest, ClearDefaultAuthorizerResponse> {
            serializer = ClearDefaultAuthorizerOperationSerializer()
            deserializer = ClearDefaultAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ClearDefaultAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT
     * sends a confirmation message to the endpoint or base address you specify. The message
     * includes a token which you pass back when calling ConfirmTopicRuleDestination
     * to confirm that you own or have access to the endpoint.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ConfirmTopicRuleDestination action.
     */
    override suspend fun confirmTopicRuleDestination(input: ConfirmTopicRuleDestinationRequest): ConfirmTopicRuleDestinationResponse {
        val op = SdkHttpOperation.build<ConfirmTopicRuleDestinationRequest, ConfirmTopicRuleDestinationResponse> {
            serializer = ConfirmTopicRuleDestinationOperationSerializer()
            deserializer = ConfirmTopicRuleDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfirmTopicRuleDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Device Defender audit suppression.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuditSuppression action.
     */
    override suspend fun createAuditSuppression(input: CreateAuditSuppressionRequest): CreateAuditSuppressionResponse {
        val op = SdkHttpOperation.build<CreateAuditSuppressionRequest, CreateAuditSuppressionResponse> {
            serializer = CreateAuditSuppressionOperationSerializer()
            deserializer = CreateAuditSuppressionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAuditSuppression"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuthorizer action.
     */
    override suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse {
        val op = SdkHttpOperation.build<CreateAuthorizerRequest, CreateAuthorizerResponse> {
            serializer = CreateAuthorizerOperationSerializer()
            deserializer = CreateAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateBillingGroup action.
     */
    override suspend fun createBillingGroup(input: CreateBillingGroupRequest): CreateBillingGroupResponse {
        val op = SdkHttpOperation.build<CreateBillingGroupRequest, CreateBillingGroupResponse> {
            serializer = CreateBillingGroupOperationSerializer()
            deserializer = CreateBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an X.509 certificate using the specified certificate signing
     * request.
     *
     * Note: The CSR must include a public key that is either an
     * RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-512
     * curves. For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT.
     *
     * Note: Reusing the same certificate signing request (CSR)
     * results in a distinct certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCertificateFromCsr action.
     *
     * You can create multiple certificates in a batch by creating a directory, copying
     * multiple .csr files into that directory, and then specifying that directory on the command
     * line. The following commands show how to create a batch of certificates given a batch of
     * CSRs.
     * Assuming a set of CSRs are located inside of the directory
     * my-csr-directory:
     *
     * On Linux and OS X, the command is:
     *
     * $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/{}
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name
     * to the aws iot create-certificate-from-csr Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * The aws iot create-certificate-from-csr part of the command can also be run in
     * parallel to speed up the certificate creation process:
     * $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/{}
     * On Windows PowerShell, the command to create certificates for all CSRs in
     * my-csr-directory is:
     * > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr
     * --certificate-signing-request file://my-csr-directory/$_}
     * On a Windows command prompt, the command to create certificates for all CSRs in
     * my-csr-directory is:
     * > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
     * --certificate-signing-request file://@path"
     */
    override suspend fun createCertificateFromCsr(input: CreateCertificateFromCsrRequest): CreateCertificateFromCsrResponse {
        val op = SdkHttpOperation.build<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResponse> {
            serializer = CreateCertificateFromCsrOperationSerializer()
            deserializer = CreateCertificateFromCsrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCertificateFromCsr"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this API to define a
     * Custom
     * Metric
     * published by your devices to Device Defender.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCustomMetric action.
     */
    override suspend fun createCustomMetric(input: CreateCustomMetricRequest): CreateCustomMetricResponse {
        val op = SdkHttpOperation.build<CreateCustomMetricRequest, CreateCustomMetricResponse> {
            serializer = CreateCustomMetricOperationSerializer()
            deserializer = CreateCustomMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender.
     * For example, using a TOPIC_FILTER dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDimension action.
     */
    override suspend fun createDimension(input: CreateDimensionRequest): CreateDimensionResponse {
        val op = SdkHttpOperation.build<CreateDimensionRequest, CreateDimensionResponse> {
            serializer = CreateDimensionOperationSerializer()
            deserializer = CreateDimensionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDimension"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDomainConfiguration action.
     */
    override suspend fun createDomainConfiguration(input: CreateDomainConfigurationRequest): CreateDomainConfigurationResponse {
        val op = SdkHttpOperation.build<CreateDomainConfigurationRequest, CreateDomainConfigurationResponse> {
            serializer = CreateDomainConfigurationOperationSerializer()
            deserializer = CreateDomainConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomainConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDynamicThingGroup action.
     */
    override suspend fun createDynamicThingGroup(input: CreateDynamicThingGroupRequest): CreateDynamicThingGroupResponse {
        val op = SdkHttpOperation.build<CreateDynamicThingGroupRequest, CreateDynamicThingGroupResponse> {
            serializer = CreateDynamicThingGroupOperationSerializer()
            deserializer = CreateDynamicThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDynamicThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateFleetMetric action.
     */
    override suspend fun createFleetMetric(input: CreateFleetMetricRequest): CreateFleetMetricResponse {
        val op = SdkHttpOperation.build<CreateFleetMetricRequest, CreateFleetMetricResponse> {
            serializer = CreateFleetMetricOperationSerializer()
            deserializer = CreateFleetMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleetMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJob action.
     */
    override suspend fun createJob(input: CreateJobRequest): CreateJobResponse {
        val op = SdkHttpOperation.build<CreateJobRequest, CreateJobResponse> {
            serializer = CreateJobOperationSerializer()
            deserializer = CreateJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJobTemplate action.
     */
    override suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse {
        val op = SdkHttpOperation.build<CreateJobTemplateRequest, CreateJobTemplateResponse> {
            serializer = CreateJobTemplateOperationSerializer()
            deserializer = CreateJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued
     * public key. You can also call CreateKeysAndCertificate over MQTT from a
     * device, for more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api">Provisioning MQTT API.
     *
     * Note This is the only time IoT issues the private key
     * for this certificate, so it is important to keep it in a secure location.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateKeysAndCertificate action.
     */
    override suspend fun createKeysAndCertificate(input: CreateKeysAndCertificateRequest): CreateKeysAndCertificateResponse {
        val op = SdkHttpOperation.build<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResponse> {
            serializer = CreateKeysAndCertificateOperationSerializer()
            deserializer = CreateKeysAndCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateKeysAndCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names.
     * For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation actions. Each mitigation action can apply only one type of change.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateMitigationAction action.
     */
    override suspend fun createMitigationAction(input: CreateMitigationActionRequest): CreateMitigationActionResponse {
        val op = SdkHttpOperation.build<CreateMitigationActionRequest, CreateMitigationActionResponse> {
            serializer = CreateMitigationActionOperationSerializer()
            deserializer = CreateMitigationActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMitigationAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an IoT OTA update on a target group of things or groups.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateOTAUpdate action.
     */
    override suspend fun createOtaUpdate(input: CreateOtaUpdateRequest): CreateOtaUpdateResponse {
        val op = SdkHttpOperation.build<CreateOtaUpdateRequest, CreateOtaUpdateResponse> {
            serializer = CreateOTAUpdateOperationSerializer()
            deserializer = CreateOTAUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOTAUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an IoT policy.
     * The created policy is the default version for the policy. This operation creates a
     * policy version with a version identifier of 1 and sets
     * 1 as the policy's default version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicy action.
     */
    override suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse {
        val op = SdkHttpOperation.build<CreatePolicyRequest, CreatePolicyResponse> {
            serializer = CreatePolicyOperationSerializer()
            deserializer = CreatePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version of the specified IoT policy. To update a policy, create a
     * new policy version. A managed policy can have up to five versions. If the policy has five
     * versions, you must use DeletePolicyVersion to delete an existing version
     * before you create a new one.
     * Optionally, you can set the new version as the policy's default version. The default
     * version is the operative version (that is, the version that is in effect for the
     * certificates to which the policy is attached).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicyVersion action.
     */
    override suspend fun createPolicyVersion(input: CreatePolicyVersionRequest): CreatePolicyVersionResponse {
        val op = SdkHttpOperation.build<CreatePolicyVersionRequest, CreatePolicyVersionResponse> {
            serializer = CreatePolicyVersionOperationSerializer()
            deserializer = CreatePolicyVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePolicyVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a provisioning claim.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningClaim action.
     */
    override suspend fun createProvisioningClaim(input: CreateProvisioningClaimRequest): CreateProvisioningClaimResponse {
        val op = SdkHttpOperation.build<CreateProvisioningClaimRequest, CreateProvisioningClaimResponse> {
            serializer = CreateProvisioningClaimOperationSerializer()
            deserializer = CreateProvisioningClaimOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProvisioningClaim"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplate action.
     */
    override suspend fun createProvisioningTemplate(input: CreateProvisioningTemplateRequest): CreateProvisioningTemplateResponse {
        val op = SdkHttpOperation.build<CreateProvisioningTemplateRequest, CreateProvisioningTemplateResponse> {
            serializer = CreateProvisioningTemplateOperationSerializer()
            deserializer = CreateProvisioningTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProvisioningTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version of a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplateVersion action.
     */
    override suspend fun createProvisioningTemplateVersion(input: CreateProvisioningTemplateVersionRequest): CreateProvisioningTemplateVersionResponse {
        val op = SdkHttpOperation.build<CreateProvisioningTemplateVersionRequest, CreateProvisioningTemplateVersionResponse> {
            serializer = CreateProvisioningTemplateVersionOperationSerializer()
            deserializer = CreateProvisioningTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProvisioningTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateRoleAlias action.
     */
    override suspend fun createRoleAlias(input: CreateRoleAliasRequest): CreateRoleAliasResponse {
        val op = SdkHttpOperation.build<CreateRoleAliasRequest, CreateRoleAliasResponse> {
            serializer = CreateRoleAliasOperationSerializer()
            deserializer = CreateRoleAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRoleAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a scheduled audit that is run at a specified
     * time interval.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateScheduledAudit action.
     */
    override suspend fun createScheduledAudit(input: CreateScheduledAuditRequest): CreateScheduledAuditResponse {
        val op = SdkHttpOperation.build<CreateScheduledAuditRequest, CreateScheduledAuditResponse> {
            serializer = CreateScheduledAuditOperationSerializer()
            deserializer = CreateScheduledAuditOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateScheduledAudit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSecurityProfile action.
     */
    override suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse {
        val op = SdkHttpOperation.build<CreateSecurityProfileRequest, CreateSecurityProfileResponse> {
            serializer = CreateSecurityProfileOperationSerializer()
            deserializer = CreateSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data
     * bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files
     * associated with a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateStream action.
     */
    override suspend fun createStream(input: CreateStreamRequest): CreateStreamResponse {
        val op = SdkHttpOperation.build<CreateStreamRequest, CreateStreamResponse> {
            serializer = CreateStreamOperationSerializer()
            deserializer = CreateStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a thing record in the registry. If this call is made multiple times using
     * the same thing name and configuration, the call will succeed. If this call is made with
     * the same thing name but different configuration a
     * ResourceAlreadyExistsException is thrown.
     *
     * This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization for
     * information about authorizing control plane actions.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThing action.
     */
    override suspend fun createThing(input: CreateThingRequest): CreateThingResponse {
        val op = SdkHttpOperation.build<CreateThingRequest, CreateThingResponse> {
            serializer = CreateThingOperationSerializer()
            deserializer = CreateThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a thing group.
     *
     * This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization for
     * information about authorizing control plane actions.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingGroup action.
     */
    override suspend fun createThingGroup(input: CreateThingGroupRequest): CreateThingGroupResponse {
        val op = SdkHttpOperation.build<CreateThingGroupRequest, CreateThingGroupResponse> {
            serializer = CreateThingGroupOperationSerializer()
            deserializer = CreateThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingType action.
     */
    override suspend fun createThingType(input: CreateThingTypeRequest): CreateThingTypeResponse {
        val op = SdkHttpOperation.build<CreateThingTypeRequest, CreateThingTypeResponse> {
            serializer = CreateThingTypeOperationSerializer()
            deserializer = CreateThingTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateThingType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a rule. Creating rules is an administrator-level action. Any user who has
     * permission to create rules will be able to access data processed by the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRule action.
     */
    override suspend fun createTopicRule(input: CreateTopicRuleRequest): CreateTopicRuleResponse {
        val op = SdkHttpOperation.build<CreateTopicRuleRequest, CreateTopicRuleResponse> {
            serializer = CreateTopicRuleOperationSerializer()
            deserializer = CreateTopicRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTopicRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRuleDestination action.
     */
    override suspend fun createTopicRuleDestination(input: CreateTopicRuleDestinationRequest): CreateTopicRuleDestinationResponse {
        val op = SdkHttpOperation.build<CreateTopicRuleDestinationRequest, CreateTopicRuleDestinationResponse> {
            serializer = CreateTopicRuleDestinationOperationSerializer()
            deserializer = CreateTopicRuleDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTopicRuleDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores the default settings for Device Defender audits for this account. Any
     * configuration data you entered is deleted and all audit checks are reset to
     * disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAccountAuditConfiguration action.
     */
    override suspend fun deleteAccountAuditConfiguration(input: DeleteAccountAuditConfigurationRequest): DeleteAccountAuditConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteAccountAuditConfigurationRequest, DeleteAccountAuditConfigurationResponse> {
            serializer = DeleteAccountAuditConfigurationOperationSerializer()
            deserializer = DeleteAccountAuditConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccountAuditConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Device Defender audit suppression.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuditSuppression action.
     */
    override suspend fun deleteAuditSuppression(input: DeleteAuditSuppressionRequest): DeleteAuditSuppressionResponse {
        val op = SdkHttpOperation.build<DeleteAuditSuppressionRequest, DeleteAuditSuppressionResponse> {
            serializer = DeleteAuditSuppressionOperationSerializer()
            deserializer = DeleteAuditSuppressionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAuditSuppression"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuthorizer action.
     */
    override suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse {
        val op = SdkHttpOperation.build<DeleteAuthorizerRequest, DeleteAuthorizerResponse> {
            serializer = DeleteAuthorizerOperationSerializer()
            deserializer = DeleteAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteBillingGroup action.
     */
    override suspend fun deleteBillingGroup(input: DeleteBillingGroupRequest): DeleteBillingGroupResponse {
        val op = SdkHttpOperation.build<DeleteBillingGroupRequest, DeleteBillingGroupResponse> {
            serializer = DeleteBillingGroupOperationSerializer()
            deserializer = DeleteBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCACertificate action.
     */
    override suspend fun deleteCaCertificate(input: DeleteCaCertificateRequest): DeleteCaCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCaCertificateRequest, DeleteCaCertificateResponse> {
            serializer = DeleteCACertificateOperationSerializer()
            deserializer = DeleteCACertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCACertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified certificate.
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if
     * its status is set to ACTIVE. To delete a certificate, first use the DetachPolicy action to detach all policies. Next, use the UpdateCertificate action to set the certificate to the INACTIVE
     * status.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCertificate action.
     */
    override suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCertificateRequest, DeleteCertificateResponse> {
            serializer = DeleteCertificateOperationSerializer()
            deserializer = DeleteCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Device Defender detect custom metric.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCustomMetric action.
     *
     * Before you can delete a custom metric, you must first remove the custom metric from all
     * security profiles it's a part of.
     * The
     * security
     * profile associated with the custom metric can be found using the <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles
     * API with metricName set to your custom metric name.
     */
    override suspend fun deleteCustomMetric(input: DeleteCustomMetricRequest): DeleteCustomMetricResponse {
        val op = SdkHttpOperation.build<DeleteCustomMetricRequest, DeleteCustomMetricResponse> {
            serializer = DeleteCustomMetricOperationSerializer()
            deserializer = DeleteCustomMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified dimension from your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDimension action.
     */
    override suspend fun deleteDimension(input: DeleteDimensionRequest): DeleteDimensionResponse {
        val op = SdkHttpOperation.build<DeleteDimensionRequest, DeleteDimensionResponse> {
            serializer = DeleteDimensionOperationSerializer()
            deserializer = DeleteDimensionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDimension"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDomainConfiguration action.
     */
    override suspend fun deleteDomainConfiguration(input: DeleteDomainConfigurationRequest): DeleteDomainConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteDomainConfigurationRequest, DeleteDomainConfigurationResponse> {
            serializer = DeleteDomainConfigurationOperationSerializer()
            deserializer = DeleteDomainConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomainConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDynamicThingGroup action.
     */
    override suspend fun deleteDynamicThingGroup(input: DeleteDynamicThingGroupRequest): DeleteDynamicThingGroupResponse {
        val op = SdkHttpOperation.build<DeleteDynamicThingGroupRequest, DeleteDynamicThingGroupResponse> {
            serializer = DeleteDynamicThingGroupOperationSerializer()
            deserializer = DeleteDynamicThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDynamicThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified fleet metric.
     * Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteFleetMetric action.
     */
    override suspend fun deleteFleetMetric(input: DeleteFleetMetricRequest): DeleteFleetMetricResponse {
        val op = SdkHttpOperation.build<DeleteFleetMetricRequest, DeleteFleetMetricResponse> {
            serializer = DeleteFleetMetricOperationSerializer()
            deserializer = DeleteFleetMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleetMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a job and its related job executions.
     * Deleting a job may take time, depending on the number of job
     * executions created for the job and various other factors. While the job
     * is being deleted, the status of the job will be shown as
     * "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status
     * is already "DELETION_IN_PROGRESS" will result in an error.
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or
     * a LimitExceededException will occur.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJob action.
     */
    override suspend fun deleteJob(input: DeleteJobRequest): DeleteJobResponse {
        val op = SdkHttpOperation.build<DeleteJobRequest, DeleteJobResponse> {
            serializer = DeleteJobOperationSerializer()
            deserializer = DeleteJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a job execution.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJobExecution action.
     */
    override suspend fun deleteJobExecution(input: DeleteJobExecutionRequest): DeleteJobExecutionResponse {
        val op = SdkHttpOperation.build<DeleteJobExecutionRequest, DeleteJobExecutionResponse> {
            serializer = DeleteJobExecutionOperationSerializer()
            deserializer = DeleteJobExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteJobExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified job template.
     */
    override suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse {
        val op = SdkHttpOperation.build<DeleteJobTemplateRequest, DeleteJobTemplateResponse> {
            serializer = DeleteJobTemplateOperationSerializer()
            deserializer = DeleteJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteMitigationAction action.
     */
    override suspend fun deleteMitigationAction(input: DeleteMitigationActionRequest): DeleteMitigationActionResponse {
        val op = SdkHttpOperation.build<DeleteMitigationActionRequest, DeleteMitigationActionResponse> {
            serializer = DeleteMitigationActionOperationSerializer()
            deserializer = DeleteMitigationActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMitigationAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an OTA update.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteOTAUpdate action.
     */
    override suspend fun deleteOtaUpdate(input: DeleteOtaUpdateRequest): DeleteOtaUpdateResponse {
        val op = SdkHttpOperation.build<DeleteOtaUpdateRequest, DeleteOtaUpdateResponse> {
            serializer = DeleteOTAUpdateOperationSerializer()
            deserializer = DeleteOTAUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOTAUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified policy.
     * A policy cannot be deleted if it has non-default versions or it is attached to any
     * certificate.
     * To delete a policy, use the DeletePolicyVersion action to delete all non-default
     * versions of the policy; use the DetachPolicy action to detach the policy from any
     * certificate; and then use the DeletePolicy action to delete the policy.
     * When a policy is deleted using DeletePolicy, its default version is deleted with
     * it.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after
     * a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicy action.
     */
    override suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse {
        val op = SdkHttpOperation.build<DeletePolicyRequest, DeletePolicyResponse> {
            serializer = DeletePolicyOperationSerializer()
            deserializer = DeletePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified version of the specified policy. You cannot delete the default
     * version of a policy using this action. To delete the default version of a policy, use DeletePolicy. To find out which version of a policy is marked as the default
     * version, use ListPolicyVersions.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicyVersion action.
     */
    override suspend fun deletePolicyVersion(input: DeletePolicyVersionRequest): DeletePolicyVersionResponse {
        val op = SdkHttpOperation.build<DeletePolicyVersionRequest, DeletePolicyVersionResponse> {
            serializer = DeletePolicyVersionOperationSerializer()
            deserializer = DeletePolicyVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePolicyVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplate action.
     */
    override suspend fun deleteProvisioningTemplate(input: DeleteProvisioningTemplateRequest): DeleteProvisioningTemplateResponse {
        val op = SdkHttpOperation.build<DeleteProvisioningTemplateRequest, DeleteProvisioningTemplateResponse> {
            serializer = DeleteProvisioningTemplateOperationSerializer()
            deserializer = DeleteProvisioningTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProvisioningTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a fleet provisioning template version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplateVersion action.
     */
    override suspend fun deleteProvisioningTemplateVersion(input: DeleteProvisioningTemplateVersionRequest): DeleteProvisioningTemplateVersionResponse {
        val op = SdkHttpOperation.build<DeleteProvisioningTemplateVersionRequest, DeleteProvisioningTemplateVersionResponse> {
            serializer = DeleteProvisioningTemplateVersionOperationSerializer()
            deserializer = DeleteProvisioningTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProvisioningTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a CA certificate registration code.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRegistrationCode action.
     */
    override suspend fun deleteRegistrationCode(input: DeleteRegistrationCodeRequest): DeleteRegistrationCodeResponse {
        val op = SdkHttpOperation.build<DeleteRegistrationCodeRequest, DeleteRegistrationCodeResponse> {
            serializer = DeleteRegistrationCodeOperationSerializer()
            deserializer = DeleteRegistrationCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRegistrationCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a role alias
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRoleAlias action.
     */
    override suspend fun deleteRoleAlias(input: DeleteRoleAliasRequest): DeleteRoleAliasResponse {
        val op = SdkHttpOperation.build<DeleteRoleAliasRequest, DeleteRoleAliasResponse> {
            serializer = DeleteRoleAliasOperationSerializer()
            deserializer = DeleteRoleAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRoleAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a scheduled audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteScheduledAudit action.
     */
    override suspend fun deleteScheduledAudit(input: DeleteScheduledAuditRequest): DeleteScheduledAuditResponse {
        val op = SdkHttpOperation.build<DeleteScheduledAuditRequest, DeleteScheduledAuditResponse> {
            serializer = DeleteScheduledAuditOperationSerializer()
            deserializer = DeleteScheduledAuditOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteScheduledAudit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSecurityProfile action.
     */
    override suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse {
        val op = SdkHttpOperation.build<DeleteSecurityProfileRequest, DeleteSecurityProfileResponse> {
            serializer = DeleteSecurityProfileOperationSerializer()
            deserializer = DeleteSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteStream action.
     */
    override suspend fun deleteStream(input: DeleteStreamRequest): DeleteStreamResponse {
        val op = SdkHttpOperation.build<DeleteStreamRequest, DeleteStreamResponse> {
            serializer = DeleteStreamOperationSerializer()
            deserializer = DeleteStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified thing. Returns successfully with no error if the deletion is
     * successful or you specify a thing that doesn't exist.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThing action.
     */
    override suspend fun deleteThing(input: DeleteThingRequest): DeleteThingResponse {
        val op = SdkHttpOperation.build<DeleteThingRequest, DeleteThingResponse> {
            serializer = DeleteThingOperationSerializer()
            deserializer = DeleteThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingGroup action.
     */
    override suspend fun deleteThingGroup(input: DeleteThingGroupRequest): DeleteThingGroupResponse {
        val op = SdkHttpOperation.build<DeleteThingGroupRequest, DeleteThingGroupResponse> {
            serializer = DeleteThingGroupOperationSerializer()
            deserializer = DeleteThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified thing type. You cannot delete a thing type if it has things
     * associated with it. To delete a thing type, first mark it as deprecated by calling DeprecateThingType, then remove any associated things by calling UpdateThing to change the thing type on any associated thing, and
     * finally use DeleteThingType to delete the thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingType action.
     */
    override suspend fun deleteThingType(input: DeleteThingTypeRequest): DeleteThingTypeResponse {
        val op = SdkHttpOperation.build<DeleteThingTypeRequest, DeleteThingTypeResponse> {
            serializer = DeleteThingTypeOperationSerializer()
            deserializer = DeleteThingTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteThingType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRule action.
     */
    override suspend fun deleteTopicRule(input: DeleteTopicRuleRequest): DeleteTopicRuleResponse {
        val op = SdkHttpOperation.build<DeleteTopicRuleRequest, DeleteTopicRuleResponse> {
            serializer = DeleteTopicRuleOperationSerializer()
            deserializer = DeleteTopicRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTopicRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a topic rule destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRuleDestination action.
     */
    override suspend fun deleteTopicRuleDestination(input: DeleteTopicRuleDestinationRequest): DeleteTopicRuleDestinationResponse {
        val op = SdkHttpOperation.build<DeleteTopicRuleDestinationRequest, DeleteTopicRuleDestinationResponse> {
            serializer = DeleteTopicRuleDestinationOperationSerializer()
            deserializer = DeleteTopicRuleDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTopicRuleDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a logging level.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteV2LoggingLevel action.
     */
    override suspend fun deleteV2LoggingLevel(input: DeleteV2LoggingLevelRequest): DeleteV2LoggingLevelResponse {
        val op = SdkHttpOperation.build<DeleteV2LoggingLevelRequest, DeleteV2LoggingLevelResponse> {
            serializer = DeleteV2LoggingLevelOperationSerializer()
            deserializer = DeleteV2LoggingLevelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteV2LoggingLevel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing
     * type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType action.
     */
    override suspend fun deprecateThingType(input: DeprecateThingTypeRequest): DeprecateThingTypeResponse {
        val op = SdkHttpOperation.build<DeprecateThingTypeRequest, DeprecateThingTypeResponse> {
            serializer = DeprecateThingTypeOperationSerializer()
            deserializer = DeprecateThingTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprecateThingType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the Device Defender audit settings for this account.
     * Settings include how audit notifications are sent and which audit checks are
     * enabled or disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAccountAuditConfiguration action.
     */
    override suspend fun describeAccountAuditConfiguration(input: DescribeAccountAuditConfigurationRequest): DescribeAccountAuditConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeAccountAuditConfigurationRequest, DescribeAccountAuditConfigurationResponse> {
            serializer = DescribeAccountAuditConfigurationOperationSerializer()
            deserializer = DescribeAccountAuditConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAuditConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a single audit finding. Properties include the reason for
     * noncompliance, the severity of the issue,
     * and the start time
     * when the audit that returned the
     * finding.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditFinding action.
     */
    override suspend fun describeAuditFinding(input: DescribeAuditFindingRequest): DescribeAuditFindingResponse {
        val op = SdkHttpOperation.build<DescribeAuditFindingRequest, DescribeAuditFindingResponse> {
            serializer = DescribeAuditFindingOperationSerializer()
            deserializer = DescribeAuditFindingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuditFinding"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.
     */
    override suspend fun describeAuditMitigationActionsTask(input: DescribeAuditMitigationActionsTaskRequest): DescribeAuditMitigationActionsTaskResponse {
        val op = SdkHttpOperation.build<DescribeAuditMitigationActionsTaskRequest, DescribeAuditMitigationActionsTaskResponse> {
            serializer = DescribeAuditMitigationActionsTaskOperationSerializer()
            deserializer = DescribeAuditMitigationActionsTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuditMitigationActionsTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Defender audit suppression.
     */
    override suspend fun describeAuditSuppression(input: DescribeAuditSuppressionRequest): DescribeAuditSuppressionResponse {
        val op = SdkHttpOperation.build<DescribeAuditSuppressionRequest, DescribeAuditSuppressionResponse> {
            serializer = DescribeAuditSuppressionOperationSerializer()
            deserializer = DescribeAuditSuppressionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuditSuppression"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Defender audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditTask action.
     */
    override suspend fun describeAuditTask(input: DescribeAuditTaskRequest): DescribeAuditTaskResponse {
        val op = SdkHttpOperation.build<DescribeAuditTaskRequest, DescribeAuditTaskResponse> {
            serializer = DescribeAuditTaskOperationSerializer()
            deserializer = DescribeAuditTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuditTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuthorizer action.
     */
    override suspend fun describeAuthorizer(input: DescribeAuthorizerRequest): DescribeAuthorizerResponse {
        val op = SdkHttpOperation.build<DescribeAuthorizerRequest, DescribeAuthorizerResponse> {
            serializer = DescribeAuthorizerOperationSerializer()
            deserializer = DescribeAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeBillingGroup action.
     */
    override suspend fun describeBillingGroup(input: DescribeBillingGroupRequest): DescribeBillingGroupResponse {
        val op = SdkHttpOperation.build<DescribeBillingGroupRequest, DescribeBillingGroupResponse> {
            serializer = DescribeBillingGroupOperationSerializer()
            deserializer = DescribeBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCACertificate action.
     */
    override suspend fun describeCaCertificate(input: DescribeCaCertificateRequest): DescribeCaCertificateResponse {
        val op = SdkHttpOperation.build<DescribeCaCertificateRequest, DescribeCaCertificateResponse> {
            serializer = DescribeCACertificateOperationSerializer()
            deserializer = DescribeCACertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCACertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCertificate action.
     */
    override suspend fun describeCertificate(input: DescribeCertificateRequest): DescribeCertificateResponse {
        val op = SdkHttpOperation.build<DescribeCertificateRequest, DescribeCertificateResponse> {
            serializer = DescribeCertificateOperationSerializer()
            deserializer = DescribeCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Defender detect custom metric.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCustomMetric action.
     */
    override suspend fun describeCustomMetric(input: DescribeCustomMetricRequest): DescribeCustomMetricResponse {
        val op = SdkHttpOperation.build<DescribeCustomMetricRequest, DescribeCustomMetricResponse> {
            serializer = DescribeCustomMetricOperationSerializer()
            deserializer = DescribeCustomMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the default authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDefaultAuthorizer action.
     */
    override suspend fun describeDefaultAuthorizer(input: DescribeDefaultAuthorizerRequest): DescribeDefaultAuthorizerResponse {
        val op = SdkHttpOperation.build<DescribeDefaultAuthorizerRequest, DescribeDefaultAuthorizerResponse> {
            serializer = DescribeDefaultAuthorizerOperationSerializer()
            deserializer = DescribeDefaultAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDefaultAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Defender ML Detect mitigation action.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDetectMitigationActionsTask action.
     */
    override suspend fun describeDetectMitigationActionsTask(input: DescribeDetectMitigationActionsTaskRequest): DescribeDetectMitigationActionsTaskResponse {
        val op = SdkHttpOperation.build<DescribeDetectMitigationActionsTaskRequest, DescribeDetectMitigationActionsTaskResponse> {
            serializer = DescribeDetectMitigationActionsTaskOperationSerializer()
            deserializer = DescribeDetectMitigationActionsTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDetectMitigationActionsTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDimension action.
     */
    override suspend fun describeDimension(input: DescribeDimensionRequest): DescribeDimensionResponse {
        val op = SdkHttpOperation.build<DescribeDimensionRequest, DescribeDimensionResponse> {
            serializer = DescribeDimensionOperationSerializer()
            deserializer = DescribeDimensionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDimension"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets summary information about a domain configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDomainConfiguration action.
     */
    override suspend fun describeDomainConfiguration(input: DescribeDomainConfigurationRequest): DescribeDomainConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeDomainConfigurationRequest, DescribeDomainConfigurationResponse> {
            serializer = DescribeDomainConfigurationOperationSerializer()
            deserializer = DescribeDomainConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEndpoint action.
     */
    override suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse {
        val op = SdkHttpOperation.build<DescribeEndpointRequest, DescribeEndpointResponse> {
            serializer = DescribeEndpointOperationSerializer()
            deserializer = DescribeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes event configurations.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEventConfigurations action.
     */
    override suspend fun describeEventConfigurations(input: DescribeEventConfigurationsRequest): DescribeEventConfigurationsResponse {
        val op = SdkHttpOperation.build<DescribeEventConfigurationsRequest, DescribeEventConfigurationsResponse> {
            serializer = DescribeEventConfigurationsOperationSerializer()
            deserializer = DescribeEventConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeFleetMetric action.
     */
    override suspend fun describeFleetMetric(input: DescribeFleetMetricRequest): DescribeFleetMetricResponse {
        val op = SdkHttpOperation.build<DescribeFleetMetricRequest, DescribeFleetMetricResponse> {
            serializer = DescribeFleetMetricOperationSerializer()
            deserializer = DescribeFleetMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleetMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a search index.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeIndex action.
     */
    override suspend fun describeIndex(input: DescribeIndexRequest): DescribeIndexResponse {
        val op = SdkHttpOperation.build<DescribeIndexRequest, DescribeIndexResponse> {
            serializer = DescribeIndexOperationSerializer()
            deserializer = DescribeIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJob action.
     */
    override suspend fun describeJob(input: DescribeJobRequest): DescribeJobResponse {
        val op = SdkHttpOperation.build<DescribeJobRequest, DescribeJobResponse> {
            serializer = DescribeJobOperationSerializer()
            deserializer = DescribeJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a job execution.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJobExecution action.
     */
    override suspend fun describeJobExecution(input: DescribeJobExecutionRequest): DescribeJobExecutionResponse {
        val op = SdkHttpOperation.build<DescribeJobExecutionRequest, DescribeJobExecutionResponse> {
            serializer = DescribeJobExecutionOperationSerializer()
            deserializer = DescribeJobExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJobExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a job template.
     */
    override suspend fun describeJobTemplate(input: DescribeJobTemplateRequest): DescribeJobTemplateResponse {
        val op = SdkHttpOperation.build<DescribeJobTemplateRequest, DescribeJobTemplateResponse> {
            serializer = DescribeJobTemplateOperationSerializer()
            deserializer = DescribeJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * View details of a managed job template.
     */
    override suspend fun describeManagedJobTemplate(input: DescribeManagedJobTemplateRequest): DescribeManagedJobTemplateResponse {
        val op = SdkHttpOperation.build<DescribeManagedJobTemplateRequest, DescribeManagedJobTemplateResponse> {
            serializer = DescribeManagedJobTemplateOperationSerializer()
            deserializer = DescribeManagedJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeManagedJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a mitigation action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeMitigationAction action.
     */
    override suspend fun describeMitigationAction(input: DescribeMitigationActionRequest): DescribeMitigationActionResponse {
        val op = SdkHttpOperation.build<DescribeMitigationActionRequest, DescribeMitigationActionResponse> {
            serializer = DescribeMitigationActionOperationSerializer()
            deserializer = DescribeMitigationActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMitigationAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplate action.
     */
    override suspend fun describeProvisioningTemplate(input: DescribeProvisioningTemplateRequest): DescribeProvisioningTemplateResponse {
        val op = SdkHttpOperation.build<DescribeProvisioningTemplateRequest, DescribeProvisioningTemplateResponse> {
            serializer = DescribeProvisioningTemplateOperationSerializer()
            deserializer = DescribeProvisioningTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProvisioningTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a fleet provisioning template version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplateVersion action.
     */
    override suspend fun describeProvisioningTemplateVersion(input: DescribeProvisioningTemplateVersionRequest): DescribeProvisioningTemplateVersionResponse {
        val op = SdkHttpOperation.build<DescribeProvisioningTemplateVersionRequest, DescribeProvisioningTemplateVersionResponse> {
            serializer = DescribeProvisioningTemplateVersionOperationSerializer()
            deserializer = DescribeProvisioningTemplateVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProvisioningTemplateVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeRoleAlias action.
     */
    override suspend fun describeRoleAlias(input: DescribeRoleAliasRequest): DescribeRoleAliasResponse {
        val op = SdkHttpOperation.build<DescribeRoleAliasRequest, DescribeRoleAliasResponse> {
            serializer = DescribeRoleAliasOperationSerializer()
            deserializer = DescribeRoleAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRoleAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a scheduled audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeScheduledAudit action.
     */
    override suspend fun describeScheduledAudit(input: DescribeScheduledAuditRequest): DescribeScheduledAuditResponse {
        val op = SdkHttpOperation.build<DescribeScheduledAuditRequest, DescribeScheduledAuditResponse> {
            serializer = DescribeScheduledAuditOperationSerializer()
            deserializer = DescribeScheduledAuditOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScheduledAudit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeSecurityProfile action.
     */
    override suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse {
        val op = SdkHttpOperation.build<DescribeSecurityProfileRequest, DescribeSecurityProfileResponse> {
            serializer = DescribeSecurityProfileOperationSerializer()
            deserializer = DescribeSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a stream.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeStream action.
     */
    override suspend fun describeStream(input: DescribeStreamRequest): DescribeStreamResponse {
        val op = SdkHttpOperation.build<DescribeStreamRequest, DescribeStreamResponse> {
            serializer = DescribeStreamOperationSerializer()
            deserializer = DescribeStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThing action.
     */
    override suspend fun describeThing(input: DescribeThingRequest): DescribeThingResponse {
        val op = SdkHttpOperation.build<DescribeThingRequest, DescribeThingResponse> {
            serializer = DescribeThingOperationSerializer()
            deserializer = DescribeThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingGroup action.
     */
    override suspend fun describeThingGroup(input: DescribeThingGroupRequest): DescribeThingGroupResponse {
        val op = SdkHttpOperation.build<DescribeThingGroupRequest, DescribeThingGroupResponse> {
            serializer = DescribeThingGroupOperationSerializer()
            deserializer = DescribeThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingRegistrationTask action.
     */
    override suspend fun describeThingRegistrationTask(input: DescribeThingRegistrationTaskRequest): DescribeThingRegistrationTaskResponse {
        val op = SdkHttpOperation.build<DescribeThingRegistrationTaskRequest, DescribeThingRegistrationTaskResponse> {
            serializer = DescribeThingRegistrationTaskOperationSerializer()
            deserializer = DescribeThingRegistrationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThingRegistrationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified thing type.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingType action.
     */
    override suspend fun describeThingType(input: DescribeThingTypeRequest): DescribeThingTypeResponse {
        val op = SdkHttpOperation.build<DescribeThingTypeRequest, DescribeThingTypeResponse> {
            serializer = DescribeThingTypeOperationSerializer()
            deserializer = DescribeThingTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThingType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a policy from the specified target.
     *
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after
     * a policy is detached before it's ready to be deleted.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPolicy action.
     */
    override suspend fun detachPolicy(input: DetachPolicyRequest): DetachPolicyResponse {
        val op = SdkHttpOperation.build<DetachPolicyRequest, DetachPolicyResponse> {
            serializer = DetachPolicyOperationSerializer()
            deserializer = DetachPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified policy from the specified certificate.
     *
     * This action is deprecated. Please use DetachPolicy instead.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPrincipalPolicy action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun detachPrincipalPolicy(input: DetachPrincipalPolicyRequest): DetachPrincipalPolicyResponse {
        val op = SdkHttpOperation.build<DetachPrincipalPolicyRequest, DetachPrincipalPolicyResponse> {
            serializer = DetachPrincipalPolicyOperationSerializer()
            deserializer = DetachPrincipalPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachPrincipalPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachSecurityProfile action.
     */
    override suspend fun detachSecurityProfile(input: DetachSecurityProfileRequest): DetachSecurityProfileResponse {
        val op = SdkHttpOperation.build<DetachSecurityProfileRequest, DetachSecurityProfileResponse> {
            serializer = DetachSecurityProfileOperationSerializer()
            deserializer = DetachSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the specified principal from the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     *
     * This call is asynchronous. It might take several seconds for the detachment to
     * propagate.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachThingPrincipal action.
     */
    override suspend fun detachThingPrincipal(input: DetachThingPrincipalRequest): DetachThingPrincipalResponse {
        val op = SdkHttpOperation.build<DetachThingPrincipalRequest, DetachThingPrincipalResponse> {
            serializer = DetachThingPrincipalOperationSerializer()
            deserializer = DetachThingPrincipalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachThingPrincipal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DisableTopicRule action.
     */
    override suspend fun disableTopicRule(input: DisableTopicRuleRequest): DisableTopicRuleResponse {
        val op = SdkHttpOperation.build<DisableTopicRuleRequest, DisableTopicRuleResponse> {
            serializer = DisableTopicRuleOperationSerializer()
            deserializer = DisableTopicRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableTopicRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">EnableTopicRule action.
     */
    override suspend fun enableTopicRule(input: EnableTopicRuleRequest): EnableTopicRuleResponse {
        val op = SdkHttpOperation.build<EnableTopicRuleRequest, EnableTopicRuleResponse> {
            serializer = EnableTopicRuleOperationSerializer()
            deserializer = EnableTopicRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableTopicRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBehaviorModelTrainingSummaries action.
     */
    override suspend fun getBehaviorModelTrainingSummaries(input: GetBehaviorModelTrainingSummariesRequest): GetBehaviorModelTrainingSummariesResponse {
        val op = SdkHttpOperation.build<GetBehaviorModelTrainingSummariesRequest, GetBehaviorModelTrainingSummariesResponse> {
            serializer = GetBehaviorModelTrainingSummariesOperationSerializer()
            deserializer = GetBehaviorModelTrainingSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBehaviorModelTrainingSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Aggregates on indexed data with search queries pertaining to particular fields.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBucketsAggregation action.
     */
    override suspend fun getBucketsAggregation(input: GetBucketsAggregationRequest): GetBucketsAggregationResponse {
        val op = SdkHttpOperation.build<GetBucketsAggregationRequest, GetBucketsAggregationResponse> {
            serializer = GetBucketsAggregationOperationSerializer()
            deserializer = GetBucketsAggregationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBucketsAggregation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the approximate count of unique values that match the query.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetCardinality action.
     */
    override suspend fun getCardinality(input: GetCardinalityRequest): GetCardinalityResponse {
        val op = SdkHttpOperation.build<GetCardinalityRequest, GetCardinalityResponse> {
            serializer = GetCardinalityOperationSerializer()
            deserializer = GetCardinalityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCardinality"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the policies that have an effect on the authorization behavior of the
     * specified device when it connects to the IoT device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetEffectivePolicies action.
     */
    override suspend fun getEffectivePolicies(input: GetEffectivePoliciesRequest): GetEffectivePoliciesResponse {
        val op = SdkHttpOperation.build<GetEffectivePoliciesRequest, GetEffectivePoliciesResponse> {
            serializer = GetEffectivePoliciesOperationSerializer()
            deserializer = GetEffectivePoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEffectivePolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the indexing configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetIndexingConfiguration action.
     */
    override suspend fun getIndexingConfiguration(input: GetIndexingConfigurationRequest): GetIndexingConfigurationResponse {
        val op = SdkHttpOperation.build<GetIndexingConfigurationRequest, GetIndexingConfigurationResponse> {
            serializer = GetIndexingConfigurationOperationSerializer()
            deserializer = GetIndexingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIndexingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a job document.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetJobDocument action.
     */
    override suspend fun getJobDocument(input: GetJobDocumentRequest): GetJobDocumentResponse {
        val op = SdkHttpOperation.build<GetJobDocumentRequest, GetJobDocumentResponse> {
            serializer = GetJobDocumentOperationSerializer()
            deserializer = GetJobDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJobDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the logging options.
     * NOTE: use of this command is not recommended. Use GetV2LoggingOptions
     * instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetLoggingOptions action.
     */
    override suspend fun getLoggingOptions(input: GetLoggingOptionsRequest): GetLoggingOptionsResponse {
        val op = SdkHttpOperation.build<GetLoggingOptionsRequest, GetLoggingOptionsResponse> {
            serializer = GetLoggingOptionsOperationSerializer()
            deserializer = GetLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an OTA update.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetOTAUpdate action.
     */
    override suspend fun getOtaUpdate(input: GetOtaUpdateRequest): GetOtaUpdateResponse {
        val op = SdkHttpOperation.build<GetOtaUpdateRequest, GetOtaUpdateResponse> {
            serializer = GetOTAUpdateOperationSerializer()
            deserializer = GetOTAUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOTAUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Groups the aggregated values that match the query into percentile groupings. The default
     * percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own
     * when you call GetPercentiles. This function returns a value for each
     * percentile group specified (or the default percentile groupings). The percentile group
     * "1" contains the aggregated field value that occurs in approximately one percent of the
     * values that match the query. The percentile group "5" contains the aggregated field value
     * that occurs in approximately five percent of the values that match the query, and so on.
     * The result is an approximation, the more values that match the query, the more accurate
     * the percentile values.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPercentiles action.
     */
    override suspend fun getPercentiles(input: GetPercentilesRequest): GetPercentilesResponse {
        val op = SdkHttpOperation.build<GetPercentilesRequest, GetPercentilesResponse> {
            serializer = GetPercentilesOperationSerializer()
            deserializer = GetPercentilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPercentiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified policy with the policy document of the default
     * version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicy action.
     */
    override suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse {
        val op = SdkHttpOperation.build<GetPolicyRequest, GetPolicyResponse> {
            serializer = GetPolicyOperationSerializer()
            deserializer = GetPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified policy version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicyVersion action.
     */
    override suspend fun getPolicyVersion(input: GetPolicyVersionRequest): GetPolicyVersionResponse {
        val op = SdkHttpOperation.build<GetPolicyVersionRequest, GetPolicyVersionResponse> {
            serializer = GetPolicyVersionOperationSerializer()
            deserializer = GetPolicyVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPolicyVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a registration code used to register a CA certificate with IoT.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetRegistrationCode action.
     */
    override suspend fun getRegistrationCode(input: GetRegistrationCodeRequest): GetRegistrationCodeResponse {
        val op = SdkHttpOperation.build<GetRegistrationCodeRequest, GetRegistrationCodeResponse> {
            serializer = GetRegistrationCodeOperationSerializer()
            deserializer = GetRegistrationCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRegistrationCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance,
     * and standard deviation for the specified aggregated field. If the aggregation field is of type
     * String, only the count statistic is returned.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetStatistics action.
     */
    override suspend fun getStatistics(input: GetStatisticsRequest): GetStatisticsResponse {
        val op = SdkHttpOperation.build<GetStatisticsRequest, GetStatisticsResponse> {
            serializer = GetStatisticsOperationSerializer()
            deserializer = GetStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRule action.
     */
    override suspend fun getTopicRule(input: GetTopicRuleRequest): GetTopicRuleResponse {
        val op = SdkHttpOperation.build<GetTopicRuleRequest, GetTopicRuleResponse> {
            serializer = GetTopicRuleOperationSerializer()
            deserializer = GetTopicRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTopicRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a topic rule destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRuleDestination action.
     */
    override suspend fun getTopicRuleDestination(input: GetTopicRuleDestinationRequest): GetTopicRuleDestinationResponse {
        val op = SdkHttpOperation.build<GetTopicRuleDestinationRequest, GetTopicRuleDestinationResponse> {
            serializer = GetTopicRuleDestinationOperationSerializer()
            deserializer = GetTopicRuleDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTopicRuleDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the fine grained logging options.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetV2LoggingOptions action.
     */
    override suspend fun getV2LoggingOptions(input: GetV2LoggingOptionsRequest): GetV2LoggingOptionsResponse {
        val op = SdkHttpOperation.build<GetV2LoggingOptionsRequest, GetV2LoggingOptionsResponse> {
            serializer = GetV2LoggingOptionsOperationSerializer()
            deserializer = GetV2LoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetV2LoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the active violations for a given Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListActiveViolations action.
     */
    override suspend fun listActiveViolations(input: ListActiveViolationsRequest): ListActiveViolationsResponse {
        val op = SdkHttpOperation.build<ListActiveViolationsRequest, ListActiveViolationsResponse> {
            serializer = ListActiveViolationsOperationSerializer()
            deserializer = ListActiveViolationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListActiveViolations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the policies attached to the specified thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAttachedPolicies action.
     */
    override suspend fun listAttachedPolicies(input: ListAttachedPoliciesRequest): ListAttachedPoliciesResponse {
        val op = SdkHttpOperation.build<ListAttachedPoliciesRequest, ListAttachedPoliciesResponse> {
            serializer = ListAttachedPoliciesOperationSerializer()
            deserializer = ListAttachedPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAttachedPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the findings (results) of a Device Defender audit or of the audits
     * performed during a specified time period. (Findings are retained for 90 days.)
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditFindings action.
     */
    override suspend fun listAuditFindings(input: ListAuditFindingsRequest): ListAuditFindingsResponse {
        val op = SdkHttpOperation.build<ListAuditFindingsRequest, ListAuditFindingsResponse> {
            serializer = ListAuditFindingsOperationSerializer()
            deserializer = ListAuditFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAuditFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of audit mitigation action tasks that were
     * executed.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsExecutions action.
     */
    override suspend fun listAuditMitigationActionsExecutions(input: ListAuditMitigationActionsExecutionsRequest): ListAuditMitigationActionsExecutionsResponse {
        val op = SdkHttpOperation.build<ListAuditMitigationActionsExecutionsRequest, ListAuditMitigationActionsExecutionsResponse> {
            serializer = ListAuditMitigationActionsExecutionsOperationSerializer()
            deserializer = ListAuditMitigationActionsExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAuditMitigationActionsExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsTasks action.
     */
    override suspend fun listAuditMitigationActionsTasks(input: ListAuditMitigationActionsTasksRequest): ListAuditMitigationActionsTasksResponse {
        val op = SdkHttpOperation.build<ListAuditMitigationActionsTasksRequest, ListAuditMitigationActionsTasksResponse> {
            serializer = ListAuditMitigationActionsTasksOperationSerializer()
            deserializer = ListAuditMitigationActionsTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAuditMitigationActionsTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your Device Defender audit listings.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditSuppressions action.
     */
    override suspend fun listAuditSuppressions(input: ListAuditSuppressionsRequest): ListAuditSuppressionsResponse {
        val op = SdkHttpOperation.build<ListAuditSuppressionsRequest, ListAuditSuppressionsResponse> {
            serializer = ListAuditSuppressionsOperationSerializer()
            deserializer = ListAuditSuppressionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAuditSuppressions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Device Defender audits that have been performed during a given
     * time period.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditTasks action.
     */
    override suspend fun listAuditTasks(input: ListAuditTasksRequest): ListAuditTasksResponse {
        val op = SdkHttpOperation.build<ListAuditTasksRequest, ListAuditTasksResponse> {
            serializer = ListAuditTasksOperationSerializer()
            deserializer = ListAuditTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAuditTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the authorizers registered in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuthorizers action.
     */
    override suspend fun listAuthorizers(input: ListAuthorizersRequest): ListAuthorizersResponse {
        val op = SdkHttpOperation.build<ListAuthorizersRequest, ListAuthorizersResponse> {
            serializer = ListAuthorizersOperationSerializer()
            deserializer = ListAuthorizersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAuthorizers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the billing groups you have created.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListBillingGroups action.
     */
    override suspend fun listBillingGroups(input: ListBillingGroupsRequest): ListBillingGroupsResponse {
        val op = SdkHttpOperation.build<ListBillingGroupsRequest, ListBillingGroupsResponse> {
            serializer = ListBillingGroupsOperationSerializer()
            deserializer = ListBillingGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBillingGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the CA certificates registered for your Amazon Web Services account.
     * The results are paginated with a default page size of 25. You can use the returned
     * marker to retrieve additional results.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCACertificates action.
     */
    override suspend fun listCaCertificates(input: ListCaCertificatesRequest): ListCaCertificatesResponse {
        val op = SdkHttpOperation.build<ListCaCertificatesRequest, ListCaCertificatesResponse> {
            serializer = ListCACertificatesOperationSerializer()
            deserializer = ListCACertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCACertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the certificates registered in your Amazon Web Services account.
     * The results are paginated with a default page size of 25. You can use the returned
     * marker to retrieve additional results.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificates action.
     */
    override suspend fun listCertificates(input: ListCertificatesRequest): ListCertificatesResponse {
        val op = SdkHttpOperation.build<ListCertificatesRequest, ListCertificatesResponse> {
            serializer = ListCertificatesOperationSerializer()
            deserializer = ListCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the device certificates signed by the specified CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificatesByCA action.
     */
    override suspend fun listCertificatesByCa(input: ListCertificatesByCaRequest): ListCertificatesByCaResponse {
        val op = SdkHttpOperation.build<ListCertificatesByCaRequest, ListCertificatesByCaResponse> {
            serializer = ListCertificatesByCAOperationSerializer()
            deserializer = ListCertificatesByCAOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCertificatesByCA"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your Device Defender detect custom metrics.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCustomMetrics action.
     */
    override suspend fun listCustomMetrics(input: ListCustomMetricsRequest): ListCustomMetricsResponse {
        val op = SdkHttpOperation.build<ListCustomMetricsRequest, ListCustomMetricsResponse> {
            serializer = ListCustomMetricsOperationSerializer()
            deserializer = ListCustomMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomMetrics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsExecutions action.
     */
    override suspend fun listDetectMitigationActionsExecutions(input: ListDetectMitigationActionsExecutionsRequest): ListDetectMitigationActionsExecutionsResponse {
        val op = SdkHttpOperation.build<ListDetectMitigationActionsExecutionsRequest, ListDetectMitigationActionsExecutionsResponse> {
            serializer = ListDetectMitigationActionsExecutionsOperationSerializer()
            deserializer = ListDetectMitigationActionsExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDetectMitigationActionsExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List of Device Defender ML Detect mitigation actions tasks.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsTasks action.
     */
    override suspend fun listDetectMitigationActionsTasks(input: ListDetectMitigationActionsTasksRequest): ListDetectMitigationActionsTasksResponse {
        val op = SdkHttpOperation.build<ListDetectMitigationActionsTasksRequest, ListDetectMitigationActionsTasksResponse> {
            serializer = ListDetectMitigationActionsTasksOperationSerializer()
            deserializer = ListDetectMitigationActionsTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDetectMitigationActionsTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDimensions action.
     */
    override suspend fun listDimensions(input: ListDimensionsRequest): ListDimensionsResponse {
        val op = SdkHttpOperation.build<ListDimensionsRequest, ListDimensionsResponse> {
            serializer = ListDimensionsOperationSerializer()
            deserializer = ListDimensionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDimensions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of domain configurations for the user. This list is sorted
     * alphabetically by domain configuration name.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDomainConfigurations action.
     */
    override suspend fun listDomainConfigurations(input: ListDomainConfigurationsRequest): ListDomainConfigurationsResponse {
        val op = SdkHttpOperation.build<ListDomainConfigurationsRequest, ListDomainConfigurationsResponse> {
            serializer = ListDomainConfigurationsOperationSerializer()
            deserializer = ListDomainConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all your fleet metrics.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListFleetMetrics action.
     */
    override suspend fun listFleetMetrics(input: ListFleetMetricsRequest): ListFleetMetricsResponse {
        val op = SdkHttpOperation.build<ListFleetMetricsRequest, ListFleetMetricsResponse> {
            serializer = ListFleetMetricsOperationSerializer()
            deserializer = ListFleetMetricsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFleetMetrics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the search indices.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListIndices action.
     */
    override suspend fun listIndices(input: ListIndicesRequest): ListIndicesResponse {
        val op = SdkHttpOperation.build<ListIndicesRequest, ListIndicesResponse> {
            serializer = ListIndicesOperationSerializer()
            deserializer = ListIndicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIndices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the job executions for a job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForJob action.
     */
    override suspend fun listJobExecutionsForJob(input: ListJobExecutionsForJobRequest): ListJobExecutionsForJobResponse {
        val op = SdkHttpOperation.build<ListJobExecutionsForJobRequest, ListJobExecutionsForJobResponse> {
            serializer = ListJobExecutionsForJobOperationSerializer()
            deserializer = ListJobExecutionsForJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobExecutionsForJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the job executions for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForThing action.
     */
    override suspend fun listJobExecutionsForThing(input: ListJobExecutionsForThingRequest): ListJobExecutionsForThingResponse {
        val op = SdkHttpOperation.build<ListJobExecutionsForThingRequest, ListJobExecutionsForThingResponse> {
            serializer = ListJobExecutionsForThingOperationSerializer()
            deserializer = ListJobExecutionsForThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobExecutionsForThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of job templates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobTemplates action.
     */
    override suspend fun listJobTemplates(input: ListJobTemplatesRequest): ListJobTemplatesResponse {
        val op = SdkHttpOperation.build<ListJobTemplatesRequest, ListJobTemplatesResponse> {
            serializer = ListJobTemplatesOperationSerializer()
            deserializer = ListJobTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists jobs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobs action.
     */
    override suspend fun listJobs(input: ListJobsRequest): ListJobsResponse {
        val op = SdkHttpOperation.build<ListJobsRequest, ListJobsResponse> {
            serializer = ListJobsOperationSerializer()
            deserializer = ListJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of managed job templates.
     */
    override suspend fun listManagedJobTemplates(input: ListManagedJobTemplatesRequest): ListManagedJobTemplatesResponse {
        val op = SdkHttpOperation.build<ListManagedJobTemplatesRequest, ListManagedJobTemplatesResponse> {
            serializer = ListManagedJobTemplatesOperationSerializer()
            deserializer = ListManagedJobTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListManagedJobTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side metric, or custom metric)
     * by the given thing during the specified time period.
     */
    override suspend fun listMetricValues(input: ListMetricValuesRequest): ListMetricValuesResponse {
        val op = SdkHttpOperation.build<ListMetricValuesRequest, ListMetricValuesResponse> {
            serializer = ListMetricValuesOperationSerializer()
            deserializer = ListMetricValuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMetricValues"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListMitigationActions action.
     */
    override suspend fun listMitigationActions(input: ListMitigationActionsRequest): ListMitigationActionsResponse {
        val op = SdkHttpOperation.build<ListMitigationActionsRequest, ListMitigationActionsResponse> {
            serializer = ListMitigationActionsOperationSerializer()
            deserializer = ListMitigationActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMitigationActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists OTA updates.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOTAUpdates action.
     */
    override suspend fun listOtaUpdates(input: ListOtaUpdatesRequest): ListOtaUpdatesResponse {
        val op = SdkHttpOperation.build<ListOtaUpdatesRequest, ListOtaUpdatesResponse> {
            serializer = ListOTAUpdatesOperationSerializer()
            deserializer = ListOTAUpdatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOTAUpdates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists certificates that are being transferred but not yet accepted.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOutgoingCertificates action.
     */
    override suspend fun listOutgoingCertificates(input: ListOutgoingCertificatesRequest): ListOutgoingCertificatesResponse {
        val op = SdkHttpOperation.build<ListOutgoingCertificatesRequest, ListOutgoingCertificatesResponse> {
            serializer = ListOutgoingCertificatesOperationSerializer()
            deserializer = ListOutgoingCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOutgoingCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your policies.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicies action.
     */
    override suspend fun listPolicies(input: ListPoliciesRequest): ListPoliciesResponse {
        val op = SdkHttpOperation.build<ListPoliciesRequest, ListPoliciesResponse> {
            serializer = ListPoliciesOperationSerializer()
            deserializer = ListPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the principals associated with the specified policy.
     *
     * Note: This action is deprecated. Please use ListTargetsForPolicy instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyPrincipals action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listPolicyPrincipals(input: ListPolicyPrincipalsRequest): ListPolicyPrincipalsResponse {
        val op = SdkHttpOperation.build<ListPolicyPrincipalsRequest, ListPolicyPrincipalsResponse> {
            serializer = ListPolicyPrincipalsOperationSerializer()
            deserializer = ListPolicyPrincipalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPolicyPrincipals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the versions of the specified policy and identifies the default
     * version.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyVersions action.
     */
    override suspend fun listPolicyVersions(input: ListPolicyVersionsRequest): ListPolicyVersionsResponse {
        val op = SdkHttpOperation.build<ListPolicyVersionsRequest, ListPolicyVersionsResponse> {
            serializer = ListPolicyVersionsOperationSerializer()
            deserializer = ListPolicyVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPolicyVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the policies attached to the specified principal. If you use an Cognito
     * identity, the ID must be in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax">AmazonCognito Identity format.
     *
     * Note: This action is deprecated. Please use ListAttachedPolicies instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalPolicies action.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listPrincipalPolicies(input: ListPrincipalPoliciesRequest): ListPrincipalPoliciesResponse {
        val op = SdkHttpOperation.build<ListPrincipalPoliciesRequest, ListPrincipalPoliciesResponse> {
            serializer = ListPrincipalPoliciesOperationSerializer()
            deserializer = ListPrincipalPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPrincipalPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the things associated with the specified principal. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalThings action.
     */
    override suspend fun listPrincipalThings(input: ListPrincipalThingsRequest): ListPrincipalThingsResponse {
        val op = SdkHttpOperation.build<ListPrincipalThingsRequest, ListPrincipalThingsResponse> {
            serializer = ListPrincipalThingsOperationSerializer()
            deserializer = ListPrincipalThingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPrincipalThings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of fleet provisioning template versions.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplateVersions action.
     */
    override suspend fun listProvisioningTemplateVersions(input: ListProvisioningTemplateVersionsRequest): ListProvisioningTemplateVersionsResponse {
        val op = SdkHttpOperation.build<ListProvisioningTemplateVersionsRequest, ListProvisioningTemplateVersionsResponse> {
            serializer = ListProvisioningTemplateVersionsOperationSerializer()
            deserializer = ListProvisioningTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProvisioningTemplateVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the fleet provisioning templates in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplates action.
     */
    override suspend fun listProvisioningTemplates(input: ListProvisioningTemplatesRequest): ListProvisioningTemplatesResponse {
        val op = SdkHttpOperation.build<ListProvisioningTemplatesRequest, ListProvisioningTemplatesResponse> {
            serializer = ListProvisioningTemplatesOperationSerializer()
            deserializer = ListProvisioningTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProvisioningTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the role aliases registered in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListRoleAliases action.
     */
    override suspend fun listRoleAliases(input: ListRoleAliasesRequest): ListRoleAliasesResponse {
        val op = SdkHttpOperation.build<ListRoleAliasesRequest, ListRoleAliasesResponse> {
            serializer = ListRoleAliasesOperationSerializer()
            deserializer = ListRoleAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRoleAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of your scheduled audits.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListScheduledAudits action.
     */
    override suspend fun listScheduledAudits(input: ListScheduledAuditsRequest): ListScheduledAuditsResponse {
        val op = SdkHttpOperation.build<ListScheduledAuditsRequest, ListScheduledAuditsResponse> {
            serializer = ListScheduledAuditsOperationSerializer()
            deserializer = ListScheduledAuditsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListScheduledAudits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Device Defender security profiles
     * you've
     * created. You can filter security profiles by dimension or custom metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfiles action.
     *
     *
     * dimensionName and metricName cannot be used in the same request.
     */
    override suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest): ListSecurityProfilesResponse {
        val op = SdkHttpOperation.build<ListSecurityProfilesRequest, ListSecurityProfilesResponse> {
            serializer = ListSecurityProfilesOperationSerializer()
            deserializer = ListSecurityProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSecurityProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Device Defender security profiles attached to a target (thing group).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfilesForTarget action.
     */
    override suspend fun listSecurityProfilesForTarget(input: ListSecurityProfilesForTargetRequest): ListSecurityProfilesForTargetResponse {
        val op = SdkHttpOperation.build<ListSecurityProfilesForTargetRequest, ListSecurityProfilesForTargetResponse> {
            serializer = ListSecurityProfilesForTargetOperationSerializer()
            deserializer = ListSecurityProfilesForTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSecurityProfilesForTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the streams in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListStreams action.
     */
    override suspend fun listStreams(input: ListStreamsRequest): ListStreamsResponse {
        val op = SdkHttpOperation.build<ListStreamsRequest, ListStreamsResponse> {
            serializer = ListStreamsOperationSerializer()
            deserializer = ListStreamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStreams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTagsForResource action.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List targets for the specified policy.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForPolicy action.
     */
    override suspend fun listTargetsForPolicy(input: ListTargetsForPolicyRequest): ListTargetsForPolicyResponse {
        val op = SdkHttpOperation.build<ListTargetsForPolicyRequest, ListTargetsForPolicyResponse> {
            serializer = ListTargetsForPolicyOperationSerializer()
            deserializer = ListTargetsForPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTargetsForPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForSecurityProfile action.
     */
    override suspend fun listTargetsForSecurityProfile(input: ListTargetsForSecurityProfileRequest): ListTargetsForSecurityProfileResponse {
        val op = SdkHttpOperation.build<ListTargetsForSecurityProfileRequest, ListTargetsForSecurityProfileResponse> {
            serializer = ListTargetsForSecurityProfileOperationSerializer()
            deserializer = ListTargetsForSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTargetsForSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the thing groups in your account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroups action.
     */
    override suspend fun listThingGroups(input: ListThingGroupsRequest): ListThingGroupsResponse {
        val op = SdkHttpOperation.build<ListThingGroupsRequest, ListThingGroupsResponse> {
            serializer = ListThingGroupsOperationSerializer()
            deserializer = ListThingGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the thing groups to which the specified thing belongs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroupsForThing action.
     */
    override suspend fun listThingGroupsForThing(input: ListThingGroupsForThingRequest): ListThingGroupsForThingResponse {
        val op = SdkHttpOperation.build<ListThingGroupsForThingRequest, ListThingGroupsForThingResponse> {
            serializer = ListThingGroupsForThingOperationSerializer()
            deserializer = ListThingGroupsForThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingGroupsForThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the principals associated with the specified thing. A principal can be X.509
     * certificates, IAM users, groups, and roles, Amazon Cognito identities or federated
     * identities.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingPrincipals action.
     */
    override suspend fun listThingPrincipals(input: ListThingPrincipalsRequest): ListThingPrincipalsResponse {
        val op = SdkHttpOperation.build<ListThingPrincipalsRequest, ListThingPrincipalsResponse> {
            serializer = ListThingPrincipalsOperationSerializer()
            deserializer = ListThingPrincipalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingPrincipals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Information about the thing registration tasks.
     */
    override suspend fun listThingRegistrationTaskReports(input: ListThingRegistrationTaskReportsRequest): ListThingRegistrationTaskReportsResponse {
        val op = SdkHttpOperation.build<ListThingRegistrationTaskReportsRequest, ListThingRegistrationTaskReportsResponse> {
            serializer = ListThingRegistrationTaskReportsOperationSerializer()
            deserializer = ListThingRegistrationTaskReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingRegistrationTaskReports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List bulk thing provisioning tasks.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingRegistrationTasks action.
     */
    override suspend fun listThingRegistrationTasks(input: ListThingRegistrationTasksRequest): ListThingRegistrationTasksResponse {
        val op = SdkHttpOperation.build<ListThingRegistrationTasksRequest, ListThingRegistrationTasksResponse> {
            serializer = ListThingRegistrationTasksOperationSerializer()
            deserializer = ListThingRegistrationTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingRegistrationTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the existing thing types.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingTypes action.
     */
    override suspend fun listThingTypes(input: ListThingTypesRequest): ListThingTypesResponse {
        val op = SdkHttpOperation.build<ListThingTypesRequest, ListThingTypesResponse> {
            serializer = ListThingTypesOperationSerializer()
            deserializer = ListThingTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your things. Use the attributeName and
     * attributeValue parameters to filter your things.
     * For example, calling ListThings with attributeName=Color and
     * attributeValue=Red retrieves all things in the registry that contain an attribute
     * Color with the value Red.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThings action.
     *
     *
     * You will not be charged for calling this API if an Access denied error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.
     */
    override suspend fun listThings(input: ListThingsRequest): ListThingsResponse {
        val op = SdkHttpOperation.build<ListThingsRequest, ListThingsResponse> {
            serializer = ListThingsOperationSerializer()
            deserializer = ListThingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the things you have added to the given billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInBillingGroup action.
     */
    override suspend fun listThingsInBillingGroup(input: ListThingsInBillingGroupRequest): ListThingsInBillingGroupResponse {
        val op = SdkHttpOperation.build<ListThingsInBillingGroupRequest, ListThingsInBillingGroupResponse> {
            serializer = ListThingsInBillingGroupOperationSerializer()
            deserializer = ListThingsInBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingsInBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the things in the specified group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInThingGroup action.
     */
    override suspend fun listThingsInThingGroup(input: ListThingsInThingGroupRequest): ListThingsInThingGroupResponse {
        val op = SdkHttpOperation.build<ListThingsInThingGroupRequest, ListThingsInThingGroupResponse> {
            serializer = ListThingsInThingGroupOperationSerializer()
            deserializer = ListThingsInThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThingsInThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the topic rule destinations in your Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRuleDestinations action.
     */
    override suspend fun listTopicRuleDestinations(input: ListTopicRuleDestinationsRequest): ListTopicRuleDestinationsResponse {
        val op = SdkHttpOperation.build<ListTopicRuleDestinationsRequest, ListTopicRuleDestinationsResponse> {
            serializer = ListTopicRuleDestinationsOperationSerializer()
            deserializer = ListTopicRuleDestinationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTopicRuleDestinations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the rules for the specific topic.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRules action.
     */
    override suspend fun listTopicRules(input: ListTopicRulesRequest): ListTopicRulesResponse {
        val op = SdkHttpOperation.build<ListTopicRulesRequest, ListTopicRulesResponse> {
            serializer = ListTopicRulesOperationSerializer()
            deserializer = ListTopicRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTopicRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists logging levels.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListV2LoggingLevels action.
     */
    override suspend fun listV2LoggingLevels(input: ListV2LoggingLevelsRequest): ListV2LoggingLevelsResponse {
        val op = SdkHttpOperation.build<ListV2LoggingLevelsRequest, ListV2LoggingLevelsResponse> {
            serializer = ListV2LoggingLevelsOperationSerializer()
            deserializer = ListV2LoggingLevelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListV2LoggingLevels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Device Defender security profile violations discovered during the given time period.
     * You can use filters to limit the results to those alerts issued for a particular security profile,
     * behavior, or thing (device).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListViolationEvents action.
     */
    override suspend fun listViolationEvents(input: ListViolationEventsRequest): ListViolationEventsResponse {
        val op = SdkHttpOperation.build<ListViolationEventsRequest, ListViolationEventsResponse> {
            serializer = ListViolationEventsOperationSerializer()
            deserializer = ListViolationEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListViolationEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Set a verification state and provide a description of that verification state on a violation (detect alarm).
     */
    override suspend fun putVerificationStateOnViolation(input: PutVerificationStateOnViolationRequest): PutVerificationStateOnViolationResponse {
        val op = SdkHttpOperation.build<PutVerificationStateOnViolationRequest, PutVerificationStateOnViolationResponse> {
            serializer = PutVerificationStateOnViolationOperationSerializer()
            deserializer = PutVerificationStateOnViolationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVerificationStateOnViolation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers a CA certificate with IoT. This CA certificate can then be used to sign
     * device certificates, which can be then registered with IoT. You can register up to 10
     * CA certificates per Amazon Web Services account that have the same subject field. This enables you to have
     * up to 10 certificate authorities sign your device certificates. If you have more than one
     * CA certificate registered, make sure you pass the CA certificate when you register your
     * device certificates with the RegisterCertificate action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCACertificate action.
     */
    override suspend fun registerCaCertificate(input: RegisterCaCertificateRequest): RegisterCaCertificateResponse {
        val op = SdkHttpOperation.build<RegisterCaCertificateRequest, RegisterCaCertificateResponse> {
            serializer = RegisterCACertificateOperationSerializer()
            deserializer = RegisterCACertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterCACertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers a device certificate with IoT. If you have more than one CA certificate
     * that has the same subject field, you must specify the CA certificate that was used to sign
     * the device certificate being registered.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCertificate action.
     */
    override suspend fun registerCertificate(input: RegisterCertificateRequest): RegisterCertificateResponse {
        val op = SdkHttpOperation.build<RegisterCertificateRequest, RegisterCertificateResponse> {
            serializer = RegisterCertificateOperationSerializer()
            deserializer = RegisterCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Register a certificate that does not have a certificate authority (CA).
     * For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT.
     */
    override suspend fun registerCertificateWithoutCa(input: RegisterCertificateWithoutCaRequest): RegisterCertificateWithoutCaResponse {
        val op = SdkHttpOperation.build<RegisterCertificateWithoutCaRequest, RegisterCertificateWithoutCaResponse> {
            serializer = RegisterCertificateWithoutCAOperationSerializer()
            deserializer = RegisterCertificateWithoutCAOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterCertificateWithoutCA"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a thing in the device registry. RegisterThing calls other IoT control
     * plane APIs. These calls might exceed your account level <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot">
     * IoT Throttling Limits and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Customer Support to raise
     * your throttling limits if necessary.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterThing action.
     */
    override suspend fun registerThing(input: RegisterThingRequest): RegisterThingResponse {
        val op = SdkHttpOperation.build<RegisterThingRequest, RegisterThingResponse> {
            serializer = RegisterThingOperationSerializer()
            deserializer = RegisterThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a pending certificate transfer. After IoT rejects a certificate transfer,
     * the certificate status changes from PENDING_TRANSFER to
     * INACTIVE.
     * To check for pending certificate transfers, call ListCertificates
     * to enumerate your certificates.
     * This operation can only be called by the transfer destination. After it is called,
     * the certificate will be returned to the source's account in the INACTIVE state.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RejectCertificateTransfer action.
     */
    override suspend fun rejectCertificateTransfer(input: RejectCertificateTransferRequest): RejectCertificateTransferResponse {
        val op = SdkHttpOperation.build<RejectCertificateTransferRequest, RejectCertificateTransferResponse> {
            serializer = RejectCertificateTransferOperationSerializer()
            deserializer = RejectCertificateTransferOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectCertificateTransfer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the given thing from the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RemoveThingFromBillingGroup action.
     *
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     */
    override suspend fun removeThingFromBillingGroup(input: RemoveThingFromBillingGroupRequest): RemoveThingFromBillingGroupResponse {
        val op = SdkHttpOperation.build<RemoveThingFromBillingGroupRequest, RemoveThingFromBillingGroupResponse> {
            serializer = RemoveThingFromBillingGroupOperationSerializer()
            deserializer = RemoveThingFromBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveThingFromBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove the specified thing from the specified group.
     * You must specify either a thingGroupArn or a
     * thingGroupName to identify the thing group and
     * either a thingArn or a thingName to
     * identify the thing to remove from the thing group.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RemoveThingFromThingGroup action.
     */
    override suspend fun removeThingFromThingGroup(input: RemoveThingFromThingGroupRequest): RemoveThingFromThingGroupResponse {
        val op = SdkHttpOperation.build<RemoveThingFromThingGroupRequest, RemoveThingFromThingGroupResponse> {
            serializer = RemoveThingFromThingGroupOperationSerializer()
            deserializer = RemoveThingFromThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveThingFromThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules
     * is an administrator-level action. Any user who has permission to create rules will be able
     * to access data processed by the rule.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ReplaceTopicRule action.
     */
    override suspend fun replaceTopicRule(input: ReplaceTopicRuleRequest): ReplaceTopicRuleResponse {
        val op = SdkHttpOperation.build<ReplaceTopicRuleRequest, ReplaceTopicRuleResponse> {
            serializer = ReplaceTopicRuleOperationSerializer()
            deserializer = ReplaceTopicRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReplaceTopicRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The query search index.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SearchIndex action.
     */
    override suspend fun searchIndex(input: SearchIndexRequest): SearchIndexResponse {
        val op = SdkHttpOperation.build<SearchIndexRequest, SearchIndexResponse> {
            serializer = SearchIndexOperationSerializer()
            deserializer = SearchIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the default authorizer. This will be used if a websocket connection is made
     * without specifying an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetDefaultAuthorizer action.
     */
    override suspend fun setDefaultAuthorizer(input: SetDefaultAuthorizerRequest): SetDefaultAuthorizerResponse {
        val op = SdkHttpOperation.build<SetDefaultAuthorizerRequest, SetDefaultAuthorizerResponse> {
            serializer = SetDefaultAuthorizerOperationSerializer()
            deserializer = SetDefaultAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetDefaultAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the specified version of the specified policy as the policy's default
     * (operative) version. This action affects all certificates to which the policy is attached.
     * To list the principals the policy is attached to, use the ListPrincipalPolicies
     * action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetDefaultPolicyVersion action.
     */
    override suspend fun setDefaultPolicyVersion(input: SetDefaultPolicyVersionRequest): SetDefaultPolicyVersionResponse {
        val op = SdkHttpOperation.build<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResponse> {
            serializer = SetDefaultPolicyVersionOperationSerializer()
            deserializer = SetDefaultPolicyVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetDefaultPolicyVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the logging options.
     * NOTE: use of this command is not recommended. Use SetV2LoggingOptions
     * instead.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetLoggingOptions action.
     */
    override suspend fun setLoggingOptions(input: SetLoggingOptionsRequest): SetLoggingOptionsResponse {
        val op = SdkHttpOperation.build<SetLoggingOptionsRequest, SetLoggingOptionsResponse> {
            serializer = SetLoggingOptionsOperationSerializer()
            deserializer = SetLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetLoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the logging level.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetV2LoggingLevel action.
     */
    override suspend fun setV2LoggingLevel(input: SetV2LoggingLevelRequest): SetV2LoggingLevelResponse {
        val op = SdkHttpOperation.build<SetV2LoggingLevelRequest, SetV2LoggingLevelResponse> {
            serializer = SetV2LoggingLevelOperationSerializer()
            deserializer = SetV2LoggingLevelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetV2LoggingLevel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the logging options for the V2 logging service.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SetV2LoggingOptions action.
     */
    override suspend fun setV2LoggingOptions(input: SetV2LoggingOptionsRequest): SetV2LoggingOptionsResponse {
        val op = SdkHttpOperation.build<SetV2LoggingOptionsRequest, SetV2LoggingOptionsResponse> {
            serializer = SetV2LoggingOptionsOperationSerializer()
            deserializer = SetV2LoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetV2LoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a task that applies a set of mitigation actions to the specified target.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartAuditMitigationActionsTask action.
     */
    override suspend fun startAuditMitigationActionsTask(input: StartAuditMitigationActionsTaskRequest): StartAuditMitigationActionsTaskResponse {
        val op = SdkHttpOperation.build<StartAuditMitigationActionsTaskRequest, StartAuditMitigationActionsTaskResponse> {
            serializer = StartAuditMitigationActionsTaskOperationSerializer()
            deserializer = StartAuditMitigationActionsTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartAuditMitigationActionsTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a Device Defender ML Detect mitigation actions task.
     *
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartDetectMitigationActionsTask action.
     */
    override suspend fun startDetectMitigationActionsTask(input: StartDetectMitigationActionsTaskRequest): StartDetectMitigationActionsTaskResponse {
        val op = SdkHttpOperation.build<StartDetectMitigationActionsTaskRequest, StartDetectMitigationActionsTaskResponse> {
            serializer = StartDetectMitigationActionsTaskOperationSerializer()
            deserializer = StartDetectMitigationActionsTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDetectMitigationActionsTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an on-demand Device Defender audit.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartOnDemandAuditTask action.
     */
    override suspend fun startOnDemandAuditTask(input: StartOnDemandAuditTaskRequest): StartOnDemandAuditTaskResponse {
        val op = SdkHttpOperation.build<StartOnDemandAuditTaskRequest, StartOnDemandAuditTaskResponse> {
            serializer = StartOnDemandAuditTaskOperationSerializer()
            deserializer = StartOnDemandAuditTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartOnDemandAuditTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartThingRegistrationTask action.
     */
    override suspend fun startThingRegistrationTask(input: StartThingRegistrationTaskRequest): StartThingRegistrationTaskResponse {
        val op = SdkHttpOperation.build<StartThingRegistrationTaskRequest, StartThingRegistrationTaskResponse> {
            serializer = StartThingRegistrationTaskOperationSerializer()
            deserializer = StartThingRegistrationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartThingRegistrationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a bulk thing provisioning task.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StopThingRegistrationTask action.
     */
    override suspend fun stopThingRegistrationTask(input: StopThingRegistrationTaskRequest): StopThingRegistrationTaskResponse {
        val op = SdkHttpOperation.build<StopThingRegistrationTaskRequest, StopThingRegistrationTaskResponse> {
            serializer = StopThingRegistrationTaskOperationSerializer()
            deserializer = StopThingRegistrationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopThingRegistrationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be
     * used to manage a resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TagResource action.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tests if a specified principal is authorized to perform an IoT action on a
     * specified resource. Use this to test and debug the authorization behavior of devices that
     * connect to the IoT device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TestAuthorization action.
     */
    override suspend fun testAuthorization(input: TestAuthorizationRequest): TestAuthorizationResponse {
        val op = SdkHttpOperation.build<TestAuthorizationRequest, TestAuthorizationResponse> {
            serializer = TestAuthorizationOperationSerializer()
            deserializer = TestAuthorizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestAuthorization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use
     * this to test and debug the custom authorization behavior of devices that connect to the IoT
     * device gateway.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TestInvokeAuthorizer action.
     */
    override suspend fun testInvokeAuthorizer(input: TestInvokeAuthorizerRequest): TestInvokeAuthorizerResponse {
        val op = SdkHttpOperation.build<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse> {
            serializer = TestInvokeAuthorizerOperationSerializer()
            deserializer = TestInvokeAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestInvokeAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Transfers the specified certificate to the specified Amazon Web Services account.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TransferCertificate action.
     *
     * You can cancel the transfer until it is acknowledged by the recipient.
     * No notification is sent to the transfer destination's account. It is up to the caller
     * to notify the transfer target.
     * The certificate being transferred must not be in the ACTIVE state. You can use the
     * UpdateCertificate action to deactivate it.
     * The certificate must not have any policies attached to it. You can use the
     * DetachPolicy action to detach them.
     */
    override suspend fun transferCertificate(input: TransferCertificateRequest): TransferCertificateResponse {
        val op = SdkHttpOperation.build<TransferCertificateRequest, TransferCertificateResponse> {
            serializer = TransferCertificateOperationSerializer()
            deserializer = TransferCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TransferCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the given tags (metadata) from the resource.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UntagResource action.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Configures or reconfigures the Device Defender audit settings for this account.
     * Settings include how audit notifications are sent and which audit checks are
     * enabled or disabled.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateAccountAuditConfiguration action.
     */
    override suspend fun updateAccountAuditConfiguration(input: UpdateAccountAuditConfigurationRequest): UpdateAccountAuditConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateAccountAuditConfigurationRequest, UpdateAccountAuditConfigurationResponse> {
            serializer = UpdateAccountAuditConfigurationOperationSerializer()
            deserializer = UpdateAccountAuditConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccountAuditConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Device Defender audit suppression.
     */
    override suspend fun updateAuditSuppression(input: UpdateAuditSuppressionRequest): UpdateAuditSuppressionResponse {
        val op = SdkHttpOperation.build<UpdateAuditSuppressionRequest, UpdateAuditSuppressionResponse> {
            serializer = UpdateAuditSuppressionOperationSerializer()
            deserializer = UpdateAuditSuppressionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAuditSuppression"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an authorizer.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateAuthorizer action.
     */
    override suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse {
        val op = SdkHttpOperation.build<UpdateAuthorizerRequest, UpdateAuthorizerResponse> {
            serializer = UpdateAuthorizerOperationSerializer()
            deserializer = UpdateAuthorizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAuthorizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates information about the billing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateBillingGroup action.
     */
    override suspend fun updateBillingGroup(input: UpdateBillingGroupRequest): UpdateBillingGroupResponse {
        val op = SdkHttpOperation.build<UpdateBillingGroupRequest, UpdateBillingGroupResponse> {
            serializer = UpdateBillingGroupOperationSerializer()
            deserializer = UpdateBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a registered CA certificate.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCACertificate action.
     */
    override suspend fun updateCaCertificate(input: UpdateCaCertificateRequest): UpdateCaCertificateResponse {
        val op = SdkHttpOperation.build<UpdateCaCertificateRequest, UpdateCaCertificateResponse> {
            serializer = UpdateCACertificateOperationSerializer()
            deserializer = UpdateCACertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCACertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of the specified certificate. This operation is
     * idempotent.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCertificate action.
     *
     * Certificates must be in the ACTIVE state to authenticate devices that use
     * a certificate to connect to IoT.
     * Within a few minutes of updating a certificate from the ACTIVE state to any other
     * state, IoT disconnects all devices that used that certificate to connect. Devices cannot
     * use a certificate that is not in the ACTIVE state to reconnect.
     */
    override suspend fun updateCertificate(input: UpdateCertificateRequest): UpdateCertificateResponse {
        val op = SdkHttpOperation.build<UpdateCertificateRequest, UpdateCertificateResponse> {
            serializer = UpdateCertificateOperationSerializer()
            deserializer = UpdateCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a
     * Device Defender detect custom metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateCustomMetric action.
     */
    override suspend fun updateCustomMetric(input: UpdateCustomMetricRequest): UpdateCustomMetricResponse {
        val op = SdkHttpOperation.build<UpdateCustomMetricRequest, UpdateCustomMetricResponse> {
            serializer = UpdateCustomMetricOperationSerializer()
            deserializer = UpdateCustomMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the definition for a dimension. You
     * cannot
     * change the type of a dimension after
     * it is created (you can delete it and
     * recreate
     * it).
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDimension action.
     */
    override suspend fun updateDimension(input: UpdateDimensionRequest): UpdateDimensionResponse {
        val op = SdkHttpOperation.build<UpdateDimensionRequest, UpdateDimensionResponse> {
            serializer = UpdateDimensionOperationSerializer()
            deserializer = UpdateDimensionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDimension"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates values stored in the domain configuration. Domain configurations for default
     * endpoints can't be updated.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDomainConfiguration action.
     */
    override suspend fun updateDomainConfiguration(input: UpdateDomainConfigurationRequest): UpdateDomainConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateDomainConfigurationRequest, UpdateDomainConfigurationResponse> {
            serializer = UpdateDomainConfigurationOperationSerializer()
            deserializer = UpdateDomainConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a dynamic thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateDynamicThingGroup action.
     */
    override suspend fun updateDynamicThingGroup(input: UpdateDynamicThingGroupRequest): UpdateDynamicThingGroupResponse {
        val op = SdkHttpOperation.build<UpdateDynamicThingGroupRequest, UpdateDynamicThingGroupResponse> {
            serializer = UpdateDynamicThingGroupOperationSerializer()
            deserializer = UpdateDynamicThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDynamicThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the event configurations.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateEventConfigurations action.
     */
    override suspend fun updateEventConfigurations(input: UpdateEventConfigurationsRequest): UpdateEventConfigurationsResponse {
        val op = SdkHttpOperation.build<UpdateEventConfigurationsRequest, UpdateEventConfigurationsResponse> {
            serializer = UpdateEventConfigurationsOperationSerializer()
            deserializer = UpdateEventConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEventConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the data for a fleet metric.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateFleetMetric action.
     */
    override suspend fun updateFleetMetric(input: UpdateFleetMetricRequest): UpdateFleetMetricResponse {
        val op = SdkHttpOperation.build<UpdateFleetMetricRequest, UpdateFleetMetricResponse> {
            serializer = UpdateFleetMetricOperationSerializer()
            deserializer = UpdateFleetMetricOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFleetMetric"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the search configuration.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateIndexingConfiguration action.
     */
    override suspend fun updateIndexingConfiguration(input: UpdateIndexingConfigurationRequest): UpdateIndexingConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateIndexingConfigurationRequest, UpdateIndexingConfigurationResponse> {
            serializer = UpdateIndexingConfigurationOperationSerializer()
            deserializer = UpdateIndexingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIndexingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates supported fields of the specified job.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateJob action.
     */
    override suspend fun updateJob(input: UpdateJobRequest): UpdateJobResponse {
        val op = SdkHttpOperation.build<UpdateJobRequest, UpdateJobResponse> {
            serializer = UpdateJobOperationSerializer()
            deserializer = UpdateJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the definition for the specified mitigation action.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateMitigationAction action.
     */
    override suspend fun updateMitigationAction(input: UpdateMitigationActionRequest): UpdateMitigationActionResponse {
        val op = SdkHttpOperation.build<UpdateMitigationActionRequest, UpdateMitigationActionResponse> {
            serializer = UpdateMitigationActionOperationSerializer()
            deserializer = UpdateMitigationActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMitigationAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a fleet provisioning template.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateProvisioningTemplate action.
     */
    override suspend fun updateProvisioningTemplate(input: UpdateProvisioningTemplateRequest): UpdateProvisioningTemplateResponse {
        val op = SdkHttpOperation.build<UpdateProvisioningTemplateRequest, UpdateProvisioningTemplateResponse> {
            serializer = UpdateProvisioningTemplateOperationSerializer()
            deserializer = UpdateProvisioningTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProvisioningTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a role alias.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateRoleAlias action.
     */
    override suspend fun updateRoleAlias(input: UpdateRoleAliasRequest): UpdateRoleAliasResponse {
        val op = SdkHttpOperation.build<UpdateRoleAliasRequest, UpdateRoleAliasResponse> {
            serializer = UpdateRoleAliasOperationSerializer()
            deserializer = UpdateRoleAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRoleAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a scheduled audit, including which checks are performed and
     * how often the audit takes place.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateScheduledAudit action.
     */
    override suspend fun updateScheduledAudit(input: UpdateScheduledAuditRequest): UpdateScheduledAuditResponse {
        val op = SdkHttpOperation.build<UpdateScheduledAuditRequest, UpdateScheduledAuditResponse> {
            serializer = UpdateScheduledAuditOperationSerializer()
            deserializer = UpdateScheduledAuditOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateScheduledAudit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Device Defender security profile.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateSecurityProfile action.
     */
    override suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse {
        val op = SdkHttpOperation.build<UpdateSecurityProfileRequest, UpdateSecurityProfileResponse> {
            serializer = UpdateSecurityProfileOperationSerializer()
            deserializer = UpdateSecurityProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSecurityProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing stream. The stream version will be incremented by one.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateStream action.
     */
    override suspend fun updateStream(input: UpdateStreamRequest): UpdateStreamResponse {
        val op = SdkHttpOperation.build<UpdateStreamRequest, UpdateStreamResponse> {
            serializer = UpdateStreamOperationSerializer()
            deserializer = UpdateStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the data for a thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThing action.
     */
    override suspend fun updateThing(input: UpdateThingRequest): UpdateThingResponse {
        val op = SdkHttpOperation.build<UpdateThingRequest, UpdateThingResponse> {
            serializer = UpdateThingOperationSerializer()
            deserializer = UpdateThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a thing group.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingGroup action.
     */
    override suspend fun updateThingGroup(input: UpdateThingGroupRequest): UpdateThingGroupResponse {
        val op = SdkHttpOperation.build<UpdateThingGroupRequest, UpdateThingGroupResponse> {
            serializer = UpdateThingGroupOperationSerializer()
            deserializer = UpdateThingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateThingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the groups to which the thing belongs.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingGroupsForThing action.
     */
    override suspend fun updateThingGroupsForThing(input: UpdateThingGroupsForThingRequest): UpdateThingGroupsForThingResponse {
        val op = SdkHttpOperation.build<UpdateThingGroupsForThingRequest, UpdateThingGroupsForThingResponse> {
            serializer = UpdateThingGroupsForThingOperationSerializer()
            deserializer = UpdateThingGroupsForThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateThingGroupsForThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or
     * confirmation URL of the destination.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateTopicRuleDestination action.
     */
    override suspend fun updateTopicRuleDestination(input: UpdateTopicRuleDestinationRequest): UpdateTopicRuleDestinationResponse {
        val op = SdkHttpOperation.build<UpdateTopicRuleDestinationRequest, UpdateTopicRuleDestinationResponse> {
            serializer = UpdateTopicRuleDestinationOperationSerializer()
            deserializer = UpdateTopicRuleDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTopicRuleDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Validates a Device Defender security profile behaviors specification.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ValidateSecurityProfileBehaviors action.
     */
    override suspend fun validateSecurityProfileBehaviors(input: ValidateSecurityProfileBehaviorsRequest): ValidateSecurityProfileBehaviorsResponse {
        val op = SdkHttpOperation.build<ValidateSecurityProfileBehaviorsRequest, ValidateSecurityProfileBehaviorsResponse> {
            serializer = ValidateSecurityProfileBehaviorsOperationSerializer()
            deserializer = ValidateSecurityProfileBehaviorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ValidateSecurityProfileBehaviors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "execute-api")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
