// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AbortConfig
import aws.sdk.kotlin.services.iot.model.CreateJobTemplateRequest
import aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig
import aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig
import aws.sdk.kotlin.services.iot.model.PresignedUrlConfig
import aws.sdk.kotlin.services.iot.model.Tag
import aws.sdk.kotlin.services.iot.model.TimeoutConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateJobTemplateOperationSerializer: HttpSerialize<CreateJobTemplateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateJobTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "job-templates",
                "${input.jobTemplateId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateJobTemplateOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateJobTemplateOperationBody(context: ExecutionContext, input: CreateJobTemplateRequest): ByteArray {
    val serializer = JsonSerializer()
    val ABORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("abortConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("document"))
    val DOCUMENTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("documentSource"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRetryConfig"))
    val JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobExecutionsRolloutConfig"))
    val PRESIGNEDURLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("presignedUrlConfig"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TIMEOUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timeoutConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABORTCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOCUMENT_DESCRIPTOR)
        field(DOCUMENTSOURCE_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR)
        field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR)
        field(PRESIGNEDURLCONFIG_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEOUTCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.abortConfig?.let { field(ABORTCONFIG_DESCRIPTOR, it, ::serializeAbortConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.document?.let { field(DOCUMENT_DESCRIPTOR, it) }
        input.documentSource?.let { field(DOCUMENTSOURCE_DESCRIPTOR, it) }
        input.jobArn?.let { field(JOBARN_DESCRIPTOR, it) }
        input.jobExecutionsRetryConfig?.let { field(JOBEXECUTIONSRETRYCONFIG_DESCRIPTOR, it, ::serializeJobExecutionsRetryConfigDocument) }
        input.jobExecutionsRolloutConfig?.let { field(JOBEXECUTIONSROLLOUTCONFIG_DESCRIPTOR, it, ::serializeJobExecutionsRolloutConfigDocument) }
        input.presignedUrlConfig?.let { field(PRESIGNEDURLCONFIG_DESCRIPTOR, it, ::serializePresignedUrlConfigDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.timeoutConfig?.let { field(TIMEOUTCONFIG_DESCRIPTOR, it, ::serializeTimeoutConfigDocument) }
    }
    return serializer.toByteArray()
}
