// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The input for the UpdateThing operation.
 */
class UpdateThingRequest private constructor(builder: Builder) {
    /**
     * A list of thing attributes, a JSON string containing name-value pairs. For
     * example:
     *
     * {\"attributes\":{\"name1\":\"value2\"}}
     *
     * This data is used to add new attributes or update existing attributes.
     */
    val attributePayload: aws.sdk.kotlin.services.iot.model.AttributePayload? = builder.attributePayload
    /**
     * The expected version of the thing record in the registry. If the version of the
     * record in the registry does not match the expected version specified in the request, the
     * UpdateThing request is rejected with a
     * VersionConflictException.
     */
    val expectedVersion: kotlin.Long? = builder.expectedVersion
    /**
     * Remove a thing type association. If true, the
     * association is removed.
     */
    val removeThingType: kotlin.Boolean = builder.removeThingType
    /**
     * The name of the thing to update.
     * You can't change a thing's name. To change a thing's name, you must create a
     * new thing, give it the new name, and then delete the old thing.
     */
    val thingName: kotlin.String? = builder.thingName
    /**
     * The name of the thing type.
     */
    val thingTypeName: kotlin.String? = builder.thingTypeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateThingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateThingRequest(")
        append("attributePayload=$attributePayload,")
        append("expectedVersion=$expectedVersion,")
        append("removeThingType=$removeThingType,")
        append("thingName=$thingName,")
        append("thingTypeName=$thingTypeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributePayload?.hashCode() ?: 0
        result = 31 * result + (expectedVersion?.hashCode() ?: 0)
        result = 31 * result + (removeThingType.hashCode())
        result = 31 * result + (thingName?.hashCode() ?: 0)
        result = 31 * result + (thingTypeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateThingRequest

        if (attributePayload != other.attributePayload) return false
        if (expectedVersion != other.expectedVersion) return false
        if (removeThingType != other.removeThingType) return false
        if (thingName != other.thingName) return false
        if (thingTypeName != other.thingTypeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateThingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of thing attributes, a JSON string containing name-value pairs. For
         * example:
         *
         * {\"attributes\":{\"name1\":\"value2\"}}
         *
         * This data is used to add new attributes or update existing attributes.
         */
        var attributePayload: aws.sdk.kotlin.services.iot.model.AttributePayload? = null
        /**
         * The expected version of the thing record in the registry. If the version of the
         * record in the registry does not match the expected version specified in the request, the
         * UpdateThing request is rejected with a
         * VersionConflictException.
         */
        var expectedVersion: kotlin.Long? = null
        /**
         * Remove a thing type association. If true, the
         * association is removed.
         */
        var removeThingType: kotlin.Boolean = false
        /**
         * The name of the thing to update.
         * You can't change a thing's name. To change a thing's name, you must create a
         * new thing, give it the new name, and then delete the old thing.
         */
        var thingName: kotlin.String? = null
        /**
         * The name of the thing type.
         */
        var thingTypeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateThingRequest) : this() {
            this.attributePayload = x.attributePayload
            this.expectedVersion = x.expectedVersion
            this.removeThingType = x.removeThingType
            this.thingName = x.thingName
            this.thingTypeName = x.thingTypeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateThingRequest = UpdateThingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AttributePayload] inside the given [block]
         */
        fun attributePayload(block: aws.sdk.kotlin.services.iot.model.AttributePayload.Builder.() -> kotlin.Unit) {
            this.attributePayload = aws.sdk.kotlin.services.iot.model.AttributePayload.invoke(block)
        }
    }
}
