// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class UpdateAuthorizerRequest private constructor(builder: Builder) {
    /**
     * The ARN of the authorizer's Lambda function.
     */
    val authorizerFunctionArn: kotlin.String? = builder.authorizerFunctionArn
    /**
     * The authorizer name.
     */
    val authorizerName: kotlin.String? = builder.authorizerName
    /**
     * When true, the result from the authorizer’s Lambda function is
     * cached for the time specified in refreshAfterInSeconds. The cached
     * result is used while the device reuses the same HTTP connection.
     */
    val enableCachingForHttp: kotlin.Boolean? = builder.enableCachingForHttp
    /**
     * The status of the update authorizer request.
     */
    val status: aws.sdk.kotlin.services.iot.model.AuthorizerStatus? = builder.status
    /**
     * The key used to extract the token from the HTTP headers.
     */
    val tokenKeyName: kotlin.String? = builder.tokenKeyName
    /**
     * The public keys used to verify the token signature.
     */
    val tokenSigningPublicKeys: Map<String, String>? = builder.tokenSigningPublicKeys

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateAuthorizerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAuthorizerRequest(")
        append("authorizerFunctionArn=$authorizerFunctionArn,")
        append("authorizerName=$authorizerName,")
        append("enableCachingForHttp=$enableCachingForHttp,")
        append("status=$status,")
        append("tokenKeyName=$tokenKeyName,")
        append("tokenSigningPublicKeys=$tokenSigningPublicKeys)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerFunctionArn?.hashCode() ?: 0
        result = 31 * result + (authorizerName?.hashCode() ?: 0)
        result = 31 * result + (enableCachingForHttp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tokenKeyName?.hashCode() ?: 0)
        result = 31 * result + (tokenSigningPublicKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAuthorizerRequest

        if (authorizerFunctionArn != other.authorizerFunctionArn) return false
        if (authorizerName != other.authorizerName) return false
        if (enableCachingForHttp != other.enableCachingForHttp) return false
        if (status != other.status) return false
        if (tokenKeyName != other.tokenKeyName) return false
        if (tokenSigningPublicKeys != other.tokenSigningPublicKeys) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateAuthorizerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the authorizer's Lambda function.
         */
        var authorizerFunctionArn: kotlin.String? = null
        /**
         * The authorizer name.
         */
        var authorizerName: kotlin.String? = null
        /**
         * When true, the result from the authorizer’s Lambda function is
         * cached for the time specified in refreshAfterInSeconds. The cached
         * result is used while the device reuses the same HTTP connection.
         */
        var enableCachingForHttp: kotlin.Boolean? = null
        /**
         * The status of the update authorizer request.
         */
        var status: aws.sdk.kotlin.services.iot.model.AuthorizerStatus? = null
        /**
         * The key used to extract the token from the HTTP headers.
         */
        var tokenKeyName: kotlin.String? = null
        /**
         * The public keys used to verify the token signature.
         */
        var tokenSigningPublicKeys: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateAuthorizerRequest) : this() {
            this.authorizerFunctionArn = x.authorizerFunctionArn
            this.authorizerName = x.authorizerName
            this.enableCachingForHttp = x.enableCachingForHttp
            this.status = x.status
            this.tokenKeyName = x.tokenKeyName
            this.tokenSigningPublicKeys = x.tokenSigningPublicKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateAuthorizerRequest = UpdateAuthorizerRequest(this)
    }
}
