// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Information that identifies the noncompliant resource.
 */
class ResourceIdentifier private constructor(builder: Builder) {
    /**
     * The account with which the resource is associated.
     */
    val account: kotlin.String? = builder.account
    /**
     * The ID of the CA certificate used to authorize the certificate.
     */
    val caCertificateId: kotlin.String? = builder.caCertificateId
    /**
     * The client ID.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * The ID of the Amazon Cognito identity pool.
     */
    val cognitoIdentityPoolId: kotlin.String? = builder.cognitoIdentityPoolId
    /**
     * The ID of the certificate attached to the resource.
     */
    val deviceCertificateId: kotlin.String? = builder.deviceCertificateId
    /**
     * The ARN of the IAM role that has overly permissive actions.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The version of the policy associated with the resource.
     */
    val policyVersionIdentifier: aws.sdk.kotlin.services.iot.model.PolicyVersionIdentifier? = builder.policyVersionIdentifier
    /**
     * The ARN of the role alias that has overly permissive actions.
     */
    val roleAliasArn: kotlin.String? = builder.roleAliasArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.ResourceIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceIdentifier(")
        append("account=$account,")
        append("caCertificateId=$caCertificateId,")
        append("clientId=$clientId,")
        append("cognitoIdentityPoolId=$cognitoIdentityPoolId,")
        append("deviceCertificateId=$deviceCertificateId,")
        append("iamRoleArn=$iamRoleArn,")
        append("policyVersionIdentifier=$policyVersionIdentifier,")
        append("roleAliasArn=$roleAliasArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (caCertificateId?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (cognitoIdentityPoolId?.hashCode() ?: 0)
        result = 31 * result + (deviceCertificateId?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (policyVersionIdentifier?.hashCode() ?: 0)
        result = 31 * result + (roleAliasArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceIdentifier

        if (account != other.account) return false
        if (caCertificateId != other.caCertificateId) return false
        if (clientId != other.clientId) return false
        if (cognitoIdentityPoolId != other.cognitoIdentityPoolId) return false
        if (deviceCertificateId != other.deviceCertificateId) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (policyVersionIdentifier != other.policyVersionIdentifier) return false
        if (roleAliasArn != other.roleAliasArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.ResourceIdentifier = Builder(this).apply(block).build()

    class Builder {
        /**
         * The account with which the resource is associated.
         */
        var account: kotlin.String? = null
        /**
         * The ID of the CA certificate used to authorize the certificate.
         */
        var caCertificateId: kotlin.String? = null
        /**
         * The client ID.
         */
        var clientId: kotlin.String? = null
        /**
         * The ID of the Amazon Cognito identity pool.
         */
        var cognitoIdentityPoolId: kotlin.String? = null
        /**
         * The ID of the certificate attached to the resource.
         */
        var deviceCertificateId: kotlin.String? = null
        /**
         * The ARN of the IAM role that has overly permissive actions.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * The version of the policy associated with the resource.
         */
        var policyVersionIdentifier: aws.sdk.kotlin.services.iot.model.PolicyVersionIdentifier? = null
        /**
         * The ARN of the role alias that has overly permissive actions.
         */
        var roleAliasArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.ResourceIdentifier) : this() {
            this.account = x.account
            this.caCertificateId = x.caCertificateId
            this.clientId = x.clientId
            this.cognitoIdentityPoolId = x.cognitoIdentityPoolId
            this.deviceCertificateId = x.deviceCertificateId
            this.iamRoleArn = x.iamRoleArn
            this.policyVersionIdentifier = x.policyVersionIdentifier
            this.roleAliasArn = x.roleAliasArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.ResourceIdentifier = ResourceIdentifier(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PolicyVersionIdentifier] inside the given [block]
         */
        fun policyVersionIdentifier(block: aws.sdk.kotlin.services.iot.model.PolicyVersionIdentifier.Builder.() -> kotlin.Unit) {
            this.policyVersionIdentifier = aws.sdk.kotlin.services.iot.model.PolicyVersionIdentifier.invoke(block)
        }
    }
}
