// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * The input to the RegisterCACertificate operation.
 */
class RegisterCaCertificateRequest private constructor(builder: Builder) {
    /**
     * Allows this CA certificate to be used for auto registration of device
     * certificates.
     */
    val allowAutoRegistration: kotlin.Boolean = builder.allowAutoRegistration
    /**
     * The CA certificate.
     */
    val caCertificate: kotlin.String? = builder.caCertificate
    /**
     * Information about the registration configuration.
     */
    val registrationConfig: aws.sdk.kotlin.services.iot.model.RegistrationConfig? = builder.registrationConfig
    /**
     * A boolean value that specifies if the CA certificate is set to active.
     */
    val setAsActive: kotlin.Boolean = builder.setAsActive
    /**
     * Metadata which can be used to manage the CA certificate.
     *
     * For URI Request parameters use format: ...key1=value1&key2=value2...
     * For the CLI command-line parameter use format: &&tags
     * "key1=value1&key2=value2..."
     * For the cli-input-json file use format: "tags":
     * "key1=value1&key2=value2..."
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The private key verification certificate.
     */
    val verificationCertificate: kotlin.String? = builder.verificationCertificate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterCaCertificateRequest(")
        append("allowAutoRegistration=$allowAutoRegistration,")
        append("caCertificate=$caCertificate,")
        append("registrationConfig=$registrationConfig,")
        append("setAsActive=$setAsActive,")
        append("tags=$tags,")
        append("verificationCertificate=$verificationCertificate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowAutoRegistration.hashCode()
        result = 31 * result + (caCertificate?.hashCode() ?: 0)
        result = 31 * result + (registrationConfig?.hashCode() ?: 0)
        result = 31 * result + (setAsActive.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (verificationCertificate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterCaCertificateRequest

        if (allowAutoRegistration != other.allowAutoRegistration) return false
        if (caCertificate != other.caCertificate) return false
        if (registrationConfig != other.registrationConfig) return false
        if (setAsActive != other.setAsActive) return false
        if (tags != other.tags) return false
        if (verificationCertificate != other.verificationCertificate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Allows this CA certificate to be used for auto registration of device
         * certificates.
         */
        var allowAutoRegistration: kotlin.Boolean = false
        /**
         * The CA certificate.
         */
        var caCertificate: kotlin.String? = null
        /**
         * Information about the registration configuration.
         */
        var registrationConfig: aws.sdk.kotlin.services.iot.model.RegistrationConfig? = null
        /**
         * A boolean value that specifies if the CA certificate is set to active.
         */
        var setAsActive: kotlin.Boolean = false
        /**
         * Metadata which can be used to manage the CA certificate.
         *
         * For URI Request parameters use format: ...key1=value1&key2=value2...
         * For the CLI command-line parameter use format: &&tags
         * "key1=value1&key2=value2..."
         * For the cli-input-json file use format: "tags":
         * "key1=value1&key2=value2..."
         */
        var tags: List<Tag>? = null
        /**
         * The private key verification certificate.
         */
        var verificationCertificate: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest) : this() {
            this.allowAutoRegistration = x.allowAutoRegistration
            this.caCertificate = x.caCertificate
            this.registrationConfig = x.registrationConfig
            this.setAsActive = x.setAsActive
            this.tags = x.tags
            this.verificationCertificate = x.verificationCertificate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.RegisterCaCertificateRequest = RegisterCaCertificateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.RegistrationConfig] inside the given [block]
         */
        fun registrationConfig(block: aws.sdk.kotlin.services.iot.model.RegistrationConfig.Builder.() -> kotlin.Unit) {
            this.registrationConfig = aws.sdk.kotlin.services.iot.model.RegistrationConfig.invoke(block)
        }
    }
}
