// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



/**
 * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
 */
class KafkaAction private constructor(builder: Builder) {
    /**
     * Properties of the Apache Kafka producer client.
     */
    val clientProperties: Map<String, String>? = builder.clientProperties
    /**
     * The ARN of Kafka action's VPC TopicRuleDestination.
     */
    val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The Kafka message key.
     */
    val key: kotlin.String? = builder.key
    /**
     * The Kafka message partition.
     */
    val partition: kotlin.String? = builder.partition
    /**
     * The Kafka topic for messages to be sent to the Kafka broker.
     */
    val topic: kotlin.String? = builder.topic

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.KafkaAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KafkaAction(")
        append("clientProperties=$clientProperties,")
        append("destinationArn=$destinationArn,")
        append("key=$key,")
        append("partition=$partition,")
        append("topic=$topic)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientProperties?.hashCode() ?: 0
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (partition?.hashCode() ?: 0)
        result = 31 * result + (topic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KafkaAction

        if (clientProperties != other.clientProperties) return false
        if (destinationArn != other.destinationArn) return false
        if (key != other.key) return false
        if (partition != other.partition) return false
        if (topic != other.topic) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.KafkaAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Properties of the Apache Kafka producer client.
         */
        var clientProperties: Map<String, String>? = null
        /**
         * The ARN of Kafka action's VPC TopicRuleDestination.
         */
        var destinationArn: kotlin.String? = null
        /**
         * The Kafka message key.
         */
        var key: kotlin.String? = null
        /**
         * The Kafka message partition.
         */
        var partition: kotlin.String? = null
        /**
         * The Kafka topic for messages to be sent to the Kafka broker.
         */
        var topic: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.KafkaAction) : this() {
            this.clientProperties = x.clientProperties
            this.destinationArn = x.destinationArn
            this.key = x.key
            this.partition = x.partition
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.KafkaAction = KafkaAction(this)
    }
}
