// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class DeleteJobRequest private constructor(builder: Builder) {
    /**
     * (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can
     * only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception
     * will occur. The default is false.
     *
     * Deleting a job which is "IN_PROGRESS", will cause a device which is executing
     * the job to be unable to access job information or update the job execution status.
     * Use caution and ensure that each device executing a job which is deleted is able to recover to
     * a valid state.
     */
    val force: kotlin.Boolean = builder.force
    /**
     * The ID of the job to be deleted.
     * After a job deletion is completed, you may reuse this jobId when you create a new job.
     * However, this is not recommended, and you must ensure that your devices are not using the
     * jobId to refer to the deleted job.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that
     * contain the value in the following format.
     *
     * $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/
     *
     *
     * The namespaceId feature is in public preview.
     */
    val namespaceId: kotlin.String? = builder.namespaceId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DeleteJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteJobRequest(")
        append("force=$force,")
        append("jobId=$jobId,")
        append("namespaceId=$namespaceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = force.hashCode()
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteJobRequest

        if (force != other.force) return false
        if (jobId != other.jobId) return false
        if (namespaceId != other.namespaceId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DeleteJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can
         * only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception
         * will occur. The default is false.
         *
         * Deleting a job which is "IN_PROGRESS", will cause a device which is executing
         * the job to be unable to access job information or update the job execution status.
         * Use caution and ensure that each device executing a job which is deleted is able to recover to
         * a valid state.
         */
        var force: kotlin.Boolean = false
        /**
         * The ID of the job to be deleted.
         * After a job deletion is completed, you may reuse this jobId when you create a new job.
         * However, this is not recommended, and you must ensure that your devices are not using the
         * jobId to refer to the deleted job.
         */
        var jobId: kotlin.String? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that
         * contain the value in the following format.
         *
         * $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/
         *
         *
         * The namespaceId feature is in public preview.
         */
        var namespaceId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DeleteJobRequest) : this() {
            this.force = x.force
            this.jobId = x.jobId
            this.namespaceId = x.namespaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DeleteJobRequest = DeleteJobRequest(this)
    }
}
