// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CreateJobRequest private constructor(builder: Builder) {
    /**
     * Allows you to create the criteria to abort a job.
     */
    val abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = builder.abortConfig
    /**
     * A short text description of the job.
     */
    val description: kotlin.String? = builder.description
    /**
     * The job document. Required if you don't specify a value for documentSource.
     */
    val document: kotlin.String? = builder.document
    /**
     * Parameters of a managed template that you can specify to create the job document.
     */
    val documentParameters: Map<String, String>? = builder.documentParameters
    /**
     * An S3 link to the job document. Required if you don't specify a value for document.
     *
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * The placeholder link is of the following form:
     *
     * ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}
     *
     * where bucket is your bucket name and key is the object in the bucket to which you are linking.
     */
    val documentSource: kotlin.String? = builder.documentSource
    /**
     * Allows you to create the criteria to retry a job.
     */
    val jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = builder.jobExecutionsRetryConfig
    /**
     * Allows you to create a staged rollout of the job.
     */
    val jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric
     * characters, "-" and "_" are valid for use here.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The ARN of the job template used to create the job.
     */
    val jobTemplateArn: kotlin.String? = builder.jobTemplateArn
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that
     * contain the value in the following format.
     *
     * $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/
     *
     *
     * The namespaceId feature is in public preview.
     */
    val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * Configuration information for pre-signed S3 URLs.
     */
    val presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = builder.presignedUrlConfig
    /**
     * Metadata which can be used to manage the job.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
     * specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
     * when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
     * target group, even after the job was completed by all things originally in the group.
     */
    val targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = builder.targetSelection
    /**
     * A list of things and thing groups to which the job should be sent.
     */
    val targets: List<String>? = builder.targets
    /**
     * Specifies the amount of time each device has to finish its execution of the job. The timer
     * is started when the job execution status is set to IN_PROGRESS. If the job
     * execution status is not set to another terminal state before the time expires, it will be
     * automatically set to TIMED_OUT.
     */
    val timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = builder.timeoutConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("abortConfig=$abortConfig,")
        append("description=$description,")
        append("document=$document,")
        append("documentParameters=$documentParameters,")
        append("documentSource=$documentSource,")
        append("jobExecutionsRetryConfig=$jobExecutionsRetryConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("jobId=$jobId,")
        append("jobTemplateArn=$jobTemplateArn,")
        append("namespaceId=$namespaceId,")
        append("presignedUrlConfig=$presignedUrlConfig,")
        append("tags=$tags,")
        append("targetSelection=$targetSelection,")
        append("targets=$targets,")
        append("timeoutConfig=$timeoutConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (document?.hashCode() ?: 0)
        result = 31 * result + (documentParameters?.hashCode() ?: 0)
        result = 31 * result + (documentSource?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRetryConfig?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobTemplateArn?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (presignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetSelection?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (abortConfig != other.abortConfig) return false
        if (description != other.description) return false
        if (document != other.document) return false
        if (documentParameters != other.documentParameters) return false
        if (documentSource != other.documentSource) return false
        if (jobExecutionsRetryConfig != other.jobExecutionsRetryConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (jobId != other.jobId) return false
        if (jobTemplateArn != other.jobTemplateArn) return false
        if (namespaceId != other.namespaceId) return false
        if (presignedUrlConfig != other.presignedUrlConfig) return false
        if (tags != other.tags) return false
        if (targetSelection != other.targetSelection) return false
        if (targets != other.targets) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Allows you to create the criteria to abort a job.
         */
        var abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = null
        /**
         * A short text description of the job.
         */
        var description: kotlin.String? = null
        /**
         * The job document. Required if you don't specify a value for documentSource.
         */
        var document: kotlin.String? = null
        /**
         * Parameters of a managed template that you can specify to create the job document.
         */
        var documentParameters: Map<String, String>? = null
        /**
         * An S3 link to the job document. Required if you don't specify a value for document.
         *
         * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
         * The placeholder link is of the following form:
         *
         * ${aws:iot:s3-presigned-url:https://s3.amazonaws.com/bucket/key}
         *
         * where bucket is your bucket name and key is the object in the bucket to which you are linking.
         */
        var documentSource: kotlin.String? = null
        /**
         * Allows you to create the criteria to retry a job.
         */
        var jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = null
        /**
         * Allows you to create a staged rollout of the job.
         */
        var jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = null
        /**
         * A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric
         * characters, "-" and "_" are valid for use here.
         */
        var jobId: kotlin.String? = null
        /**
         * The ARN of the job template used to create the job.
         */
        var jobTemplateArn: kotlin.String? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that
         * contain the value in the following format.
         *
         * $aws/things/THING_NAME/jobs/JOB_ID/notify-namespace-NAMESPACE_ID/
         *
         *
         * The namespaceId feature is in public preview.
         */
        var namespaceId: kotlin.String? = null
        /**
         * Configuration information for pre-signed S3 URLs.
         */
        var presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = null
        /**
         * Metadata which can be used to manage the job.
         */
        var tags: List<Tag>? = null
        /**
         * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
         * specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
         * when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
         * target group, even after the job was completed by all things originally in the group.
         */
        var targetSelection: aws.sdk.kotlin.services.iot.model.TargetSelection? = null
        /**
         * A list of things and thing groups to which the job should be sent.
         */
        var targets: List<String>? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job. The timer
         * is started when the job execution status is set to IN_PROGRESS. If the job
         * execution status is not set to another terminal state before the time expires, it will be
         * automatically set to TIMED_OUT.
         */
        var timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateJobRequest) : this() {
            this.abortConfig = x.abortConfig
            this.description = x.description
            this.document = x.document
            this.documentParameters = x.documentParameters
            this.documentSource = x.documentSource
            this.jobExecutionsRetryConfig = x.jobExecutionsRetryConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.jobId = x.jobId
            this.jobTemplateArn = x.jobTemplateArn
            this.namespaceId = x.namespaceId
            this.presignedUrlConfig = x.presignedUrlConfig
            this.tags = x.tags
            this.targetSelection = x.targetSelection
            this.targets = x.targets
            this.timeoutConfig = x.timeoutConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AbortConfig] inside the given [block]
         */
        fun abortConfig(block: aws.sdk.kotlin.services.iot.model.AbortConfig.Builder.() -> kotlin.Unit) {
            this.abortConfig = aws.sdk.kotlin.services.iot.model.AbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig] inside the given [block]
         */
        fun jobExecutionsRetryConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRetryConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig] inside the given [block]
         */
        fun jobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PresignedUrlConfig] inside the given [block]
         */
        fun presignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.presignedUrlConfig = aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimeoutConfig] inside the given [block]
         */
        fun timeoutConfig(block: aws.sdk.kotlin.services.iot.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iot.model.TimeoutConfig.invoke(block)
        }
    }
}
