// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model



class CreateDomainConfigurationRequest private constructor(builder: Builder) {
    /**
     * An object that specifies the authorization service for a domain.
     */
    val authorizerConfig: aws.sdk.kotlin.services.iot.model.AuthorizerConfig? = builder.authorizerConfig
    /**
     * The name of the domain configuration. This value must be unique to a region.
     */
    val domainConfigurationName: kotlin.String? = builder.domainConfigurationName
    /**
     * The name of the domain.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN.
     * This value is not required for Amazon Web Services-managed domains.
     */
    val serverCertificateArns: List<String>? = builder.serverCertificateArns
    /**
     * The type of service delivered by the endpoint.
     *
     * Amazon Web Services IoT Core currently supports only the DATA service type.
     */
    val serviceType: aws.sdk.kotlin.services.iot.model.ServiceType? = builder.serviceType
    /**
     * Metadata which can be used to manage the domain configuration.
     *
     * For URI Request parameters use format: ...key1=value1&key2=value2...
     * For the CLI command-line parameter use format: &&tags
     * "key1=value1&key2=value2..."
     * For the cli-input-json file use format: "tags":
     * "key1=value1&key2=value2..."
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority.
     * This value is not required for Amazon Web Services-managed domains.
     */
    val validationCertificateArn: kotlin.String? = builder.validationCertificateArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainConfigurationRequest(")
        append("authorizerConfig=$authorizerConfig,")
        append("domainConfigurationName=$domainConfigurationName,")
        append("domainName=$domainName,")
        append("serverCertificateArns=$serverCertificateArns,")
        append("serviceType=$serviceType,")
        append("tags=$tags,")
        append("validationCertificateArn=$validationCertificateArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerConfig?.hashCode() ?: 0
        result = 31 * result + (domainConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateArns?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (validationCertificateArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDomainConfigurationRequest

        if (authorizerConfig != other.authorizerConfig) return false
        if (domainConfigurationName != other.domainConfigurationName) return false
        if (domainName != other.domainName) return false
        if (serverCertificateArns != other.serverCertificateArns) return false
        if (serviceType != other.serviceType) return false
        if (tags != other.tags) return false
        if (validationCertificateArn != other.validationCertificateArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An object that specifies the authorization service for a domain.
         */
        var authorizerConfig: aws.sdk.kotlin.services.iot.model.AuthorizerConfig? = null
        /**
         * The name of the domain configuration. This value must be unique to a region.
         */
        var domainConfigurationName: kotlin.String? = null
        /**
         * The name of the domain.
         */
        var domainName: kotlin.String? = null
        /**
         * The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN.
         * This value is not required for Amazon Web Services-managed domains.
         */
        var serverCertificateArns: List<String>? = null
        /**
         * The type of service delivered by the endpoint.
         *
         * Amazon Web Services IoT Core currently supports only the DATA service type.
         */
        var serviceType: aws.sdk.kotlin.services.iot.model.ServiceType? = null
        /**
         * Metadata which can be used to manage the domain configuration.
         *
         * For URI Request parameters use format: ...key1=value1&key2=value2...
         * For the CLI command-line parameter use format: &&tags
         * "key1=value1&key2=value2..."
         * For the cli-input-json file use format: "tags":
         * "key1=value1&key2=value2..."
         */
        var tags: List<Tag>? = null
        /**
         * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority.
         * This value is not required for Amazon Web Services-managed domains.
         */
        var validationCertificateArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest) : this() {
            this.authorizerConfig = x.authorizerConfig
            this.domainConfigurationName = x.domainConfigurationName
            this.domainName = x.domainName
            this.serverCertificateArns = x.serverCertificateArns
            this.serviceType = x.serviceType
            this.tags = x.tags
            this.validationCertificateArn = x.validationCertificateArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest = CreateDomainConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AuthorizerConfig] inside the given [block]
         */
        fun authorizerConfig(block: aws.sdk.kotlin.services.iot.model.AuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.authorizerConfig = aws.sdk.kotlin.services.iot.model.AuthorizerConfig.invoke(block)
        }
    }
}
