// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The authorizer description.
 */
class AuthorizerDescription private constructor(builder: Builder) {
    /**
     * The authorizer ARN.
     */
    val authorizerArn: kotlin.String? = builder.authorizerArn
    /**
     * The authorizer's Lambda function ARN.
     */
    val authorizerFunctionArn: kotlin.String? = builder.authorizerFunctionArn
    /**
     * The authorizer name.
     */
    val authorizerName: kotlin.String? = builder.authorizerName
    /**
     * The UNIX timestamp of when the authorizer was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * When true, the result from the authorizer’s Lambda function is
     * cached for the time specified in refreshAfterInSeconds. The cached
     * result is used while the device reuses the same HTTP connection.
     */
    val enableCachingForHttp: kotlin.Boolean? = builder.enableCachingForHttp
    /**
     * The UNIX timestamp of when the authorizer was last updated.
     */
    val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * Specifies whether IoT validates the token signature in an authorization request.
     */
    val signingDisabled: kotlin.Boolean? = builder.signingDisabled
    /**
     * The status of the authorizer.
     */
    val status: aws.sdk.kotlin.services.iot.model.AuthorizerStatus? = builder.status
    /**
     * The key used to extract the token from the HTTP headers.
     */
    val tokenKeyName: kotlin.String? = builder.tokenKeyName
    /**
     * The public keys used to validate the token signature returned by your custom
     * authentication service.
     */
    val tokenSigningPublicKeys: Map<String, String>? = builder.tokenSigningPublicKeys

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AuthorizerDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizerDescription(")
        append("authorizerArn=$authorizerArn,")
        append("authorizerFunctionArn=$authorizerFunctionArn,")
        append("authorizerName=$authorizerName,")
        append("creationDate=$creationDate,")
        append("enableCachingForHttp=$enableCachingForHttp,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("signingDisabled=$signingDisabled,")
        append("status=$status,")
        append("tokenKeyName=$tokenKeyName,")
        append("tokenSigningPublicKeys=$tokenSigningPublicKeys)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerArn?.hashCode() ?: 0
        result = 31 * result + (authorizerFunctionArn?.hashCode() ?: 0)
        result = 31 * result + (authorizerName?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (enableCachingForHttp?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (signingDisabled?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tokenKeyName?.hashCode() ?: 0)
        result = 31 * result + (tokenSigningPublicKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthorizerDescription

        if (authorizerArn != other.authorizerArn) return false
        if (authorizerFunctionArn != other.authorizerFunctionArn) return false
        if (authorizerName != other.authorizerName) return false
        if (creationDate != other.creationDate) return false
        if (enableCachingForHttp != other.enableCachingForHttp) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (signingDisabled != other.signingDisabled) return false
        if (status != other.status) return false
        if (tokenKeyName != other.tokenKeyName) return false
        if (tokenSigningPublicKeys != other.tokenSigningPublicKeys) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AuthorizerDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The authorizer ARN.
         */
        var authorizerArn: kotlin.String? = null
        /**
         * The authorizer's Lambda function ARN.
         */
        var authorizerFunctionArn: kotlin.String? = null
        /**
         * The authorizer name.
         */
        var authorizerName: kotlin.String? = null
        /**
         * The UNIX timestamp of when the authorizer was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When true, the result from the authorizer’s Lambda function is
         * cached for the time specified in refreshAfterInSeconds. The cached
         * result is used while the device reuses the same HTTP connection.
         */
        var enableCachingForHttp: kotlin.Boolean? = null
        /**
         * The UNIX timestamp of when the authorizer was last updated.
         */
        var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether IoT validates the token signature in an authorization request.
         */
        var signingDisabled: kotlin.Boolean? = null
        /**
         * The status of the authorizer.
         */
        var status: aws.sdk.kotlin.services.iot.model.AuthorizerStatus? = null
        /**
         * The key used to extract the token from the HTTP headers.
         */
        var tokenKeyName: kotlin.String? = null
        /**
         * The public keys used to validate the token signature returned by your custom
         * authentication service.
         */
        var tokenSigningPublicKeys: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AuthorizerDescription) : this() {
            this.authorizerArn = x.authorizerArn
            this.authorizerFunctionArn = x.authorizerFunctionArn
            this.authorizerName = x.authorizerName
            this.creationDate = x.creationDate
            this.enableCachingForHttp = x.enableCachingForHttp
            this.lastModifiedDate = x.lastModifiedDate
            this.signingDisabled = x.signingDisabled
            this.status = x.status
            this.tokenKeyName = x.tokenKeyName
            this.tokenSigningPublicKeys = x.tokenSigningPublicKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AuthorizerDescription = AuthorizerDescription(this)
    }
}
