// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.GetPackageVersionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.PackageVersionArtifact
import aws.sdk.kotlin.services.iot.model.PackageVersionStatus
import aws.sdk.kotlin.services.iot.model.Sbom
import aws.sdk.kotlin.services.iot.model.SbomValidationStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetPackageVersionOperationDeserializer: HttpDeserializer.NonStreaming<GetPackageVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPackageVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPackageVersionError(context, call, payload)
        }
        val builder = GetPackageVersionResponse.Builder()

        if (payload != null) {
            deserializeGetPackageVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPackageVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPackageVersionOperationBody(builder: GetPackageVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARTIFACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("artifact"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("attributes"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ERRORREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorReason"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val PACKAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packageName"))
    val PACKAGEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("packageVersionArn"))
    val RECIPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("recipe"))
    val SBOM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sbom"))
    val SBOMVALIDATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("sbomValidationStatus"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val VERSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("versionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACT_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ERRORREASON_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(PACKAGENAME_DESCRIPTOR)
        field(PACKAGEVERSIONARN_DESCRIPTOR)
        field(RECIPE_DESCRIPTOR)
        field(SBOM_DESCRIPTOR)
        field(SBOMVALIDATIONSTATUS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VERSIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARTIFACT_DESCRIPTOR.index -> builder.artifact = deserializePackageVersionArtifactDocument(deserializer)
                ATTRIBUTES_DESCRIPTOR.index -> builder.attributes =
                    deserializer.deserializeMap(ATTRIBUTES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ERRORREASON_DESCRIPTOR.index -> builder.errorReason = deserializeString()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PACKAGENAME_DESCRIPTOR.index -> builder.packageName = deserializeString()
                PACKAGEVERSIONARN_DESCRIPTOR.index -> builder.packageVersionArn = deserializeString()
                RECIPE_DESCRIPTOR.index -> builder.recipe = deserializeString()
                SBOM_DESCRIPTOR.index -> builder.sbom = deserializeSbomDocument(deserializer)
                SBOMVALIDATIONSTATUS_DESCRIPTOR.index -> builder.sbomValidationStatus = deserializeString().let { SbomValidationStatus.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { PackageVersionStatus.fromValue(it) }
                VERSIONNAME_DESCRIPTOR.index -> builder.versionName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
