// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AttributePayload
import aws.sdk.kotlin.services.iot.model.CreateThingRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateThingOperationSerializer: HttpSerializer.NonStreaming<CreateThingRequest> {
    override fun serialize(context: ExecutionContext, input: CreateThingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.thingName) { "thingName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("things"))
                add(PercentEncoding.SmithyLabel.encode(input.thingName))
            }
        }

        val payload = serializeCreateThingOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateThingOperationBody(context: ExecutionContext, input: CreateThingRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTEPAYLOAD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("attributePayload"))
    val BILLINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("billingGroupName"))
    val THINGTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingTypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEPAYLOAD_DESCRIPTOR)
        field(BILLINGGROUPNAME_DESCRIPTOR)
        field(THINGTYPENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributePayload?.let { field(ATTRIBUTEPAYLOAD_DESCRIPTOR, it, ::serializeAttributePayloadDocument) }
        input.billingGroupName?.let { field(BILLINGGROUPNAME_DESCRIPTOR, it) }
        input.thingTypeName?.let { field(THINGTYPENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
