// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration information for a virtual private cloud (VPC) destination.
 */
public class VpcDestinationConfiguration private constructor(builder: Builder) {
    /**
     * The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The security groups of the VPC destination.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The subnet IDs of the VPC destination.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * The ID of the VPC.
     */
    public val vpcId: kotlin.String = requireNotNull(builder.vpcId) { "A non-null value must be provided for vpcId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.VpcDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcDestinationConfiguration(")
        append("roleArn=$roleArn,")
        append("securityGroups=$securityGroups,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn.hashCode()
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (vpcId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcDestinationConfiguration

        if (roleArn != other.roleArn) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.VpcDestinationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The security groups of the VPC destination.
         */
        public var securityGroups: List<String>? = null
        /**
         * The subnet IDs of the VPC destination.
         */
        public var subnetIds: List<String>? = null
        /**
         * The ID of the VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.VpcDestinationConfiguration) : this() {
            this.roleArn = x.roleArn
            this.securityGroups = x.securityGroups
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.VpcDestinationConfiguration = VpcDestinationConfiguration(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcId == null) vpcId = ""
            return this
        }
    }
}
