// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateJobRequest private constructor(builder: Builder) {
    /**
     * Allows you to create criteria to abort a job.
     */
    public val abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = builder.abortConfig
    /**
     * A short text description of the job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Allows you to create the criteria to retry a job.
     */
    public val jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = builder.jobExecutionsRetryConfig
    /**
     * Allows you to create a staged rollout of the job.
     */
    public val jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = builder.jobExecutionsRolloutConfig
    /**
     * The ID of the job to be updated.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The namespace used to indicate that a job is a customer-managed job.
     *
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
     *
     * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
     *
     * The `namespaceId` feature is only supported by IoT Greengrass at this time. For more information, see [Setting up IoT Greengrass core devices.](https://docs.aws.amazon.com/greengrass/v2/developerguide/setting-up.html)
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * Configuration information for pre-signed S3 URLs.
     */
    public val presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = builder.presignedUrlConfig
    /**
     * Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to `TIMED_OUT`.
     */
    public val timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = builder.timeoutConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateJobRequest(")
        append("abortConfig=$abortConfig,")
        append("description=$description,")
        append("jobExecutionsRetryConfig=$jobExecutionsRetryConfig,")
        append("jobExecutionsRolloutConfig=$jobExecutionsRolloutConfig,")
        append("jobId=$jobId,")
        append("namespaceId=$namespaceId,")
        append("presignedUrlConfig=$presignedUrlConfig,")
        append("timeoutConfig=$timeoutConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortConfig?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRetryConfig?.hashCode() ?: 0)
        result = 31 * result + (jobExecutionsRolloutConfig?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (presignedUrlConfig?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateJobRequest

        if (abortConfig != other.abortConfig) return false
        if (description != other.description) return false
        if (jobExecutionsRetryConfig != other.jobExecutionsRetryConfig) return false
        if (jobExecutionsRolloutConfig != other.jobExecutionsRolloutConfig) return false
        if (jobId != other.jobId) return false
        if (namespaceId != other.namespaceId) return false
        if (presignedUrlConfig != other.presignedUrlConfig) return false
        if (timeoutConfig != other.timeoutConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Allows you to create criteria to abort a job.
         */
        public var abortConfig: aws.sdk.kotlin.services.iot.model.AbortConfig? = null
        /**
         * A short text description of the job.
         */
        public var description: kotlin.String? = null
        /**
         * Allows you to create the criteria to retry a job.
         */
        public var jobExecutionsRetryConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig? = null
        /**
         * Allows you to create a staged rollout of the job.
         */
        public var jobExecutionsRolloutConfig: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig? = null
        /**
         * The ID of the job to be updated.
         */
        public var jobId: kotlin.String? = null
        /**
         * The namespace used to indicate that a job is a customer-managed job.
         *
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.
         *
         * `$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/`
         *
         * The `namespaceId` feature is only supported by IoT Greengrass at this time. For more information, see [Setting up IoT Greengrass core devices.](https://docs.aws.amazon.com/greengrass/v2/developerguide/setting-up.html)
         */
        public var namespaceId: kotlin.String? = null
        /**
         * Configuration information for pre-signed S3 URLs.
         */
        public var presignedUrlConfig: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig? = null
        /**
         * Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to `IN_PROGRESS`. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to `TIMED_OUT`.
         */
        public var timeoutConfig: aws.sdk.kotlin.services.iot.model.TimeoutConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateJobRequest) : this() {
            this.abortConfig = x.abortConfig
            this.description = x.description
            this.jobExecutionsRetryConfig = x.jobExecutionsRetryConfig
            this.jobExecutionsRolloutConfig = x.jobExecutionsRolloutConfig
            this.jobId = x.jobId
            this.namespaceId = x.namespaceId
            this.presignedUrlConfig = x.presignedUrlConfig
            this.timeoutConfig = x.timeoutConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateJobRequest = UpdateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AbortConfig] inside the given [block]
         */
        public fun abortConfig(block: aws.sdk.kotlin.services.iot.model.AbortConfig.Builder.() -> kotlin.Unit) {
            this.abortConfig = aws.sdk.kotlin.services.iot.model.AbortConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig] inside the given [block]
         */
        public fun jobExecutionsRetryConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRetryConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRetryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig] inside the given [block]
         */
        public fun jobExecutionsRolloutConfig(block: aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.Builder.() -> kotlin.Unit) {
            this.jobExecutionsRolloutConfig = aws.sdk.kotlin.services.iot.model.JobExecutionsRolloutConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.PresignedUrlConfig] inside the given [block]
         */
        public fun presignedUrlConfig(block: aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.Builder.() -> kotlin.Unit) {
            this.presignedUrlConfig = aws.sdk.kotlin.services.iot.model.PresignedUrlConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TimeoutConfig] inside the given [block]
         */
        public fun timeoutConfig(block: aws.sdk.kotlin.services.iot.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iot.model.TimeoutConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
