// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateDomainConfigurationRequest private constructor(builder: Builder) {
    /**
     * An enumerated string that speciﬁes the application-layer protocol.
     * + `SECURE_MQTT` - MQTT over TLS.
     *
     * + `MQTT_WSS` - MQTT over WebSocket.
     *
     * + `HTTPS` - HTTP over TLS.
     *
     * + `DEFAULT` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify application_layer protocol. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
     */
    public val applicationProtocol: aws.sdk.kotlin.services.iot.model.ApplicationProtocol? = builder.applicationProtocol
    /**
     * An enumerated string that speciﬁes the authentication type.
     * + `CUSTOM_AUTH_X509` - Use custom authentication and authorization with additional details from the X.509 client certificate.
     *
     * + `CUSTOM_AUTH` - Use custom authentication and authorization. For more information, see [Custom authentication and authorization](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
     *
     * + `AWS_X509` - Use X.509 client certificates without custom authentication and authorization. For more information, see [X.509 client certificates](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html).
     *
     * + `AWS_SIGV4` - Use Amazon Web Services Signature Version 4. For more information, see [IAM users, groups, and roles](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
     *
     * + `DEFAULT ` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify authentication type. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
     */
    public val authenticationType: aws.sdk.kotlin.services.iot.model.AuthenticationType? = builder.authenticationType
    /**
     * An object that specifies the authorization service for a domain.
     */
    public val authorizerConfig: aws.sdk.kotlin.services.iot.model.AuthorizerConfig? = builder.authorizerConfig
    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    public val clientCertificateConfig: aws.sdk.kotlin.services.iot.model.ClientCertificateConfig? = builder.clientCertificateConfig
    /**
     * The name of the domain configuration to be updated.
     */
    public val domainConfigurationName: kotlin.String? = builder.domainConfigurationName
    /**
     * The status to which the domain configuration should be updated.
     */
    public val domainConfigurationStatus: aws.sdk.kotlin.services.iot.model.DomainConfigurationStatus? = builder.domainConfigurationStatus
    /**
     * Removes the authorization configuration from a domain.
     */
    public val removeAuthorizerConfig: kotlin.Boolean? = builder.removeAuthorizerConfig
    /**
     * The server certificate configuration.
     */
    public val serverCertificateConfig: aws.sdk.kotlin.services.iot.model.ServerCertificateConfig? = builder.serverCertificateConfig
    /**
     * An object that specifies the TLS configuration for a domain.
     */
    public val tlsConfig: aws.sdk.kotlin.services.iot.model.TlsConfig? = builder.tlsConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainConfigurationRequest(")
        append("applicationProtocol=$applicationProtocol,")
        append("authenticationType=$authenticationType,")
        append("authorizerConfig=$authorizerConfig,")
        append("clientCertificateConfig=$clientCertificateConfig,")
        append("domainConfigurationName=$domainConfigurationName,")
        append("domainConfigurationStatus=$domainConfigurationStatus,")
        append("removeAuthorizerConfig=$removeAuthorizerConfig,")
        append("serverCertificateConfig=$serverCertificateConfig,")
        append("tlsConfig=$tlsConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationProtocol?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateConfig?.hashCode() ?: 0)
        result = 31 * result + (domainConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (domainConfigurationStatus?.hashCode() ?: 0)
        result = 31 * result + (removeAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateConfig?.hashCode() ?: 0)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDomainConfigurationRequest

        if (applicationProtocol != other.applicationProtocol) return false
        if (authenticationType != other.authenticationType) return false
        if (authorizerConfig != other.authorizerConfig) return false
        if (clientCertificateConfig != other.clientCertificateConfig) return false
        if (domainConfigurationName != other.domainConfigurationName) return false
        if (domainConfigurationStatus != other.domainConfigurationStatus) return false
        if (removeAuthorizerConfig != other.removeAuthorizerConfig) return false
        if (serverCertificateConfig != other.serverCertificateConfig) return false
        if (tlsConfig != other.tlsConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An enumerated string that speciﬁes the application-layer protocol.
         * + `SECURE_MQTT` - MQTT over TLS.
         *
         * + `MQTT_WSS` - MQTT over WebSocket.
         *
         * + `HTTPS` - HTTP over TLS.
         *
         * + `DEFAULT` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify application_layer protocol. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
         */
        public var applicationProtocol: aws.sdk.kotlin.services.iot.model.ApplicationProtocol? = null
        /**
         * An enumerated string that speciﬁes the authentication type.
         * + `CUSTOM_AUTH_X509` - Use custom authentication and authorization with additional details from the X.509 client certificate.
         *
         * + `CUSTOM_AUTH` - Use custom authentication and authorization. For more information, see [Custom authentication and authorization](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
         *
         * + `AWS_X509` - Use X.509 client certificates without custom authentication and authorization. For more information, see [X.509 client certificates](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html).
         *
         * + `AWS_SIGV4` - Use Amazon Web Services Signature Version 4. For more information, see [IAM users, groups, and roles](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
         *
         * + `DEFAULT ` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify authentication type. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
         */
        public var authenticationType: aws.sdk.kotlin.services.iot.model.AuthenticationType? = null
        /**
         * An object that specifies the authorization service for a domain.
         */
        public var authorizerConfig: aws.sdk.kotlin.services.iot.model.AuthorizerConfig? = null
        /**
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         */
        public var clientCertificateConfig: aws.sdk.kotlin.services.iot.model.ClientCertificateConfig? = null
        /**
         * The name of the domain configuration to be updated.
         */
        public var domainConfigurationName: kotlin.String? = null
        /**
         * The status to which the domain configuration should be updated.
         */
        public var domainConfigurationStatus: aws.sdk.kotlin.services.iot.model.DomainConfigurationStatus? = null
        /**
         * Removes the authorization configuration from a domain.
         */
        public var removeAuthorizerConfig: kotlin.Boolean? = null
        /**
         * The server certificate configuration.
         */
        public var serverCertificateConfig: aws.sdk.kotlin.services.iot.model.ServerCertificateConfig? = null
        /**
         * An object that specifies the TLS configuration for a domain.
         */
        public var tlsConfig: aws.sdk.kotlin.services.iot.model.TlsConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationRequest) : this() {
            this.applicationProtocol = x.applicationProtocol
            this.authenticationType = x.authenticationType
            this.authorizerConfig = x.authorizerConfig
            this.clientCertificateConfig = x.clientCertificateConfig
            this.domainConfigurationName = x.domainConfigurationName
            this.domainConfigurationStatus = x.domainConfigurationStatus
            this.removeAuthorizerConfig = x.removeAuthorizerConfig
            this.serverCertificateConfig = x.serverCertificateConfig
            this.tlsConfig = x.tlsConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationRequest = UpdateDomainConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AuthorizerConfig] inside the given [block]
         */
        public fun authorizerConfig(block: aws.sdk.kotlin.services.iot.model.AuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.authorizerConfig = aws.sdk.kotlin.services.iot.model.AuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ClientCertificateConfig] inside the given [block]
         */
        public fun clientCertificateConfig(block: aws.sdk.kotlin.services.iot.model.ClientCertificateConfig.Builder.() -> kotlin.Unit) {
            this.clientCertificateConfig = aws.sdk.kotlin.services.iot.model.ClientCertificateConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ServerCertificateConfig] inside the given [block]
         */
        public fun serverCertificateConfig(block: aws.sdk.kotlin.services.iot.model.ServerCertificateConfig.Builder.() -> kotlin.Unit) {
            this.serverCertificateConfig = aws.sdk.kotlin.services.iot.model.ServerCertificateConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TlsConfig] inside the given [block]
         */
        public fun tlsConfig(block: aws.sdk.kotlin.services.iot.model.TlsConfig.Builder.() -> kotlin.Unit) {
            this.tlsConfig = aws.sdk.kotlin.services.iot.model.TlsConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
