// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes how to interpret an application-defined timestamp value from an MQTT message payload and the precision of that value.
 */
public class TimestreamTimestamp private constructor(builder: Builder) {
    /**
     * The precision of the timestamp value that results from the expression described in `value`.
     *
     * Valid values: `SECONDS` | `MILLISECONDS` | `MICROSECONDS` | `NANOSECONDS`. The default is `MILLISECONDS`.
     */
    public val unit: kotlin.String = requireNotNull(builder.unit) { "A non-null value must be provided for unit" }
    /**
     * An expression that returns a long epoch time value.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TimestreamTimestamp = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimestreamTimestamp(")
        append("unit=$unit,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = unit.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimestreamTimestamp

        if (unit != other.unit) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TimestreamTimestamp = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The precision of the timestamp value that results from the expression described in `value`.
         *
         * Valid values: `SECONDS` | `MILLISECONDS` | `MICROSECONDS` | `NANOSECONDS`. The default is `MILLISECONDS`.
         */
        public var unit: kotlin.String? = null
        /**
         * An expression that returns a long epoch time value.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TimestreamTimestamp) : this() {
            this.unit = x.unit
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TimestreamTimestamp = TimestreamTimestamp(this)

        internal fun correctErrors(): Builder {
            if (unit == null) unit = ""
            if (value == null) value = ""
            return this
        }
    }
}
