// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies MQTT Version 5.0 headers information. For more information, see [ MQTT](https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html) from Amazon Web Services IoT Core Developer Guide.
 */
public class MqttHeaders private constructor(builder: Builder) {
    /**
     * A UTF-8 encoded string that describes the content of the publishing message.
     *
     * For more information, see [ Content Type](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118) from the MQTT Version 5.0 specification.
     *
     * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The base64-encoded binary data used by the sender of the request message to identify which request the response message is for when it's received.
     *
     * For more information, see [ Correlation Data](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115) from the MQTT Version 5.0 specification.
     *
     *  This binary data must be based64-encoded.
     *
     * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
     */
    public val correlationData: kotlin.String? = builder.correlationData
    /**
     * A user-defined integer value that will persist a message at the message broker for a specified amount of time to ensure that the message will expire if it's no longer relevant to the subscriber. The value of `messageExpiry` represents the number of seconds before it expires. For more information about the limits of `messageExpiry`, see [Amazon Web Services IoT Core message broker and protocol limits and quotas ](https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html) from the Amazon Web Services Reference Guide.
     *
     * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
     */
    public val messageExpiry: kotlin.String? = builder.messageExpiry
    /**
     * An `Enum` string value that indicates whether the payload is formatted as UTF-8.
     *
     * Valid values are `UNSPECIFIED_BYTES` and `UTF8_DATA`.
     *
     * For more information, see [ Payload Format Indicator](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111) from the MQTT Version 5.0 specification.
     *
     * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
     */
    public val payloadFormatIndicator: kotlin.String? = builder.payloadFormatIndicator
    /**
     * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to describe the topic which the receiver should publish to as part of the request-response flow. The topic must not contain wildcard characters.
     *
     * For more information, see [ Response Topic](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114) from the MQTT Version 5.0 specification.
     *
     * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
     */
    public val responseTopic: kotlin.String? = builder.responseTopic
    /**
     * An array of key-value pairs that you define in the MQTT5 header.
     */
    public val userProperties: List<UserProperty>? = builder.userProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.MqttHeaders = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MqttHeaders(")
        append("contentType=$contentType,")
        append("correlationData=$correlationData,")
        append("messageExpiry=$messageExpiry,")
        append("payloadFormatIndicator=$payloadFormatIndicator,")
        append("responseTopic=$responseTopic,")
        append("userProperties=$userProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (correlationData?.hashCode() ?: 0)
        result = 31 * result + (messageExpiry?.hashCode() ?: 0)
        result = 31 * result + (payloadFormatIndicator?.hashCode() ?: 0)
        result = 31 * result + (responseTopic?.hashCode() ?: 0)
        result = 31 * result + (userProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MqttHeaders

        if (contentType != other.contentType) return false
        if (correlationData != other.correlationData) return false
        if (messageExpiry != other.messageExpiry) return false
        if (payloadFormatIndicator != other.payloadFormatIndicator) return false
        if (responseTopic != other.responseTopic) return false
        if (userProperties != other.userProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.MqttHeaders = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A UTF-8 encoded string that describes the content of the publishing message.
         *
         * For more information, see [ Content Type](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118) from the MQTT Version 5.0 specification.
         *
         * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
         */
        public var contentType: kotlin.String? = null
        /**
         * The base64-encoded binary data used by the sender of the request message to identify which request the response message is for when it's received.
         *
         * For more information, see [ Correlation Data](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115) from the MQTT Version 5.0 specification.
         *
         *  This binary data must be based64-encoded.
         *
         * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
         */
        public var correlationData: kotlin.String? = null
        /**
         * A user-defined integer value that will persist a message at the message broker for a specified amount of time to ensure that the message will expire if it's no longer relevant to the subscriber. The value of `messageExpiry` represents the number of seconds before it expires. For more information about the limits of `messageExpiry`, see [Amazon Web Services IoT Core message broker and protocol limits and quotas ](https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html) from the Amazon Web Services Reference Guide.
         *
         * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
         */
        public var messageExpiry: kotlin.String? = null
        /**
         * An `Enum` string value that indicates whether the payload is formatted as UTF-8.
         *
         * Valid values are `UNSPECIFIED_BYTES` and `UTF8_DATA`.
         *
         * For more information, see [ Payload Format Indicator](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111) from the MQTT Version 5.0 specification.
         *
         * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
         */
        public var payloadFormatIndicator: kotlin.String? = null
        /**
         * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to describe the topic which the receiver should publish to as part of the request-response flow. The topic must not contain wildcard characters.
         *
         * For more information, see [ Response Topic](https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114) from the MQTT Version 5.0 specification.
         *
         * Supports [substitution templates](https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html).
         */
        public var responseTopic: kotlin.String? = null
        /**
         * An array of key-value pairs that you define in the MQTT5 header.
         */
        public var userProperties: List<UserProperty>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.MqttHeaders) : this() {
            this.contentType = x.contentType
            this.correlationData = x.correlationData
            this.messageExpiry = x.messageExpiry
            this.payloadFormatIndicator = x.payloadFormatIndicator
            this.responseTopic = x.responseTopic
            this.userProperties = x.userProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.MqttHeaders = MqttHeaders(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
