// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an action to write to a DynamoDB table.
 *
 * The `tableName`, `hashKeyField`, and `rangeKeyField` values must match the values used when you created the table.
 *
 * The `hashKeyValue` and `rangeKeyvalue` fields use a substitution template syntax. These templates provide data at runtime. The syntax is as follows: ${*sql-expression*}.
 *
 * You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons, calculations, and functions. For example, the following field uses the third level of the topic:
 *
 * `"hashKeyValue": "${topic(3)}"`
 *
 * The following field uses the timestamp:
 *
 * `"rangeKeyValue": "${timestamp()}"`
 */
public class DynamoDbAction private constructor(builder: Builder) {
    /**
     * The hash key name.
     */
    public val hashKeyField: kotlin.String = requireNotNull(builder.hashKeyField) { "A non-null value must be provided for hashKeyField" }
    /**
     * The hash key type. Valid values are "STRING" or "NUMBER"
     */
    public val hashKeyType: aws.sdk.kotlin.services.iot.model.DynamoKeyType? = builder.hashKeyType
    /**
     * The hash key value.
     */
    public val hashKeyValue: kotlin.String = requireNotNull(builder.hashKeyValue) { "A non-null value must be provided for hashKeyValue" }
    /**
     * The type of operation to be performed. This follows the substitution template, so it can be `${operation}`, but the substitution must result in one of the following: `INSERT`, `UPDATE`, or `DELETE`.
     */
    public val operation: kotlin.String? = builder.operation
    /**
     * The action payload. This name can be customized.
     */
    public val payloadField: kotlin.String? = builder.payloadField
    /**
     * The range key name.
     */
    public val rangeKeyField: kotlin.String? = builder.rangeKeyField
    /**
     * The range key type. Valid values are "STRING" or "NUMBER"
     */
    public val rangeKeyType: aws.sdk.kotlin.services.iot.model.DynamoKeyType? = builder.rangeKeyType
    /**
     * The range key value.
     */
    public val rangeKeyValue: kotlin.String? = builder.rangeKeyValue
    /**
     * The ARN of the IAM role that grants access to the DynamoDB table.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The name of the DynamoDB table.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DynamoDbAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DynamoDbAction(")
        append("hashKeyField=$hashKeyField,")
        append("hashKeyType=$hashKeyType,")
        append("hashKeyValue=$hashKeyValue,")
        append("operation=$operation,")
        append("payloadField=$payloadField,")
        append("rangeKeyField=$rangeKeyField,")
        append("rangeKeyType=$rangeKeyType,")
        append("rangeKeyValue=$rangeKeyValue,")
        append("roleArn=$roleArn,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hashKeyField.hashCode()
        result = 31 * result + (hashKeyType?.hashCode() ?: 0)
        result = 31 * result + (hashKeyValue.hashCode())
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (payloadField?.hashCode() ?: 0)
        result = 31 * result + (rangeKeyField?.hashCode() ?: 0)
        result = 31 * result + (rangeKeyType?.hashCode() ?: 0)
        result = 31 * result + (rangeKeyValue?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DynamoDbAction

        if (hashKeyField != other.hashKeyField) return false
        if (hashKeyType != other.hashKeyType) return false
        if (hashKeyValue != other.hashKeyValue) return false
        if (operation != other.operation) return false
        if (payloadField != other.payloadField) return false
        if (rangeKeyField != other.rangeKeyField) return false
        if (rangeKeyType != other.rangeKeyType) return false
        if (rangeKeyValue != other.rangeKeyValue) return false
        if (roleArn != other.roleArn) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DynamoDbAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The hash key name.
         */
        public var hashKeyField: kotlin.String? = null
        /**
         * The hash key type. Valid values are "STRING" or "NUMBER"
         */
        public var hashKeyType: aws.sdk.kotlin.services.iot.model.DynamoKeyType? = null
        /**
         * The hash key value.
         */
        public var hashKeyValue: kotlin.String? = null
        /**
         * The type of operation to be performed. This follows the substitution template, so it can be `${operation}`, but the substitution must result in one of the following: `INSERT`, `UPDATE`, or `DELETE`.
         */
        public var operation: kotlin.String? = null
        /**
         * The action payload. This name can be customized.
         */
        public var payloadField: kotlin.String? = null
        /**
         * The range key name.
         */
        public var rangeKeyField: kotlin.String? = null
        /**
         * The range key type. Valid values are "STRING" or "NUMBER"
         */
        public var rangeKeyType: aws.sdk.kotlin.services.iot.model.DynamoKeyType? = null
        /**
         * The range key value.
         */
        public var rangeKeyValue: kotlin.String? = null
        /**
         * The ARN of the IAM role that grants access to the DynamoDB table.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the DynamoDB table.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DynamoDbAction) : this() {
            this.hashKeyField = x.hashKeyField
            this.hashKeyType = x.hashKeyType
            this.hashKeyValue = x.hashKeyValue
            this.operation = x.operation
            this.payloadField = x.payloadField
            this.rangeKeyField = x.rangeKeyField
            this.rangeKeyType = x.rangeKeyType
            this.rangeKeyValue = x.rangeKeyValue
            this.roleArn = x.roleArn
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DynamoDbAction = DynamoDbAction(this)

        internal fun correctErrors(): Builder {
            if (hashKeyField == null) hashKeyField = ""
            if (hashKeyValue == null) hashKeyValue = ""
            if (roleArn == null) roleArn = ""
            if (tableName == null) tableName = ""
            return this
        }
    }
}
