// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeProvisioningTemplateResponse private constructor(builder: Builder) {
    /**
     * The date when the provisioning template was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The default fleet template version ID.
     */
    public val defaultVersionId: kotlin.Int? = builder.defaultVersionId
    /**
     * The description of the provisioning template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * True if the provisioning template is enabled, otherwise false.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The date when the provisioning template was last modified.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * Gets information about a pre-provisioned hook.
     */
    public val preProvisioningHook: aws.sdk.kotlin.services.iot.model.ProvisioningHook? = builder.preProvisioningHook
    /**
     * The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.
     */
    public val provisioningRoleArn: kotlin.String? = builder.provisioningRoleArn
    /**
     * The ARN of the provisioning template.
     */
    public val templateArn: kotlin.String? = builder.templateArn
    /**
     * The JSON formatted contents of the provisioning template.
     */
    public val templateBody: kotlin.String? = builder.templateBody
    /**
     * The name of the provisioning template.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * The type you define in a provisioning template. You can create a template with only one type. You can't change the template type after its creation. The default value is `FLEET_PROVISIONING`. For more information about provisioning template, see: [Provisioning template](https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html).
     */
    public val type: aws.sdk.kotlin.services.iot.model.TemplateType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeProvisioningTemplateResponse(")
        append("creationDate=$creationDate,")
        append("defaultVersionId=$defaultVersionId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("preProvisioningHook=$preProvisioningHook,")
        append("provisioningRoleArn=$provisioningRoleArn,")
        append("templateArn=$templateArn,")
        append("templateBody=$templateBody,")
        append("templateName=$templateName,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (defaultVersionId ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (preProvisioningHook?.hashCode() ?: 0)
        result = 31 * result + (provisioningRoleArn?.hashCode() ?: 0)
        result = 31 * result + (templateArn?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeProvisioningTemplateResponse

        if (creationDate != other.creationDate) return false
        if (defaultVersionId != other.defaultVersionId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (preProvisioningHook != other.preProvisioningHook) return false
        if (provisioningRoleArn != other.provisioningRoleArn) return false
        if (templateArn != other.templateArn) return false
        if (templateBody != other.templateBody) return false
        if (templateName != other.templateName) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date when the provisioning template was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The default fleet template version ID.
         */
        public var defaultVersionId: kotlin.Int? = null
        /**
         * The description of the provisioning template.
         */
        public var description: kotlin.String? = null
        /**
         * True if the provisioning template is enabled, otherwise false.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The date when the provisioning template was last modified.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Gets information about a pre-provisioned hook.
         */
        public var preProvisioningHook: aws.sdk.kotlin.services.iot.model.ProvisioningHook? = null
        /**
         * The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.
         */
        public var provisioningRoleArn: kotlin.String? = null
        /**
         * The ARN of the provisioning template.
         */
        public var templateArn: kotlin.String? = null
        /**
         * The JSON formatted contents of the provisioning template.
         */
        public var templateBody: kotlin.String? = null
        /**
         * The name of the provisioning template.
         */
        public var templateName: kotlin.String? = null
        /**
         * The type you define in a provisioning template. You can create a template with only one type. You can't change the template type after its creation. The default value is `FLEET_PROVISIONING`. For more information about provisioning template, see: [Provisioning template](https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html).
         */
        public var type: aws.sdk.kotlin.services.iot.model.TemplateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateResponse) : this() {
            this.creationDate = x.creationDate
            this.defaultVersionId = x.defaultVersionId
            this.description = x.description
            this.enabled = x.enabled
            this.lastModifiedDate = x.lastModifiedDate
            this.preProvisioningHook = x.preProvisioningHook
            this.provisioningRoleArn = x.provisioningRoleArn
            this.templateArn = x.templateArn
            this.templateBody = x.templateBody
            this.templateName = x.templateName
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.DescribeProvisioningTemplateResponse = DescribeProvisioningTemplateResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ProvisioningHook] inside the given [block]
         */
        public fun preProvisioningHook(block: aws.sdk.kotlin.services.iot.model.ProvisioningHook.Builder.() -> kotlin.Unit) {
            this.preProvisioningHook = aws.sdk.kotlin.services.iot.model.ProvisioningHook.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
