// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDomainConfigurationRequest private constructor(builder: Builder) {
    /**
     * An enumerated string that speciﬁes the application-layer protocol.
     * + `SECURE_MQTT` - MQTT over TLS.
     *
     * + `MQTT_WSS` - MQTT over WebSocket.
     *
     * + `HTTPS` - HTTP over TLS.
     *
     * + `DEFAULT` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify application_layer protocol. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
     */
    public val applicationProtocol: aws.sdk.kotlin.services.iot.model.ApplicationProtocol? = builder.applicationProtocol
    /**
     * An enumerated string that speciﬁes the authentication type.
     * + `CUSTOM_AUTH_X509` - Use custom authentication and authorization with additional details from the X.509 client certificate.
     *
     * + `CUSTOM_AUTH` - Use custom authentication and authorization. For more information, see [Custom authentication and authorization](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
     *
     * + `AWS_X509` - Use X.509 client certificates without custom authentication and authorization. For more information, see [X.509 client certificates](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html).
     *
     * + `AWS_SIGV4` - Use Amazon Web Services Signature Version 4. For more information, see [IAM users, groups, and roles](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
     *
     * + `DEFAULT` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify authentication type. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
     */
    public val authenticationType: aws.sdk.kotlin.services.iot.model.AuthenticationType? = builder.authenticationType
    /**
     * An object that specifies the authorization service for a domain.
     */
    public val authorizerConfig: aws.sdk.kotlin.services.iot.model.AuthorizerConfig? = builder.authorizerConfig
    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    public val clientCertificateConfig: aws.sdk.kotlin.services.iot.model.ClientCertificateConfig? = builder.clientCertificateConfig
    /**
     * The name of the domain configuration. This value must be unique to a region.
     */
    public val domainConfigurationName: kotlin.String? = builder.domainConfigurationName
    /**
     * The name of the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.
     */
    public val serverCertificateArns: List<String>? = builder.serverCertificateArns
    /**
     * The server certificate configuration.
     */
    public val serverCertificateConfig: aws.sdk.kotlin.services.iot.model.ServerCertificateConfig? = builder.serverCertificateConfig
    /**
     * The type of service delivered by the endpoint.
     *
     * Amazon Web Services IoT Core currently supports only the `DATA` service type.
     */
    public val serviceType: aws.sdk.kotlin.services.iot.model.ServiceType? = builder.serviceType
    /**
     * Metadata which can be used to manage the domain configuration.
     *
     * For URI Request parameters use format: ...key1=value1&key2=value2...
     *
     * For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     *
     * For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An object that specifies the TLS configuration for a domain.
     */
    public val tlsConfig: aws.sdk.kotlin.services.iot.model.TlsConfig? = builder.tlsConfig
    /**
     * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.
     */
    public val validationCertificateArn: kotlin.String? = builder.validationCertificateArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainConfigurationRequest(")
        append("applicationProtocol=$applicationProtocol,")
        append("authenticationType=$authenticationType,")
        append("authorizerConfig=$authorizerConfig,")
        append("clientCertificateConfig=$clientCertificateConfig,")
        append("domainConfigurationName=$domainConfigurationName,")
        append("domainName=$domainName,")
        append("serverCertificateArns=$serverCertificateArns,")
        append("serverCertificateConfig=$serverCertificateConfig,")
        append("serviceType=$serviceType,")
        append("tags=$tags,")
        append("tlsConfig=$tlsConfig,")
        append("validationCertificateArn=$validationCertificateArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationProtocol?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateConfig?.hashCode() ?: 0)
        result = 31 * result + (domainConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateArns?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateConfig?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        result = 31 * result + (validationCertificateArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDomainConfigurationRequest

        if (applicationProtocol != other.applicationProtocol) return false
        if (authenticationType != other.authenticationType) return false
        if (authorizerConfig != other.authorizerConfig) return false
        if (clientCertificateConfig != other.clientCertificateConfig) return false
        if (domainConfigurationName != other.domainConfigurationName) return false
        if (domainName != other.domainName) return false
        if (serverCertificateArns != other.serverCertificateArns) return false
        if (serverCertificateConfig != other.serverCertificateConfig) return false
        if (serviceType != other.serviceType) return false
        if (tags != other.tags) return false
        if (tlsConfig != other.tlsConfig) return false
        if (validationCertificateArn != other.validationCertificateArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An enumerated string that speciﬁes the application-layer protocol.
         * + `SECURE_MQTT` - MQTT over TLS.
         *
         * + `MQTT_WSS` - MQTT over WebSocket.
         *
         * + `HTTPS` - HTTP over TLS.
         *
         * + `DEFAULT` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify application_layer protocol. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
         */
        public var applicationProtocol: aws.sdk.kotlin.services.iot.model.ApplicationProtocol? = null
        /**
         * An enumerated string that speciﬁes the authentication type.
         * + `CUSTOM_AUTH_X509` - Use custom authentication and authorization with additional details from the X.509 client certificate.
         *
         * + `CUSTOM_AUTH` - Use custom authentication and authorization. For more information, see [Custom authentication and authorization](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
         *
         * + `AWS_X509` - Use X.509 client certificates without custom authentication and authorization. For more information, see [X.509 client certificates](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html).
         *
         * + `AWS_SIGV4` - Use Amazon Web Services Signature Version 4. For more information, see [IAM users, groups, and roles](https://docs.aws.amazon.com/iot/latest/developerguide/custom-authentication.html).
         *
         * + `DEFAULT` - Use a combination of port and Application Layer Protocol Negotiation (ALPN) to specify authentication type. For more information, see [Device communication protocols](https://docs.aws.amazon.com/iot/latest/developerguide/protocols.html).
         */
        public var authenticationType: aws.sdk.kotlin.services.iot.model.AuthenticationType? = null
        /**
         * An object that specifies the authorization service for a domain.
         */
        public var authorizerConfig: aws.sdk.kotlin.services.iot.model.AuthorizerConfig? = null
        /**
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         */
        public var clientCertificateConfig: aws.sdk.kotlin.services.iot.model.ClientCertificateConfig? = null
        /**
         * The name of the domain configuration. This value must be unique to a region.
         */
        public var domainConfigurationName: kotlin.String? = null
        /**
         * The name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.
         */
        public var serverCertificateArns: List<String>? = null
        /**
         * The server certificate configuration.
         */
        public var serverCertificateConfig: aws.sdk.kotlin.services.iot.model.ServerCertificateConfig? = null
        /**
         * The type of service delivered by the endpoint.
         *
         * Amazon Web Services IoT Core currently supports only the `DATA` service type.
         */
        public var serviceType: aws.sdk.kotlin.services.iot.model.ServiceType? = null
        /**
         * Metadata which can be used to manage the domain configuration.
         *
         * For URI Request parameters use format: ...key1=value1&key2=value2...
         *
         * For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
         *
         * For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
         */
        public var tags: List<Tag>? = null
        /**
         * An object that specifies the TLS configuration for a domain.
         */
        public var tlsConfig: aws.sdk.kotlin.services.iot.model.TlsConfig? = null
        /**
         * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.
         */
        public var validationCertificateArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest) : this() {
            this.applicationProtocol = x.applicationProtocol
            this.authenticationType = x.authenticationType
            this.authorizerConfig = x.authorizerConfig
            this.clientCertificateConfig = x.clientCertificateConfig
            this.domainConfigurationName = x.domainConfigurationName
            this.domainName = x.domainName
            this.serverCertificateArns = x.serverCertificateArns
            this.serverCertificateConfig = x.serverCertificateConfig
            this.serviceType = x.serviceType
            this.tags = x.tags
            this.tlsConfig = x.tlsConfig
            this.validationCertificateArn = x.validationCertificateArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.CreateDomainConfigurationRequest = CreateDomainConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.AuthorizerConfig] inside the given [block]
         */
        public fun authorizerConfig(block: aws.sdk.kotlin.services.iot.model.AuthorizerConfig.Builder.() -> kotlin.Unit) {
            this.authorizerConfig = aws.sdk.kotlin.services.iot.model.AuthorizerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ClientCertificateConfig] inside the given [block]
         */
        public fun clientCertificateConfig(block: aws.sdk.kotlin.services.iot.model.ClientCertificateConfig.Builder.() -> kotlin.Unit) {
            this.clientCertificateConfig = aws.sdk.kotlin.services.iot.model.ClientCertificateConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.ServerCertificateConfig] inside the given [block]
         */
        public fun serverCertificateConfig(block: aws.sdk.kotlin.services.iot.model.ServerCertificateConfig.Builder.() -> kotlin.Unit) {
            this.serverCertificateConfig = aws.sdk.kotlin.services.iot.model.ServerCertificateConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.TlsConfig] inside the given [block]
         */
        public fun tlsConfig(block: aws.sdk.kotlin.services.iot.model.TlsConfig.Builder.() -> kotlin.Unit) {
            this.tlsConfig = aws.sdk.kotlin.services.iot.model.TlsConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
