// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a certificate.
 */
public class Certificate private constructor(builder: Builder) {
    /**
     * The ARN of the certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
     */
    public val certificateId: kotlin.String? = builder.certificateId
    /**
     * The mode of the certificate.
     *
     * `DEFAULT`: A certificate in `DEFAULT` mode is either generated by Amazon Web Services IoT Core or registered with an issuer certificate authority (CA) in `DEFAULT` mode. Devices with certificates in `DEFAULT` mode aren't required to send the Server Name Indication (SNI) extension when connecting to Amazon Web Services IoT Core. However, to use features such as custom domains and VPC endpoints, we recommend that you use the SNI extension when connecting to Amazon Web Services IoT Core.
     *
     * `SNI_ONLY`: A certificate in `SNI_ONLY` mode is registered without an issuer CA. Devices with certificates in `SNI_ONLY` mode must send the SNI extension when connecting to Amazon Web Services IoT Core.
     */
    public val certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = builder.certificateMode
    /**
     * The date and time the certificate was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The status of the certificate.
     *
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     */
    public val status: aws.sdk.kotlin.services.iot.model.CertificateStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.Certificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Certificate(")
        append("certificateArn=$certificateArn,")
        append("certificateId=$certificateId,")
        append("certificateMode=$certificateMode,")
        append("creationDate=$creationDate,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateId?.hashCode() ?: 0)
        result = 31 * result + (certificateMode?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Certificate

        if (certificateArn != other.certificateArn) return false
        if (certificateId != other.certificateId) return false
        if (certificateMode != other.certificateMode) return false
        if (creationDate != other.creationDate) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.Certificate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)
         */
        public var certificateId: kotlin.String? = null
        /**
         * The mode of the certificate.
         *
         * `DEFAULT`: A certificate in `DEFAULT` mode is either generated by Amazon Web Services IoT Core or registered with an issuer certificate authority (CA) in `DEFAULT` mode. Devices with certificates in `DEFAULT` mode aren't required to send the Server Name Indication (SNI) extension when connecting to Amazon Web Services IoT Core. However, to use features such as custom domains and VPC endpoints, we recommend that you use the SNI extension when connecting to Amazon Web Services IoT Core.
         *
         * `SNI_ONLY`: A certificate in `SNI_ONLY` mode is registered without an issuer CA. Devices with certificates in `SNI_ONLY` mode must send the SNI extension when connecting to Amazon Web Services IoT Core.
         */
        public var certificateMode: aws.sdk.kotlin.services.iot.model.CertificateMode? = null
        /**
         * The date and time the certificate was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the certificate.
         *
         * The status value REGISTER_INACTIVE is deprecated and should not be used.
         */
        public var status: aws.sdk.kotlin.services.iot.model.CertificateStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.Certificate) : this() {
            this.certificateArn = x.certificateArn
            this.certificateId = x.certificateId
            this.certificateMode = x.certificateMode
            this.creationDate = x.creationDate
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.Certificate = Certificate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
