// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The criteria that determine when and how a job abort takes place.
 */
public class AwsJobAbortCriteria private constructor(builder: Builder) {
    /**
     * The type of job action to take to initiate the job abort.
     */
    public val action: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaAbortAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The type of job execution failures that can initiate a job abort.
     */
    public val failureType: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaFailureType = requireNotNull(builder.failureType) { "A non-null value must be provided for failureType" }
    /**
     * The minimum number of things which must receive job execution notifications before the job can be aborted.
     */
    public val minNumberOfExecutedThings: kotlin.Int = requireNotNull(builder.minNumberOfExecutedThings) { "A non-null value must be provided for minNumberOfExecutedThings" }
    /**
     * The minimum percentage of job execution failures that must occur to initiate the job abort.
     *
     * Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).
     */
    public val thresholdPercentage: kotlin.Double = requireNotNull(builder.thresholdPercentage) { "A non-null value must be provided for thresholdPercentage" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsJobAbortCriteria(")
        append("action=$action,")
        append("failureType=$failureType,")
        append("minNumberOfExecutedThings=$minNumberOfExecutedThings,")
        append("thresholdPercentage=$thresholdPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (failureType.hashCode())
        result = 31 * result + (minNumberOfExecutedThings)
        result = 31 * result + (thresholdPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsJobAbortCriteria

        if (action != other.action) return false
        if (failureType != other.failureType) return false
        if (minNumberOfExecutedThings != other.minNumberOfExecutedThings) return false
        if (!(thresholdPercentage?.equals(other.thresholdPercentage) ?: (other.thresholdPercentage == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of job action to take to initiate the job abort.
         */
        public var action: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaAbortAction? = null
        /**
         * The type of job execution failures that can initiate a job abort.
         */
        public var failureType: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteriaFailureType? = null
        /**
         * The minimum number of things which must receive job execution notifications before the job can be aborted.
         */
        public var minNumberOfExecutedThings: kotlin.Int? = null
        /**
         * The minimum percentage of job execution failures that must occur to initiate the job abort.
         *
         * Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).
         */
        public var thresholdPercentage: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria) : this() {
            this.action = x.action
            this.failureType = x.failureType
            this.minNumberOfExecutedThings = x.minNumberOfExecutedThings
            this.thresholdPercentage = x.thresholdPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.AwsJobAbortCriteria = AwsJobAbortCriteria(this)

        internal fun correctErrors(): Builder {
            if (action == null) action = AwsJobAbortCriteriaAbortAction.SdkUnknown("no value provided")
            if (failureType == null) failureType = AwsJobAbortCriteriaFailureType.SdkUnknown("no value provided")
            if (minNumberOfExecutedThings == null) minNumberOfExecutedThings = 0
            if (thresholdPercentage == null) thresholdPercentage = 0.0
            return this
        }
    }
}
