// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AlertTarget
import aws.sdk.kotlin.services.iot.model.AlertTargetType
import aws.sdk.kotlin.services.iot.model.Behavior
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.MetricToRetain
import aws.sdk.kotlin.services.iot.model.MetricsExportConfig
import aws.sdk.kotlin.services.iot.model.UpdateSecurityProfileResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateSecurityProfileOperationDeserializer: HttpDeserializer.NonStreaming<UpdateSecurityProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateSecurityProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSecurityProfileError(context, call, payload)
        }
        val builder = UpdateSecurityProfileResponse.Builder()

        if (payload != null) {
            deserializeUpdateSecurityProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateSecurityProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "VersionConflictException" -> VersionConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSecurityProfileOperationBody(builder: UpdateSecurityProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDITIONALMETRICSTORETAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalMetricsToRetain"))
    val ADDITIONALMETRICSTORETAINV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalMetricsToRetainV2"))
    val ALERTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("alertTargets"))
    val BEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("behaviors"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val METRICSEXPORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metricsExportConfig"))
    val SECURITYPROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("securityProfileArn"))
    val SECURITYPROFILEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("securityProfileDescription"))
    val SECURITYPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("securityProfileName"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALMETRICSTORETAIN_DESCRIPTOR)
        field(ADDITIONALMETRICSTORETAINV2_DESCRIPTOR)
        field(ALERTTARGETS_DESCRIPTOR)
        field(BEHAVIORS_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(METRICSEXPORTCONFIG_DESCRIPTOR)
        field(SECURITYPROFILEARN_DESCRIPTOR)
        field(SECURITYPROFILEDESCRIPTION_DESCRIPTOR)
        field(SECURITYPROFILENAME_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDITIONALMETRICSTORETAIN_DESCRIPTOR.index -> builder.additionalMetricsToRetain =
                    deserializer.deserializeList(ADDITIONALMETRICSTORETAIN_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ADDITIONALMETRICSTORETAINV2_DESCRIPTOR.index -> builder.additionalMetricsToRetainV2 =
                    deserializer.deserializeList(ADDITIONALMETRICSTORETAINV2_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricToRetain>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricToRetainDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ALERTTARGETS_DESCRIPTOR.index -> builder.alertTargets =
                    deserializer.deserializeMap(ALERTTARGETS_DESCRIPTOR) {
                        val map0 = mutableMapOf<AlertTargetType, AlertTarget>()
                        while (hasNextEntry()) {
                            val k0 = AlertTargetType.fromValue(key())
                            val v0 = if (nextHasValue()) { deserializeAlertTargetDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BEHAVIORS_DESCRIPTOR.index -> builder.behaviors =
                    deserializer.deserializeList(BEHAVIORS_DESCRIPTOR) {
                        val col0 = mutableListOf<Behavior>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBehaviorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                METRICSEXPORTCONFIG_DESCRIPTOR.index -> builder.metricsExportConfig = deserializeMetricsExportConfigDocument(deserializer)
                SECURITYPROFILEARN_DESCRIPTOR.index -> builder.securityProfileArn = deserializeString()
                SECURITYPROFILEDESCRIPTION_DESCRIPTOR.index -> builder.securityProfileDescription = deserializeString()
                SECURITYPROFILENAME_DESCRIPTOR.index -> builder.securityProfileName = deserializeString()
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
