// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.PackageVersionAction
import aws.sdk.kotlin.services.iot.model.PackageVersionArtifact
import aws.sdk.kotlin.services.iot.model.UpdatePackageVersionRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdatePackageVersionOperationSerializer: HttpSerializer.NonStreaming<UpdatePackageVersionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdatePackageVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.packageName) { "packageName is bound to the URI and must not be null" }
            requireNotNull(input.versionName) { "versionName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("packages"))
                add(PercentEncoding.SmithyLabel.encode(input.packageName))
                add(PercentEncoding.Path.encode("versions"))
                add(PercentEncoding.SmithyLabel.encode(input.versionName))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                add("clientToken", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
            }
        }

        val payload = serializeUpdatePackageVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdatePackageVersionOperationBody(context: ExecutionContext, input: UpdatePackageVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("action"))
    val ARTIFACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("artifact"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("attributes"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val RECIPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("recipe"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(ARTIFACT_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(RECIPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.action?.let { field(ACTION_DESCRIPTOR, it.value) }
        input.artifact?.let { field(ARTIFACT_DESCRIPTOR, it, ::serializePackageVersionArtifactDocument) }
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.recipe?.let { field(RECIPE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
