// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.ApplicationProtocol
import aws.sdk.kotlin.services.iot.model.AuthenticationType
import aws.sdk.kotlin.services.iot.model.AuthorizerConfig
import aws.sdk.kotlin.services.iot.model.ClientCertificateConfig
import aws.sdk.kotlin.services.iot.model.DomainConfigurationStatus
import aws.sdk.kotlin.services.iot.model.ServerCertificateConfig
import aws.sdk.kotlin.services.iot.model.TlsConfig
import aws.sdk.kotlin.services.iot.model.UpdateDomainConfigurationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDomainConfigurationOperationSerializer: HttpSerializer.NonStreaming<UpdateDomainConfigurationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDomainConfigurationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.domainConfigurationName) { "domainConfigurationName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domainConfigurations"))
                add(PercentEncoding.SmithyLabel.encode(input.domainConfigurationName))
            }
        }

        val payload = serializeUpdateDomainConfigurationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDomainConfigurationOperationBody(context: ExecutionContext, input: UpdateDomainConfigurationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPLICATIONPROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("applicationProtocol"))
    val AUTHENTICATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authenticationType"))
    val AUTHORIZERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorizerConfig"))
    val CLIENTCERTIFICATECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("clientCertificateConfig"))
    val DOMAINCONFIGURATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("domainConfigurationStatus"))
    val REMOVEAUTHORIZERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("removeAuthorizerConfig"))
    val SERVERCERTIFICATECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("serverCertificateConfig"))
    val TLSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONPROTOCOL_DESCRIPTOR)
        field(AUTHENTICATIONTYPE_DESCRIPTOR)
        field(AUTHORIZERCONFIG_DESCRIPTOR)
        field(CLIENTCERTIFICATECONFIG_DESCRIPTOR)
        field(DOMAINCONFIGURATIONSTATUS_DESCRIPTOR)
        field(REMOVEAUTHORIZERCONFIG_DESCRIPTOR)
        field(SERVERCERTIFICATECONFIG_DESCRIPTOR)
        field(TLSCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.applicationProtocol?.let { field(APPLICATIONPROTOCOL_DESCRIPTOR, it.value) }
        input.authenticationType?.let { field(AUTHENTICATIONTYPE_DESCRIPTOR, it.value) }
        input.authorizerConfig?.let { field(AUTHORIZERCONFIG_DESCRIPTOR, it, ::serializeAuthorizerConfigDocument) }
        input.clientCertificateConfig?.let { field(CLIENTCERTIFICATECONFIG_DESCRIPTOR, it, ::serializeClientCertificateConfigDocument) }
        input.domainConfigurationStatus?.let { field(DOMAINCONFIGURATIONSTATUS_DESCRIPTOR, it.value) }
        input.removeAuthorizerConfig?.let { field(REMOVEAUTHORIZERCONFIG_DESCRIPTOR, it) }
        input.serverCertificateConfig?.let { field(SERVERCERTIFICATECONFIG_DESCRIPTOR, it, ::serializeServerCertificateConfigDocument) }
        input.tlsConfig?.let { field(TLSCONFIG_DESCRIPTOR, it, ::serializeTlsConfigDocument) }
    }
    return serializer.toByteArray()
}
