// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.serde

import aws.sdk.kotlin.services.iot.model.AggregationType
import aws.sdk.kotlin.services.iot.model.DescribeFleetMetricResponse
import aws.sdk.kotlin.services.iot.model.FleetMetricUnit
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeFleetMetricOperationDeserializer: HttpDeserializer.NonStreaming<DescribeFleetMetricResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeFleetMetricResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFleetMetricError(context, call, payload)
        }
        val builder = DescribeFleetMetricResponse.Builder()

        if (payload != null) {
            deserializeDescribeFleetMetricOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeFleetMetricError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFleetMetricOperationBody(builder: DescribeFleetMetricResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGGREGATIONFIELD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("aggregationField"))
    val AGGREGATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("aggregationType"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val LASTMODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedDate"))
    val METRICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("metricArn"))
    val METRICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("metricName"))
    val PERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("period"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val UNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("unit"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATIONFIELD_DESCRIPTOR)
        field(AGGREGATIONTYPE_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(LASTMODIFIEDDATE_DESCRIPTOR)
        field(METRICARN_DESCRIPTOR)
        field(METRICNAME_DESCRIPTOR)
        field(PERIOD_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(UNIT_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGGREGATIONFIELD_DESCRIPTOR.index -> builder.aggregationField = deserializeString()
                AGGREGATIONTYPE_DESCRIPTOR.index -> builder.aggregationType = deserializeAggregationTypeDocument(deserializer)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INDEXNAME_DESCRIPTOR.index -> builder.indexName = deserializeString()
                LASTMODIFIEDDATE_DESCRIPTOR.index -> builder.lastModifiedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                METRICARN_DESCRIPTOR.index -> builder.metricArn = deserializeString()
                METRICNAME_DESCRIPTOR.index -> builder.metricName = deserializeString()
                PERIOD_DESCRIPTOR.index -> builder.period = deserializeInt()
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                QUERYVERSION_DESCRIPTOR.index -> builder.queryVersion = deserializeString()
                UNIT_DESCRIPTOR.index -> builder.unit = deserializeString().let { FleetMetricUnit.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
